/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.com.fasterxml.jackson.databind.ser.std;

import io.prestosql.hive.;
import io.prestosql.hive.$internal.com.fasterxml.jackson.core.JsonGenerator;
import io.prestosql.hive.$internal.com.fasterxml.jackson.core.JsonParser;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.BeanProperty;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.JavaType;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.JsonMappingException;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.JsonNode;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.JsonSerializer;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.SerializerProvider;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.prestosql.hive.$internal.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;

public class NumberSerializers {
    protected NumberSerializers() {
    }

    public static void addAll(Map<String, JsonSerializer<?>> allDeserializers) {
        IntegerSerializer intS = new IntegerSerializer();
        allDeserializers.put(Integer.class.getName(), intS);
        allDeserializers.put(Integer.TYPE.getName(), intS);
        allDeserializers.put(Long.class.getName(), LongSerializer.instance);
        allDeserializers.put(Long.TYPE.getName(), LongSerializer.instance);
        allDeserializers.put(Byte.class.getName(), IntLikeSerializer.instance);
        allDeserializers.put(Byte.TYPE.getName(), IntLikeSerializer.instance);
        allDeserializers.put(Short.class.getName(), ShortSerializer.instance);
        allDeserializers.put(Short.TYPE.getName(), ShortSerializer.instance);
        allDeserializers.put(Float.class.getName(), FloatSerializer.instance);
        allDeserializers.put(Float.TYPE.getName(), FloatSerializer.instance);
        allDeserializers.put(Double.class.getName(), DoubleSerializer.instance);
        allDeserializers.put(Double.TYPE.getName(), DoubleSerializer.instance);
    }

    @JacksonStdImpl
    public static final class DoubleSerializer
    extends Base<Object> {
        private static final Double EMPTY = 0.0;
        static final DoubleSerializer instance = new DoubleSerializer();

        public DoubleSerializer() {
            super(Double.class, JsonParser.NumberType.DOUBLE, "number");
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, Object value) {
            return EMPTY.equals(value);
        }

        @Override
        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber((Double)value);
        }

        @Override
        public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen, provider);
        }
    }

    @JacksonStdImpl
    public static final class FloatSerializer
    extends Base<Object> {
        private static final Float EMPTY = Float.valueOf(0.0f);
        static final FloatSerializer instance = new FloatSerializer();

        public FloatSerializer() {
            super(Float.class, JsonParser.NumberType.FLOAT, "number");
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, Object value) {
            return EMPTY.equals(value);
        }

        @Override
        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber(((Float)value).floatValue());
        }
    }

    @JacksonStdImpl
    public static final class LongSerializer
    extends Base<Object> {
        private static final Long EMPTY = 0L;
        static final LongSerializer instance = new LongSerializer();

        public LongSerializer() {
            super(Long.class, JsonParser.NumberType.LONG, "number");
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, Object value) {
            return EMPTY.equals(value);
        }

        @Override
        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber((Long)value);
        }
    }

    @JacksonStdImpl
    public static final class IntLikeSerializer
    extends Base<Number> {
        static final IntLikeSerializer instance = new IntLikeSerializer();

        public IntLikeSerializer() {
            super(Number.class, JsonParser.NumberType.INT, "integer");
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, Number value) {
            return value.intValue() == 0;
        }

        @Override
        public void serialize(Number value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber(value.intValue());
        }
    }

    @JacksonStdImpl
    public static final class IntegerSerializer
    extends Base<Object> {
        public IntegerSerializer() {
            super(Integer.class, JsonParser.NumberType.INT, "integer");
        }

        @Override
        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber((Integer)value);
        }

        @Override
        public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen, provider);
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, Object value) {
            return EMPTY_INTEGER.equals(value);
        }
    }

    @JacksonStdImpl
    public static final class ShortSerializer
    extends Base<Short> {
        private static final Short EMPTY = 0;
        static final ShortSerializer instance = new ShortSerializer();

        public ShortSerializer() {
            super(Short.class, JsonParser.NumberType.INT, "number");
        }

        @Override
        public boolean isEmpty(SerializerProvider prov, Short value) {
            return EMPTY.equals(value);
        }

        @Override
        public void serialize(Short value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeNumber(value);
        }
    }

    protected static abstract class Base<T>
    extends StdScalarSerializer<T>
    implements ContextualSerializer {
        protected static final Integer EMPTY_INTEGER = 0;
        protected final JsonParser.NumberType _numberType;
        protected final String _schemaType;
        protected final boolean _isInt;

        protected Base(Class<?> cls, JsonParser.NumberType numberType, String schemaType) {
            super(cls, false);
            this._numberType = numberType;
            this._schemaType = schemaType;
            this._isInt = numberType == JsonParser.NumberType.INT || numberType == JsonParser.NumberType.LONG || numberType == JsonParser.NumberType.BIG_INTEGER;
        }

        @Override
        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode(this._schemaType, true);
        }

        @Override
        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            if (this._isInt) {
                JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
                if (v2 != null) {
                    v2.numberType(this._numberType);
                }
            } else {
                JsonNumberFormatVisitor v2 = visitor.expectNumberFormat(typeHint);
                if (v2 != null) {
                    v2.numberType(this._numberType);
                }
            }
        }

        @Override
        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            .JsonFormat.Value format;
            AnnotatedMember m;
            if (property != null && (m = property.getMember()) != null && (format = prov.getAnnotationIntrospector().findFormat(m)) != null) {
                switch (format.getShape()) {
                    case STRING: {
                        return ToStringSerializer.instance;
                    }
                }
            }
            return this;
        }
    }
}

