/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.io.airlift.compress.lz4;

import io.prestosql.hive.$internal.io.airlift.compress.MalformedInputException;
import io.prestosql.hive.$internal.io.airlift.compress.lz4.UnsafeUtil;

public final class Lz4RawDecompressor {
    private static final int[] DEC_32_TABLE = new int[]{4, 1, 2, 1, 4, 4, 4, 4};
    private static final int[] DEC_64_TABLE = new int[]{0, 0, 0, -1, 0, 1, 2, 3};
    private static final int OFFSET_SIZE = 2;
    private static final int TOKEN_SIZE = 1;

    private Lz4RawDecompressor() {
    }

    public static int decompress(Object inputBase, long inputAddress, long inputLimit, Object outputBase, long outputAddress, long outputLimit) {
        long fastOutputLimit = outputLimit - 8L;
        long input = inputAddress;
        long output = outputAddress;
        if (inputAddress == inputLimit) {
            throw new MalformedInputException(0L, "input is empty");
        }
        if (outputAddress == outputLimit) {
            if (inputLimit - inputAddress == 1L && UnsafeUtil.UNSAFE.getByte(inputBase, inputAddress) == 0) {
                return 0;
            }
            return -1;
        }
        while (input < inputLimit) {
            long literalOutputLimit;
            int token;
            int literalLength;
            if ((literalLength = (token = UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF) >>> 4) == 15) {
                int value;
                do {
                    value = UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF;
                    literalLength += value;
                } while (value == 255 && input < inputLimit - 15L);
            }
            if ((literalOutputLimit = output + (long)literalLength) > fastOutputLimit - 4L || input + (long)literalLength > inputLimit - 8L) {
                if (literalOutputLimit > outputLimit) {
                    throw new MalformedInputException(input - inputAddress, "attempt to write last literal outside of destination buffer");
                }
                if (input + (long)literalLength != inputLimit) {
                    throw new MalformedInputException(input - inputAddress, "all input must be consumed");
                }
                UnsafeUtil.UNSAFE.copyMemory(inputBase, input, outputBase, output, literalLength);
                input += (long)literalLength;
                output += (long)literalLength;
                break;
            }
            do {
                UnsafeUtil.UNSAFE.putLong(outputBase, output, UnsafeUtil.UNSAFE.getLong(inputBase, input));
                input += 8L;
            } while ((output += 8L) < literalOutputLimit);
            input -= output - literalOutputLimit;
            output = literalOutputLimit;
            int offset = UnsafeUtil.UNSAFE.getShort(inputBase, input) & 0xFFFF;
            input += 2L;
            long matchAddress = output - (long)offset;
            if (matchAddress < outputAddress) {
                throw new MalformedInputException(input - inputAddress, "offset outside destination buffer");
            }
            int matchLength = token & 0xF;
            if (matchLength == 15) {
                int value;
                do {
                    if (input > inputLimit - 5L) {
                        throw new MalformedInputException(input - inputAddress);
                    }
                    value = UnsafeUtil.UNSAFE.getByte(inputBase, input++) & 0xFF;
                    matchLength += value;
                } while (value == 255);
            }
            long matchOutputLimit = output + (long)(matchLength += 4);
            if (offset < 8) {
                int increment32 = DEC_32_TABLE[offset];
                int decrement64 = DEC_64_TABLE[offset];
                UnsafeUtil.UNSAFE.putByte(outputBase, output, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress));
                UnsafeUtil.UNSAFE.putByte(outputBase, output + 1L, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress + 1L));
                UnsafeUtil.UNSAFE.putByte(outputBase, output + 2L, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress + 2L));
                UnsafeUtil.UNSAFE.putByte(outputBase, output + 3L, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress + 3L));
                UnsafeUtil.UNSAFE.putInt(outputBase, output += 4L, UnsafeUtil.UNSAFE.getInt(outputBase, matchAddress += (long)increment32));
                output += 4L;
                matchAddress -= (long)decrement64;
            } else {
                UnsafeUtil.UNSAFE.putLong(outputBase, output, UnsafeUtil.UNSAFE.getLong(outputBase, matchAddress));
                matchAddress += 8L;
                output += 8L;
            }
            if (matchOutputLimit > fastOutputLimit - 4L) {
                if (matchOutputLimit > outputLimit - 5L) {
                    throw new MalformedInputException(input - inputAddress, String.format("last %s bytes must be literals", 5));
                }
                while (output < fastOutputLimit) {
                    UnsafeUtil.UNSAFE.putLong(outputBase, output, UnsafeUtil.UNSAFE.getLong(outputBase, matchAddress));
                    matchAddress += 8L;
                    output += 8L;
                }
                while (output < matchOutputLimit) {
                    UnsafeUtil.UNSAFE.putByte(outputBase, output++, UnsafeUtil.UNSAFE.getByte(outputBase, matchAddress++));
                }
            } else {
                do {
                    UnsafeUtil.UNSAFE.putLong(outputBase, output, UnsafeUtil.UNSAFE.getLong(outputBase, matchAddress));
                    matchAddress += 8L;
                } while ((output += 8L) < matchOutputLimit);
            }
            output = matchOutputLimit;
        }
        return (int)(output - outputAddress);
    }
}

