/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.io.airlift.compress.snappy;

import io.prestosql.hive.$internal.io.airlift.compress.Decompressor;
import io.prestosql.hive.$internal.io.airlift.compress.MalformedInputException;
import io.prestosql.hive.$internal.io.airlift.compress.snappy.SnappyRawDecompressor;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class SnappyDecompressor
implements Decompressor {
    public static int getUncompressedLength(byte[] compressed, int compressedOffset) {
        long compressedAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressedOffset;
        long compressedLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressed.length;
        return SnappyRawDecompressor.getUncompressedLength(compressed, compressedAddress, compressedLimit);
    }

    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return SnappyRawDecompressor.decompress(input, inputAddress, inputLimit, output, outputAddress, outputLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompress(ByteBuffer input, ByteBuffer output) throws MalformedInputException {
        long outputLimit;
        long outputAddress;
        byte[] outputBase;
        long inputLimit;
        long inputAddress;
        byte[] inputBase;
        if (input instanceof DirectBuffer) {
            DirectBuffer direct = (DirectBuffer)((Object)input);
            inputBase = null;
            inputAddress = direct.address() + (long)input.position();
            inputLimit = direct.address() + (long)input.limit();
        } else if (input.hasArray()) {
            inputBase = input.array();
            inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + input.arrayOffset() + input.position();
            inputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + input.arrayOffset() + input.limit();
        } else {
            throw new IllegalArgumentException("Unsupported input ByteBuffer implementation " + input.getClass().getName());
        }
        if (output instanceof DirectBuffer) {
            DirectBuffer direct = (DirectBuffer)((Object)output);
            outputBase = null;
            outputAddress = direct.address() + (long)output.position();
            outputLimit = direct.address() + (long)output.limit();
        } else if (output.hasArray()) {
            outputBase = output.array();
            outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.position();
            outputLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + output.arrayOffset() + output.limit();
        } else {
            throw new IllegalArgumentException("Unsupported output ByteBuffer implementation " + output.getClass().getName());
        }
        ByteBuffer byteBuffer = input;
        synchronized (byteBuffer) {
            ByteBuffer byteBuffer2 = output;
            synchronized (byteBuffer2) {
                int written = SnappyRawDecompressor.decompress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit);
                output.position(output.position() + written);
            }
        }
    }
}

