/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.util;

import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinarySearch<E> {
    public static <T extends Comparable> BinarySearch<T> forList(final List<T> list) {
        return new BinarySearch<T>(){

            @Override
            protected int compare(int index, T element) {
                return ((Comparable)list.get(index)).compareTo(element);
            }

            @Override
            protected int getLastIndex() {
                return list.size() - 1;
            }
        };
    }

    public static <T> BinarySearch<T> forList(final List<T> list, final Comparator<T> comparator) {
        return new BinarySearch<T>(){

            @Override
            protected int compare(int index, T element) {
                return comparator.compare(list.get(index), element);
            }

            @Override
            protected int getLastIndex() {
                return list.size() - 1;
            }
        };
    }

    protected abstract int compare(int var1, E var2);

    protected abstract int getLastIndex();

    public int find(E element) {
        return this.find(element, 0, this.getLastIndex());
    }

    public int find(E element, int low) {
        return this.find(element, low, this.getLastIndex());
    }

    public int find(E element, int low, int high) {
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(mid, element);
            if (delta < 0) {
                low = mid + 1;
                continue;
            }
            if (delta > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int findFirst(E o) {
        return this.findFirst(o, 0, this.getLastIndex());
    }

    public int findFirst(E o, int low) {
        return this.findFirst(o, low, this.getLastIndex());
    }

    public int findFirst(E o, int low, int high) {
        int ndx = -1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(mid, o);
            if (delta < 0) {
                low = mid + 1;
                continue;
            }
            if (delta == 0) {
                ndx = mid;
            }
            high = mid - 1;
        }
        if (ndx == -1) {
            return -(low + 1);
        }
        return ndx;
    }

    public int findLast(E o) {
        return this.findLast(o, 0, this.getLastIndex());
    }

    public int findLast(E o, int low) {
        return this.findLast(o, low, this.getLastIndex());
    }

    public int findLast(E o, int low, int high) {
        int ndx = -1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int delta = this.compare(mid, o);
            if (delta > 0) {
                high = mid - 1;
                continue;
            }
            if (delta == 0) {
                ndx = mid;
            }
            low = mid + 1;
        }
        if (ndx == -1) {
            return -(low + 1);
        }
        return ndx;
    }
}

