/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.jodd.util.cl;

import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderLocal<T> {
    private final Map<ClassLoader, T> weakMap = new WeakHashMap<ClassLoader, T>();
    private T value;
    private boolean initialized;

    protected T initialValue() {
        return null;
    }

    public synchronized T get() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            T value = this.weakMap.get(contextClassLoader);
            if (value == null && !this.weakMap.containsKey(contextClassLoader)) {
                value = this.initialValue();
                this.weakMap.put(contextClassLoader, value);
            }
            return value;
        }
        if (!this.initialized) {
            this.value = this.initialValue();
            this.initialized = true;
        }
        return this.value;
    }

    public synchronized void set(T value) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            this.weakMap.put(contextClassLoader, value);
            return;
        }
        this.value = value;
        this.initialized = true;
    }

    public synchronized void remove() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.weakMap.remove(contextClassLoader);
    }
}

