/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol;

import io.prestosql.hive.$internal.parquet.org.apache.thrift.ShortStack;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.TException;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TField;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TList;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TMap;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TMessage;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TProtocol;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TProtocolException;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TProtocolFactory;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TSet;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TStruct;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.transport.TTransport;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public final class TCompactProtocol
extends TProtocol {
    private static final TStruct ANONYMOUS_STRUCT = new TStruct("");
    private static final TField TSTOP = new TField("", 0, 0);
    private static final byte[] ttypeToCompactType = new byte[16];
    private static final byte PROTOCOL_ID = -126;
    private static final byte VERSION = 1;
    private static final byte VERSION_MASK = 31;
    private static final byte TYPE_MASK = -32;
    private static final int TYPE_SHIFT_AMOUNT = 5;
    private ShortStack lastField_ = new ShortStack(15);
    private short lastFieldId_ = 0;
    private TField booleanField_ = null;
    private Boolean boolValue_ = null;
    byte[] i32buf = new byte[5];
    byte[] varint64out = new byte[10];
    private byte[] byteDirectBuffer = new byte[1];
    byte[] byteRawBuf = new byte[1];

    public TCompactProtocol(TTransport transport) {
        super(transport);
    }

    public void reset() {
        this.lastField_.clear();
        this.lastFieldId_ = 0;
    }

    public void writeMessageBegin(TMessage message) throws TException {
        this.writeByteDirect((byte)-126);
        this.writeByteDirect(1 | message.type << 5 & 0xFFFFFFE0);
        this.writeVarint32(message.seqid);
        this.writeString(message.name);
    }

    public void writeStructBegin(TStruct struct) throws TException {
        this.lastField_.push(this.lastFieldId_);
        this.lastFieldId_ = 0;
    }

    public void writeStructEnd() throws TException {
        this.lastFieldId_ = this.lastField_.pop();
    }

    public void writeFieldBegin(TField field) throws TException {
        if (field.type == 2) {
            this.booleanField_ = field;
        } else {
            this.writeFieldBeginInternal(field, (byte)-1);
        }
    }

    private void writeFieldBeginInternal(TField field, byte typeOverride) throws TException {
        byte typeToWrite;
        byte by = typeToWrite = typeOverride == -1 ? this.getCompactType(field.type) : typeOverride;
        if (field.id > this.lastFieldId_ && field.id - this.lastFieldId_ <= 15) {
            this.writeByteDirect(field.id - this.lastFieldId_ << 4 | typeToWrite);
        } else {
            this.writeByteDirect(typeToWrite);
            this.writeI16(field.id);
        }
        this.lastFieldId_ = field.id;
    }

    public void writeFieldStop() throws TException {
        this.writeByteDirect((byte)0);
    }

    public void writeMapBegin(TMap map) throws TException {
        if (map.size == 0) {
            this.writeByteDirect(0);
        } else {
            this.writeVarint32(map.size);
            this.writeByteDirect(this.getCompactType(map.keyType) << 4 | this.getCompactType(map.valueType));
        }
    }

    public void writeListBegin(TList list) throws TException {
        this.writeCollectionBegin(list.elemType, list.size);
    }

    public void writeSetBegin(TSet set) throws TException {
        this.writeCollectionBegin(set.elemType, set.size);
    }

    public void writeBool(boolean b) throws TException {
        if (this.booleanField_ != null) {
            this.writeFieldBeginInternal(this.booleanField_, b ? (byte)1 : 2);
            this.booleanField_ = null;
        } else {
            this.writeByteDirect(b ? (byte)1 : 2);
        }
    }

    public void writeByte(byte b) throws TException {
        this.writeByteDirect(b);
    }

    public void writeI16(short i16) throws TException {
        this.writeVarint32(this.intToZigZag(i16));
    }

    public void writeI32(int i32) throws TException {
        this.writeVarint32(this.intToZigZag(i32));
    }

    public void writeI64(long i64) throws TException {
        this.writeVarint64(this.longToZigzag(i64));
    }

    public void writeDouble(double dub) throws TException {
        byte[] data = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        this.fixedLongToBytes(Double.doubleToLongBits(dub), data, 0);
        this.trans_.write(data);
    }

    public void writeString(String str) throws TException {
        try {
            byte[] bytes = str.getBytes("UTF-8");
            this.writeBinary(bytes, 0, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            throw new TException("UTF-8 not supported!");
        }
    }

    public void writeBinary(ByteBuffer bin) throws TException {
        int length = bin.limit() - bin.position();
        this.writeBinary(bin.array(), bin.position() + bin.arrayOffset(), length);
    }

    private void writeBinary(byte[] buf, int offset, int length) throws TException {
        this.writeVarint32(length);
        this.trans_.write(buf, offset, length);
    }

    public void writeMessageEnd() throws TException {
    }

    public void writeMapEnd() throws TException {
    }

    public void writeListEnd() throws TException {
    }

    public void writeSetEnd() throws TException {
    }

    public void writeFieldEnd() throws TException {
    }

    protected void writeCollectionBegin(byte elemType, int size) throws TException {
        if (size <= 14) {
            this.writeByteDirect(size << 4 | this.getCompactType(elemType));
        } else {
            this.writeByteDirect(0xF0 | this.getCompactType(elemType));
            this.writeVarint32(size);
        }
    }

    private void writeVarint32(int n) throws TException {
        int idx = 0;
        while (true) {
            if ((n & 0xFFFFFF80) == 0) break;
            this.i32buf[idx++] = (byte)(n & 0x7F | 0x80);
            n >>>= 7;
        }
        this.i32buf[idx++] = (byte)n;
        this.trans_.write(this.i32buf, 0, idx);
    }

    private void writeVarint64(long n) throws TException {
        int idx = 0;
        while (true) {
            if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) break;
            this.varint64out[idx++] = (byte)(n & 0x7FL | 0x80L);
            n >>>= 7;
        }
        this.varint64out[idx++] = (byte)n;
        this.trans_.write(this.varint64out, 0, idx);
    }

    private long longToZigzag(long l) {
        return l << 1 ^ l >> 63;
    }

    private int intToZigZag(int n) {
        return n << 1 ^ n >> 31;
    }

    private void fixedLongToBytes(long n, byte[] buf, int off) {
        buf[off + 0] = (byte)(n & 0xFFL);
        buf[off + 1] = (byte)(n >> 8 & 0xFFL);
        buf[off + 2] = (byte)(n >> 16 & 0xFFL);
        buf[off + 3] = (byte)(n >> 24 & 0xFFL);
        buf[off + 4] = (byte)(n >> 32 & 0xFFL);
        buf[off + 5] = (byte)(n >> 40 & 0xFFL);
        buf[off + 6] = (byte)(n >> 48 & 0xFFL);
        buf[off + 7] = (byte)(n >> 56 & 0xFFL);
    }

    private void writeByteDirect(byte b) throws TException {
        this.byteDirectBuffer[0] = b;
        this.trans_.write(this.byteDirectBuffer);
    }

    private void writeByteDirect(int n) throws TException {
        this.writeByteDirect((byte)n);
    }

    public TMessage readMessageBegin() throws TException {
        byte protocolId = this.readByte();
        if (protocolId != -126) {
            throw new TProtocolException("Expected protocol id " + Integer.toHexString(-126) + " but got " + Integer.toHexString(protocolId));
        }
        byte versionAndType = this.readByte();
        byte version = (byte)(versionAndType & 0x1F);
        if (version != 1) {
            throw new TProtocolException("Expected version 1 but got " + version);
        }
        byte type = (byte)(versionAndType >> 5 & 3);
        int seqid = this.readVarint32();
        String messageName = this.readString();
        return new TMessage(messageName, type, seqid);
    }

    public TStruct readStructBegin() throws TException {
        this.lastField_.push(this.lastFieldId_);
        this.lastFieldId_ = 0;
        return ANONYMOUS_STRUCT;
    }

    public void readStructEnd() throws TException {
        this.lastFieldId_ = this.lastField_.pop();
    }

    public TField readFieldBegin() throws TException {
        byte type = this.readByte();
        if (type == 0) {
            return TSTOP;
        }
        short modifier = (short)((type & 0xF0) >> 4);
        short fieldId = modifier == 0 ? this.readI16() : (short)(this.lastFieldId_ + modifier);
        TField field = new TField("", this.getTType((byte)(type & 0xF)), fieldId);
        if (this.isBoolType(type)) {
            this.boolValue_ = (byte)(type & 0xF) == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        this.lastFieldId_ = field.id;
        return field;
    }

    public TMap readMapBegin() throws TException {
        int size = this.readVarint32();
        byte keyAndValueType = size == 0 ? (byte)0 : this.readByte();
        return new TMap(this.getTType((byte)(keyAndValueType >> 4)), this.getTType((byte)(keyAndValueType & 0xF)), size);
    }

    public TList readListBegin() throws TException {
        byte size_and_type = this.readByte();
        int size = size_and_type >> 4 & 0xF;
        if (size == 15) {
            size = this.readVarint32();
        }
        byte type = this.getTType(size_and_type);
        return new TList(type, size);
    }

    public TSet readSetBegin() throws TException {
        return new TSet(this.readListBegin());
    }

    public boolean readBool() throws TException {
        if (this.boolValue_ != null) {
            boolean result = this.boolValue_;
            this.boolValue_ = null;
            return result;
        }
        return this.readByte() == 1;
    }

    public byte readByte() throws TException {
        byte b;
        if (this.trans_.getBytesRemainingInBuffer() > 0) {
            b = this.trans_.getBuffer()[this.trans_.getBufferPosition()];
            this.trans_.consumeBuffer(1);
        } else {
            this.trans_.readAll(this.byteRawBuf, 0, 1);
            b = this.byteRawBuf[0];
        }
        return b;
    }

    public short readI16() throws TException {
        return (short)this.zigzagToInt(this.readVarint32());
    }

    public int readI32() throws TException {
        return this.zigzagToInt(this.readVarint32());
    }

    public long readI64() throws TException {
        return this.zigzagToLong(this.readVarint64());
    }

    public double readDouble() throws TException {
        byte[] longBits = new byte[8];
        this.trans_.readAll(longBits, 0, 8);
        return Double.longBitsToDouble(this.bytesToLong(longBits));
    }

    public String readString() throws TException {
        int length = this.readVarint32();
        if (length == 0) {
            return "";
        }
        try {
            if (this.trans_.getBytesRemainingInBuffer() >= length) {
                String str = new String(this.trans_.getBuffer(), this.trans_.getBufferPosition(), length, "UTF-8");
                this.trans_.consumeBuffer(length);
                return str;
            }
            return new String(this.readBinary(length), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TException("UTF-8 not supported!");
        }
    }

    public ByteBuffer readBinary() throws TException {
        int length = this.readVarint32();
        if (length == 0) {
            return ByteBuffer.wrap(new byte[0]);
        }
        byte[] buf = new byte[length];
        this.trans_.readAll(buf, 0, length);
        return ByteBuffer.wrap(buf);
    }

    private byte[] readBinary(int length) throws TException {
        if (length == 0) {
            return new byte[0];
        }
        byte[] buf = new byte[length];
        this.trans_.readAll(buf, 0, length);
        return buf;
    }

    public void readMessageEnd() throws TException {
    }

    public void readFieldEnd() throws TException {
    }

    public void readMapEnd() throws TException {
    }

    public void readListEnd() throws TException {
    }

    public void readSetEnd() throws TException {
    }

    private int readVarint32() throws TException {
        int result = 0;
        int shift = 0;
        if (this.trans_.getBytesRemainingInBuffer() >= 5) {
            byte[] buf = this.trans_.getBuffer();
            int pos = this.trans_.getBufferPosition();
            int off = 0;
            while (true) {
                byte b = buf[pos + off];
                result |= (b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
                ++off;
            }
            this.trans_.consumeBuffer(off + 1);
        } else {
            while (true) {
                byte b = this.readByte();
                result |= (b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
            }
        }
        return result;
    }

    private long readVarint64() throws TException {
        int shift = 0;
        long result = 0L;
        if (this.trans_.getBytesRemainingInBuffer() >= 10) {
            byte[] buf = this.trans_.getBuffer();
            int pos = this.trans_.getBufferPosition();
            int off = 0;
            while (true) {
                byte b = buf[pos + off];
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
                ++off;
            }
            this.trans_.consumeBuffer(off + 1);
        } else {
            while (true) {
                byte b = this.readByte();
                result |= (long)(b & 0x7F) << shift;
                if ((b & 0x80) != 128) break;
                shift += 7;
            }
        }
        return result;
    }

    private int zigzagToInt(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    private long zigzagToLong(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private long bytesToLong(byte[] bytes) {
        return ((long)bytes[7] & 0xFFL) << 56 | ((long)bytes[6] & 0xFFL) << 48 | ((long)bytes[5] & 0xFFL) << 40 | ((long)bytes[4] & 0xFFL) << 32 | ((long)bytes[3] & 0xFFL) << 24 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[1] & 0xFFL) << 8 | (long)bytes[0] & 0xFFL;
    }

    private boolean isBoolType(byte b) {
        int lowerNibble = b & 0xF;
        return lowerNibble == 1 || lowerNibble == 2;
    }

    private byte getTType(byte type) throws TProtocolException {
        switch ((byte)(type & 0xF)) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 15;
            }
            case 10: {
                return 14;
            }
            case 11: {
                return 13;
            }
            case 12: {
                return 12;
            }
        }
        throw new TProtocolException("don't know what type: " + (byte)(type & 0xF));
    }

    private byte getCompactType(byte ttype) {
        return ttypeToCompactType[ttype];
    }

    static {
        TCompactProtocol.ttypeToCompactType[0] = 0;
        TCompactProtocol.ttypeToCompactType[2] = 1;
        TCompactProtocol.ttypeToCompactType[3] = 3;
        TCompactProtocol.ttypeToCompactType[6] = 4;
        TCompactProtocol.ttypeToCompactType[8] = 5;
        TCompactProtocol.ttypeToCompactType[10] = 6;
        TCompactProtocol.ttypeToCompactType[4] = 7;
        TCompactProtocol.ttypeToCompactType[11] = 8;
        TCompactProtocol.ttypeToCompactType[15] = 9;
        TCompactProtocol.ttypeToCompactType[14] = 10;
        TCompactProtocol.ttypeToCompactType[13] = 11;
        TCompactProtocol.ttypeToCompactType[12] = 12;
    }

    private static class Types {
        public static final byte BOOLEAN_TRUE = 1;
        public static final byte BOOLEAN_FALSE = 2;
        public static final byte BYTE = 3;
        public static final byte I16 = 4;
        public static final byte I32 = 5;
        public static final byte I64 = 6;
        public static final byte DOUBLE = 7;
        public static final byte BINARY = 8;
        public static final byte LIST = 9;
        public static final byte SET = 10;
        public static final byte MAP = 11;
        public static final byte STRUCT = 12;

        private Types() {
        }
    }

    public static class Factory
    implements TProtocolFactory {
        public TProtocol getProtocol(TTransport trans) {
            return new TCompactProtocol(trans);
        }
    }
}

