/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.$internal.parquet.org.apache.thrift.server;

import io.prestosql.hive.$internal.parquet.org.apache.thrift.TException;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.TProcessor;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.protocol.TProtocol;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.server.TServer;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.transport.TTransport;
import io.prestosql.hive.$internal.parquet.org.apache.thrift.transport.TTransportException;
import io.prestosql.hive.$internal.parquet.org.slf4j.Logger;
import io.prestosql.hive.$internal.parquet.org.slf4j.LoggerFactory;

public class TSimpleServer
extends TServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSimpleServer.class.getName());
    private boolean stopped_ = false;

    public TSimpleServer(TServer.AbstractServerArgs args) {
        super(args);
    }

    public void serve() {
        this.stopped_ = false;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", ttx);
            return;
        }
        this.setServing(true);
        while (!this.stopped_) {
            TTransport outputTransport;
            TTransport inputTransport;
            block11: {
                TTransport client = null;
                TProcessor processor = null;
                inputTransport = null;
                outputTransport = null;
                TProtocol inputProtocol = null;
                TProtocol outputProtocol = null;
                try {
                    client = this.serverTransport_.accept();
                    if (client != null) {
                        processor = this.processorFactory_.getProcessor(client);
                        inputTransport = this.inputTransportFactory_.getTransport(client);
                        outputTransport = this.outputTransportFactory_.getTransport(client);
                        inputProtocol = this.inputProtocolFactory_.getProtocol(inputTransport);
                        outputProtocol = this.outputProtocolFactory_.getProtocol(outputTransport);
                        while (processor.process(inputProtocol, outputProtocol)) {
                        }
                    }
                }
                catch (TTransportException ttx) {
                }
                catch (TException tx) {
                    if (!this.stopped_) {
                        LOGGER.error("Thrift error occurred during processing of message.", tx);
                    }
                }
                catch (Exception x) {
                    if (this.stopped_) break block11;
                    LOGGER.error("Error occurred during processing of message.", x);
                }
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport == null) continue;
            outputTransport.close();
        }
        this.setServing(false);
    }

    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }
}

