/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.hadoop.io;

import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.hadoop.io.AvroDatumConverter;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapred.AvroValue;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;

public class AvroDatumConverterFactory
extends Configured {
    public AvroDatumConverterFactory(Configuration conf) {
        super(conf);
    }

    public <IN, OUT> AvroDatumConverter<IN, OUT> create(Class<IN> inputClass) {
        boolean isMapOnly;
        boolean bl = isMapOnly = ((JobConf)this.getConf()).getNumReduceTasks() == 0;
        if (AvroKey.class.isAssignableFrom(inputClass)) {
            Schema schema = null;
            if (isMapOnly) {
                schema = AvroJob.getMapOutputKeySchema(this.getConf());
                if (null == schema) {
                    schema = AvroJob.getOutputKeySchema(this.getConf());
                }
            } else {
                schema = AvroJob.getOutputKeySchema(this.getConf());
            }
            if (null == schema) {
                throw new IllegalStateException("Writer schema for output key was not set. Use AvroJob.setOutputKeySchema().");
            }
            return new AvroWrapperConverter(schema);
        }
        if (AvroValue.class.isAssignableFrom(inputClass)) {
            Schema schema = null;
            if (isMapOnly) {
                AvroJob.getMapOutputValueSchema(this.getConf());
                if (null == schema) {
                    schema = AvroJob.getOutputValueSchema(this.getConf());
                }
            } else {
                schema = AvroJob.getOutputValueSchema(this.getConf());
            }
            if (null == schema) {
                throw new IllegalStateException("Writer schema for output value was not set. Use AvroJob.setOutputValueSchema().");
            }
            return new AvroWrapperConverter(schema);
        }
        if (BooleanWritable.class.isAssignableFrom(inputClass)) {
            return new BooleanWritableConverter();
        }
        if (BytesWritable.class.isAssignableFrom(inputClass)) {
            return new BytesWritableConverter();
        }
        if (ByteWritable.class.isAssignableFrom(inputClass)) {
            return new ByteWritableConverter();
        }
        if (DoubleWritable.class.isAssignableFrom(inputClass)) {
            return new DoubleWritableConverter();
        }
        if (FloatWritable.class.isAssignableFrom(inputClass)) {
            return new FloatWritableConverter();
        }
        if (IntWritable.class.isAssignableFrom(inputClass)) {
            return new IntWritableConverter();
        }
        if (LongWritable.class.isAssignableFrom(inputClass)) {
            return new LongWritableConverter();
        }
        if (NullWritable.class.isAssignableFrom(inputClass)) {
            return new NullWritableConverter();
        }
        if (Text.class.isAssignableFrom(inputClass)) {
            return new TextConverter();
        }
        throw new UnsupportedOperationException("Unsupported input type: " + inputClass.getName());
    }

    public static class TextConverter
    extends AvroDatumConverter<Text, CharSequence> {
        private final Schema mSchema = Schema.create(Schema.Type.STRING);

        @Override
        public CharSequence convert(Text input) {
            return input.toString();
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }

    public static class NullWritableConverter
    extends AvroDatumConverter<NullWritable, Object> {
        private final Schema mSchema = Schema.create(Schema.Type.NULL);

        @Override
        public Object convert(NullWritable input) {
            return null;
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }

    public static class LongWritableConverter
    extends AvroDatumConverter<LongWritable, Long> {
        private final Schema mSchema = Schema.create(Schema.Type.LONG);

        @Override
        public Long convert(LongWritable input) {
            return input.get();
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }

    public static class IntWritableConverter
    extends AvroDatumConverter<IntWritable, Integer> {
        private final Schema mSchema = Schema.create(Schema.Type.INT);

        @Override
        public Integer convert(IntWritable input) {
            return input.get();
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }

    public static class FloatWritableConverter
    extends AvroDatumConverter<FloatWritable, Float> {
        private final Schema mSchema = Schema.create(Schema.Type.FLOAT);

        @Override
        public Float convert(FloatWritable input) {
            return Float.valueOf(input.get());
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }

    public static class DoubleWritableConverter
    extends AvroDatumConverter<DoubleWritable, Double> {
        private final Schema mSchema = Schema.create(Schema.Type.DOUBLE);

        @Override
        public Double convert(DoubleWritable input) {
            return input.get();
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }

    public static class ByteWritableConverter
    extends AvroDatumConverter<ByteWritable, GenericFixed> {
        private final Schema mSchema = Schema.createFixed("Byte", "A single byte", "org.apache.avro.mapreduce", 1);

        @Override
        public GenericFixed convert(ByteWritable input) {
            return new GenericData.Fixed(this.mSchema, new byte[]{input.get()});
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }

    public static class BytesWritableConverter
    extends AvroDatumConverter<BytesWritable, ByteBuffer> {
        private final Schema mSchema = Schema.create(Schema.Type.BYTES);

        @Override
        public ByteBuffer convert(BytesWritable input) {
            return ByteBuffer.wrap(input.getBytes());
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }

    public static class BooleanWritableConverter
    extends AvroDatumConverter<BooleanWritable, Boolean> {
        private final Schema mSchema = Schema.create(Schema.Type.BOOLEAN);

        @Override
        public Boolean convert(BooleanWritable input) {
            return input.get();
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }

    public static class AvroWrapperConverter
    extends AvroDatumConverter<AvroWrapper<?>, Object> {
        private final Schema mSchema;

        public AvroWrapperConverter(Schema schema) {
            this.mSchema = schema;
        }

        @Override
        public Object convert(AvroWrapper<?> input) {
            return input.datum();
        }

        @Override
        public Schema getWriterSchema() {
            return this.mSchema;
        }
    }
}

