/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.FileNotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.MetaStoreFS;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;

public class HiveMetaStoreFsImpl
implements MetaStoreFS {
    public static final Logger LOG = LoggerFactory.getLogger("hive.metastore.hivemetastoreFsimpl");

    @Override
    public boolean deleteDir(FileSystem fs, Path f, boolean recursive, boolean ifPurge, Configuration conf) throws MetaException {
        try {
            FileUtils.moveToTrash(fs, f, conf, ifPurge);
            if (fs.exists(f)) {
                throw new MetaException("Unable to delete directory: " + f);
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return false;
        }
    }
}

