/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.TimerTask;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.RawStore;

public class EventCleanerTask
extends TimerTask {
    public static final Logger LOG = LoggerFactory.getLogger(EventCleanerTask.class);
    private final HiveMetaStore.HMSHandler handler;

    public EventCleanerTask(HiveMetaStore.HMSHandler handler) {
        this.handler = handler;
    }

    @Override
    public void run() {
        try {
            RawStore ms = this.handler.getMS();
            long deleteCnt = ms.cleanupEvents();
            if (deleteCnt > 0L) {
                LOG.info("Number of events deleted from event Table: " + deleteCnt);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while trying to delete events ", e);
        }
    }
}

