/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;

public class SharedStorageDescriptor
extends StorageDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(SharedStorageDescriptor.class.getName());
    private boolean colsCopied = false;
    private boolean serdeCopied = false;
    private boolean bucketsCopied = false;
    private boolean sortCopied = false;
    private boolean skewedCopied = false;

    SharedStorageDescriptor() {
    }

    void setShared(StorageDescriptor shared) {
        if (shared.getCols() != null) {
            super.setCols(shared.getCols());
        }
        if (shared.getInputFormat() != null) {
            super.setInputFormat(shared.getInputFormat());
        }
        if (shared.getOutputFormat() != null) {
            super.setOutputFormat(shared.getOutputFormat());
        }
        super.setCompressed(shared.isCompressed());
        super.setNumBuckets(shared.getNumBuckets());
        if (shared.getSerdeInfo() != null) {
            super.setSerdeInfo(shared.getSerdeInfo());
        }
        if (shared.getBucketCols() != null) {
            super.setBucketCols(shared.getBucketCols());
        }
        if (shared.getSortCols() != null) {
            super.setSortCols(shared.getSortCols());
        }
        if (shared.getSkewedInfo() != null) {
            super.setSkewedInfo(shared.getSkewedInfo());
        }
        super.setStoredAsSubDirectories(shared.isStoredAsSubDirectories());
    }

    public void setReadOnly() {
        this.skewedCopied = true;
        this.sortCopied = true;
        this.bucketsCopied = true;
        this.serdeCopied = true;
        this.colsCopied = true;
    }

    @Override
    public void addToCols(FieldSchema fs) {
        this.copyCols();
        super.addToCols(fs);
    }

    @Override
    public List<FieldSchema> getCols() {
        this.copyCols();
        return super.getCols();
    }

    @Override
    public void setCols(List<FieldSchema> cols) {
        this.colsCopied = true;
        super.setCols(cols);
    }

    @Override
    public void unsetCols() {
        this.colsCopied = true;
        super.unsetCols();
    }

    @Override
    public Iterator<FieldSchema> getColsIterator() {
        this.copyCols();
        return super.getColsIterator();
    }

    private void copyCols() {
        if (!this.colsCopied) {
            this.colsCopied = true;
            if (super.getCols() != null) {
                ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>(super.getColsSize());
                for (FieldSchema fs : super.getCols()) {
                    cols.add(new FieldSchema(fs));
                }
                super.setCols(cols);
            }
        }
    }

    @Override
    public SerDeInfo getSerdeInfo() {
        this.copySerde();
        return super.getSerdeInfo();
    }

    @Override
    public void setSerdeInfo(SerDeInfo serdeInfo) {
        this.serdeCopied = true;
        super.setSerdeInfo(serdeInfo);
    }

    @Override
    public void unsetSerdeInfo() {
        this.serdeCopied = true;
        super.unsetSerdeInfo();
    }

    private void copySerde() {
        if (!this.serdeCopied) {
            this.serdeCopied = true;
            if (super.getSerdeInfo() != null) {
                super.setSerdeInfo(new SerDeInfo(super.getSerdeInfo()));
            }
        }
    }

    @Override
    public void addToBucketCols(String bucket) {
        this.copyBucketCols();
        super.addToBucketCols(bucket);
    }

    @Override
    public List<String> getBucketCols() {
        this.copyBucketCols();
        return super.getBucketCols();
    }

    @Override
    public void setBucketCols(List<String> buckets) {
        this.bucketsCopied = true;
        super.setBucketCols(buckets);
    }

    @Override
    public void unsetBucketCols() {
        this.bucketsCopied = true;
        super.unsetBucketCols();
    }

    @Override
    public Iterator<String> getBucketColsIterator() {
        this.copyBucketCols();
        return super.getBucketColsIterator();
    }

    private void copyBucketCols() {
        if (!this.bucketsCopied) {
            this.bucketsCopied = true;
            if (super.getBucketCols() != null) {
                ArrayList<String> buckets = new ArrayList<String>(super.getBucketColsSize());
                for (String bucket : super.getBucketCols()) {
                    buckets.add(bucket);
                }
                super.setBucketCols(buckets);
            }
        }
    }

    @Override
    public void addToSortCols(Order sort) {
        this.copySort();
        super.addToSortCols(sort);
    }

    @Override
    public List<Order> getSortCols() {
        this.copySort();
        return super.getSortCols();
    }

    @Override
    public void setSortCols(List<Order> sorts) {
        this.sortCopied = true;
        super.setSortCols(sorts);
    }

    @Override
    public void unsetSortCols() {
        this.sortCopied = true;
        super.unsetSortCols();
    }

    @Override
    public Iterator<Order> getSortColsIterator() {
        this.copySort();
        return super.getSortColsIterator();
    }

    private void copySort() {
        if (!this.sortCopied) {
            this.sortCopied = true;
            if (super.getSortCols() != null) {
                ArrayList<Order> sortCols = new ArrayList<Order>(super.getSortColsSize());
                for (Order sortCol : super.getSortCols()) {
                    sortCols.add(new Order(sortCol));
                }
                super.setSortCols(sortCols);
            }
        }
    }

    @Override
    public SkewedInfo getSkewedInfo() {
        this.copySkewed();
        return super.getSkewedInfo();
    }

    @Override
    public void setSkewedInfo(SkewedInfo skewedInfo) {
        this.skewedCopied = true;
        super.setSkewedInfo(skewedInfo);
    }

    @Override
    public void unsetSkewedInfo() {
        this.skewedCopied = true;
        super.unsetSkewedInfo();
    }

    private void copySkewed() {
        if (!this.skewedCopied) {
            this.skewedCopied = true;
            if (super.getSkewedInfo() != null) {
                super.setSkewedInfo(new SkewedInfo(super.getSkewedInfo()));
            }
        }
    }
}

