/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hive.metastore.hbase.HBaseConnection;
import org.apache.hadoop.hive.metastore.hbase.HBaseUtils;

public class VanillaHBaseConnection
implements HBaseConnection {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaHBaseConnection.class.getName());
    protected HConnection conn;
    protected Map<String, HTableInterface> tables = new HashMap<String, HTableInterface>();
    protected Configuration conf;

    VanillaHBaseConnection() {
    }

    @Override
    public void connect() throws IOException {
        if (this.conf == null) {
            throw new RuntimeException("Must call getConf before connect");
        }
        this.conn = HConnectionManager.createConnection((Configuration)this.conf);
    }

    @Override
    public void close() throws IOException {
        for (HTableInterface htab : this.tables.values()) {
            htab.close();
        }
    }

    @Override
    public void beginTransaction() throws IOException {
    }

    @Override
    public void commitTransaction() throws IOException {
    }

    @Override
    public void rollbackTransaction() throws IOException {
    }

    @Override
    public void flush(HTableInterface htab) throws IOException {
        htab.flushCommits();
    }

    @Override
    public void createHBaseTable(String tableName, List<byte[]> columnFamilies) throws IOException {
        HBaseAdmin admin = new HBaseAdmin((Connection)this.conn);
        LOG.info("Creating HBase table " + tableName);
        admin.createTable(this.buildDescriptor(tableName, columnFamilies));
        admin.close();
    }

    protected HTableDescriptor buildDescriptor(String tableName, List<byte[]> columnFamilies) throws IOException {
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)tableName));
        for (byte[] cf : columnFamilies) {
            tableDesc.addFamily(new HColumnDescriptor(cf));
        }
        return tableDesc;
    }

    @Override
    public HTableInterface getHBaseTable(String tableName) throws IOException {
        return this.getHBaseTable(tableName, false);
    }

    @Override
    public HTableInterface getHBaseTable(String tableName, boolean force) throws IOException {
        HTableInterface htab = this.tables.get(tableName);
        if (htab == null) {
            LOG.debug("Trying to connect to table " + tableName);
            try {
                htab = this.conn.getTable(tableName);
                if (force) {
                    htab.get(new Get("nosuchkey".getBytes(HBaseUtils.ENCODING)));
                }
            }
            catch (IOException e) {
                LOG.info("Caught exception when table was missing");
                return null;
            }
            htab.setAutoFlushTo(false);
            this.tables.put(tableName, htab);
        }
        return htab;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

