/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import io.prestosql.hive.;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.messaging.DropIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;

public class JSONDropIndexMessage
extends DropIndexMessage {
    @.JsonProperty
    String server;
    @.JsonProperty
    String servicePrincipal;
    @.JsonProperty
    String db;
    @.JsonProperty
    String indexName;
    @.JsonProperty
    String origTableName;
    @.JsonProperty
    String indexTableName;
    @.JsonProperty
    Long timestamp;

    public JSONDropIndexMessage() {
    }

    public JSONDropIndexMessage(String server, String servicePrincipal, Index index, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = index.getDbName();
        this.indexName = index.getIndexName();
        this.origTableName = index.getOrigTableName();
        this.indexTableName = index.getIndexTableName();
        this.timestamp = timestamp;
        this.checkValid();
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public String getOrigTableName() {
        return this.origTableName;
    }

    @Override
    public String getIndexTableName() {
        return this.indexTableName;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString(this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

