/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import io.prestosql.hive.;
import io.prestosql.hive.$internal.com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.plan.api.StageType;

public class QueryDisplay {
    private String queryStr;
    private String explainPlan;
    private String errorMessage;
    private String queryId;
    private final Map<Phase, Map<String, Long>> hmsTimingMap = new HashMap<Phase, Map<String, Long>>();
    private final Map<Phase, Map<String, Long>> perfLogStartMap = new HashMap<Phase, Map<String, Long>>();
    private final Map<Phase, Map<String, Long>> perfLogEndMap = new HashMap<Phase, Map<String, Long>>();
    private final LinkedHashMap<String, TaskDisplay> tasks = new LinkedHashMap();

    public synchronized <T extends Serializable> void updateTaskStatus(Task<T> tTask) {
        if (!this.tasks.containsKey(tTask.getId())) {
            this.tasks.put(tTask.getId(), new TaskDisplay(tTask));
        }
        this.tasks.get(tTask.getId()).updateStatus(tTask);
    }

    public synchronized void setTaskResult(String taskId, TaskResult result) {
        TaskDisplay taskDisplay = this.tasks.get(taskId);
        if (taskDisplay != null) {
            taskDisplay.returnValue = result.getExitVal();
            if (result.getTaskError() != null) {
                taskDisplay.errorMsg = result.getTaskError().toString();
            }
        }
    }

    public synchronized List<TaskDisplay> getTaskDisplays() {
        ArrayList<TaskDisplay> taskDisplays = new ArrayList<TaskDisplay>();
        taskDisplays.addAll(this.tasks.values());
        return taskDisplays;
    }

    public synchronized void setQueryStr(String queryStr) {
        this.queryStr = queryStr;
    }

    public synchronized String getQueryString() {
        return this.returnStringOrUnknown(this.queryStr);
    }

    public synchronized String getExplainPlan() {
        return this.returnStringOrUnknown(this.explainPlan);
    }

    public synchronized void setExplainPlan(String explainPlan) {
        this.explainPlan = explainPlan;
    }

    public synchronized Map<String, Long> getHmsTimings(Phase phase) {
        return this.hmsTimingMap.get((Object)phase);
    }

    public synchronized void setHmsTimings(Phase phase, ImmutableMap<String, Long> hmsTimings) {
        this.hmsTimingMap.put(phase, hmsTimings);
    }

    public synchronized Map<String, Long> getPerfLogStarts(Phase phase) {
        return this.perfLogStartMap.get((Object)phase);
    }

    public synchronized void setPerfLogStarts(Phase phase, ImmutableMap<String, Long> perfLogStarts) {
        this.perfLogStartMap.put(phase, perfLogStarts);
    }

    public synchronized Map<String, Long> getPerfLogEnds(Phase phase) {
        return this.perfLogEndMap.get((Object)phase);
    }

    public synchronized void setPerfLogEnds(Phase phase, ImmutableMap<String, Long> perfLogEnds) {
        this.perfLogEndMap.put(phase, perfLogEnds);
    }

    public synchronized Map<String, Long> getPerfLogTimes(Phase phase) {
        HashMap<String, Long> times = new HashMap<String, Long>();
        Map<String, Long> startTimes = this.perfLogStartMap.get((Object)phase);
        Map<String, Long> endTimes = this.perfLogEndMap.get((Object)phase);
        if (endTimes != null && startTimes != null) {
            for (String timeKey : endTimes.keySet()) {
                Long endTime = endTimes.get(timeKey);
                Long startTime = startTimes.get(timeKey);
                if (startTime == null) continue;
                times.put(timeKey, endTime - startTime);
            }
        }
        return times;
    }

    public synchronized String getErrorMessage() {
        return this.errorMessage;
    }

    public synchronized void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public synchronized String getQueryId() {
        return this.returnStringOrUnknown(this.queryId);
    }

    public synchronized void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    private String returnStringOrUnknown(String s) {
        return s == null ? "UNKNOWN" : s;
    }

    @.JsonWriteNullProperties(value=false)
    @.JsonIgnoreProperties(ignoreUnknown=true)
    public static class TaskDisplay {
        private Integer returnValue;
        private String errorMsg;
        private Long beginTime;
        private Long endTime;
        private String taskId;
        private String externalHandle;
        public Task.TaskState taskState;
        private StageType taskType;
        private String name;
        private boolean requireLock;
        private boolean retryIfFail;
        private String statusMessage;

        public TaskDisplay() {
        }

        public TaskDisplay(Task task) {
            this.taskId = task.getId();
            this.externalHandle = task.getExternalHandle();
            this.taskType = task.getType();
            this.name = task.getName();
            this.requireLock = task.requireLock();
            this.retryIfFail = task.ifRetryCmdWhenFail();
        }

        @.JsonIgnore
        public synchronized String getStatus() {
            if (this.returnValue == null) {
                return "Running";
            }
            if (this.returnValue == 0) {
                return "Success, ReturnVal 0";
            }
            return "Failure, ReturnVal " + String.valueOf(this.returnValue);
        }

        public synchronized Long getElapsedTime() {
            if (this.endTime == null) {
                if (this.beginTime == null) {
                    return null;
                }
                return System.currentTimeMillis() - this.beginTime;
            }
            return this.endTime - this.beginTime;
        }

        public synchronized Integer getReturnValue() {
            return this.returnValue;
        }

        public synchronized String getErrorMsg() {
            return this.errorMsg;
        }

        public synchronized Long getBeginTime() {
            return this.beginTime;
        }

        public synchronized Long getEndTime() {
            return this.endTime;
        }

        public synchronized String getTaskId() {
            return this.taskId;
        }

        public synchronized StageType getTaskType() {
            return this.taskType;
        }

        public synchronized String getName() {
            return this.name;
        }

        @.JsonIgnore
        public synchronized boolean isRequireLock() {
            return this.requireLock;
        }

        @.JsonIgnore
        public synchronized boolean isRetryIfFail() {
            return this.retryIfFail;
        }

        public synchronized String getExternalHandle() {
            return this.externalHandle;
        }

        public synchronized <T extends Serializable> void updateStatus(Task<T> tTask) {
            this.taskState = tTask.getTaskState();
            if (this.externalHandle == null && tTask.getExternalHandle() != null) {
                this.externalHandle = tTask.getExternalHandle();
            }
            this.setStatusMessage(tTask.getStatusMessage());
            switch (this.taskState) {
                case RUNNING: {
                    if (this.beginTime != null) break;
                    this.beginTime = System.currentTimeMillis();
                    break;
                }
                case FINISHED: {
                    if (this.endTime != null) break;
                    this.endTime = System.currentTimeMillis();
                }
            }
        }

        public synchronized String getStatusMessage() {
            return this.statusMessage;
        }

        public synchronized void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }
    }

    public static enum Phase {
        COMPILATION,
        EXECUTION;

    }
}

