/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.BucketMatcher;

public class DefaultBucketMatcher
implements BucketMatcher {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private Map<String, Map<String, List<String>>> aliasBucketMapping;
    private Map<String, Integer> bucketFileNameMapping = new LinkedHashMap<String, Integer>();

    @Override
    public List<Path> getAliasBucketFiles(String refTableInputFile, String refTableAlias, String alias) {
        List<String> pathStr = this.aliasBucketMapping.get(alias).get(refTableInputFile);
        ArrayList<Path> paths = new ArrayList<Path>();
        if (pathStr != null) {
            for (String p : pathStr) {
                this.LOG.info("Loading file " + p + " for " + alias + ". (" + refTableInputFile + ")");
                paths.add(new Path(p));
            }
        }
        return paths;
    }

    @Override
    public void setAliasBucketFileNameMapping(Map<String, Map<String, List<String>>> aliasBucketFileNameMapping) {
        this.aliasBucketMapping = aliasBucketFileNameMapping;
    }

    @Override
    public Map<String, Integer> getBucketFileNameMapping() {
        return this.bucketFileNameMapping;
    }

    @Override
    public void setBucketFileNameMapping(Map<String, Integer> bucketFileNameMapping) {
        this.bucketFileNameMapping = bucketFileNameMapping;
    }
}

