/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExprNodeConstantEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

public class ExprNodeGenericFuncEvaluator
extends ExprNodeEvaluator<ExprNodeGenericFuncDesc> {
    private static final Logger LOG = LoggerFactory.getLogger(ExprNodeGenericFuncEvaluator.class.getName());
    transient GenericUDF genericUDF;
    transient Object rowObject;
    transient ExprNodeEvaluator[] children;
    transient GenericUDF.DeferredObject[] deferredChildren;
    transient GenericUDF.DeferredObject[] childrenNeedingPrepare;
    transient boolean isEager;
    transient boolean isConstant = false;

    public ExprNodeGenericFuncEvaluator(ExprNodeGenericFuncDesc expr, Configuration conf) throws HiveException {
        super(expr, conf);
        this.children = new ExprNodeEvaluator[expr.getChildren().size()];
        this.isEager = false;
        for (int i = 0; i < this.children.length; ++i) {
            GenericUDF childUDF;
            ExprNodeEvaluator nodeEvaluator;
            ExprNodeDesc child = expr.getChildren().get(i);
            this.children[i] = nodeEvaluator = ExprNodeEvaluatorFactory.get(child, conf);
            if (!(nodeEvaluator instanceof ExprNodeGenericFuncEvaluator)) continue;
            if (((ExprNodeGenericFuncEvaluator)nodeEvaluator).isEager) {
                this.isEager = true;
            }
            if (!FunctionRegistry.isStateful(childUDF = ((ExprNodeGenericFuncDesc)child).getGenericUDF())) continue;
            this.isEager = true;
        }
        this.genericUDF = expr.getGenericUDF();
        if (this.isEager && (this.genericUDF instanceof GenericUDFCase || this.genericUDF instanceof GenericUDFWhen)) {
            throw new HiveException("Stateful expressions cannot be used inside of CASE");
        }
    }

    @Override
    public ObjectInspector initialize(ObjectInspector rowInspector) throws HiveException {
        this.deferredChildren = new GenericUDF.DeferredObject[this.children.length];
        ArrayList<DeferredExprObject> childrenNeedingPrepare = new ArrayList<DeferredExprObject>(this.children.length);
        for (int i = 0; i < this.deferredChildren.length; ++i) {
            DeferredExprObject deferredExprObject = new DeferredExprObject(this.children[i], this.isEager);
            this.deferredChildren[i] = deferredExprObject;
            if (!deferredExprObject.needsPrepare()) continue;
            childrenNeedingPrepare.add(deferredExprObject);
        }
        this.childrenNeedingPrepare = childrenNeedingPrepare.toArray(new GenericUDF.DeferredObject[childrenNeedingPrepare.size()]);
        ObjectInspector[] childrenOIs = new ObjectInspector[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            childrenOIs[i] = this.children[i].initialize(rowInspector);
        }
        MapredContext context = MapredContext.get();
        if (context != null) {
            context.setup(this.genericUDF);
        }
        this.outputOI = this.genericUDF.initializeAndFoldConstants(childrenOIs);
        this.isConstant = ObjectInspectorUtils.isConstantObjectInspector(this.outputOI) && this.isDeterministic();
        return this.outputOI;
    }

    @Override
    public boolean isDeterministic() {
        boolean result = FunctionRegistry.isDeterministic(this.genericUDF);
        for (ExprNodeEvaluator child : this.children) {
            result = result && child.isDeterministic();
        }
        return result;
    }

    @Override
    public ExprNodeEvaluator[] getChildren() {
        return this.children;
    }

    @Override
    public boolean isStateful() {
        boolean result = FunctionRegistry.isStateful(this.genericUDF);
        for (ExprNodeEvaluator child : this.children) {
            if (!(result = result || child.isStateful())) continue;
            return result;
        }
        return result;
    }

    @Override
    protected Object _evaluate(Object row, int version) throws HiveException {
        if (this.isConstant) {
            return ((ConstantObjectInspector)this.outputOI).getWritableConstantValue();
        }
        this.rowObject = row;
        for (GenericUDF.DeferredObject deferredObject : this.childrenNeedingPrepare) {
            deferredObject.prepare(version);
        }
        return this.genericUDF.evaluate(this.deferredChildren);
    }

    public Integer compare(Object row) throws HiveException {
        if (!((ExprNodeGenericFuncDesc)this.expr).isSortedExpr() || !(this.genericUDF instanceof GenericUDFBaseCompare)) {
            for (ExprNodeEvaluator evaluator : this.children) {
                Integer comparison;
                if (!(evaluator instanceof ExprNodeGenericFuncEvaluator) || (comparison = ((ExprNodeGenericFuncEvaluator)evaluator).compare(row)) == null) continue;
                return comparison;
            }
            return null;
        }
        this.rowObject = row;
        for (int i = 0; i < this.deferredChildren.length; ++i) {
            this.deferredChildren[i].prepare(-1);
        }
        return ((GenericUDFBaseCompare)this.genericUDF).compare(this.deferredChildren);
    }

    class DeferredExprObject
    implements GenericUDF.DeferredObject {
        private final boolean eager;
        private final ExprNodeEvaluator eval;
        private transient boolean evaluated;
        private transient int version;
        private transient Object obj;

        DeferredExprObject(ExprNodeEvaluator eval, boolean eager) {
            this.eval = eval;
            this.eager = eager;
        }

        @Override
        public void prepare(int version) throws HiveException {
            this.version = version;
            this.evaluated = false;
            if (this.eager) {
                this.get();
            }
        }

        public boolean needsPrepare() {
            return !(this.eval instanceof ExprNodeConstantEvaluator);
        }

        @Override
        public Object get() throws HiveException {
            if (!this.evaluated) {
                this.obj = this.eval.evaluate(ExprNodeGenericFuncEvaluator.this.rowObject, this.version);
                this.evaluated = true;
            }
            return this.obj;
        }
    }
}

