/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheWrapper;
import org.apache.hadoop.hive.ql.exec.tez.LlapObjectCache;

public class ObjectCacheFactory {
    private static final ConcurrentHashMap<String, ObjectCache> llapQueryCaches = new ConcurrentHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(ObjectCacheFactory.class);

    private ObjectCacheFactory() {
    }

    public static ObjectCache getCache(Configuration conf, String queryId, boolean isPlanCache) {
        if (HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            if (LlapProxy.isDaemon()) {
                if (HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_OBJECT_CACHE_ENABLED) && !isPlanCache) {
                    return ObjectCacheFactory.getLlapObjectCache(queryId);
                }
                return new ObjectCacheWrapper(new org.apache.hadoop.hive.ql.exec.mr.ObjectCache(), queryId);
            }
            return new ObjectCacheWrapper(new org.apache.hadoop.hive.ql.exec.tez.ObjectCache(), queryId);
        }
        return new ObjectCacheWrapper(new org.apache.hadoop.hive.ql.exec.mr.ObjectCache(), queryId);
    }

    private static ObjectCache getLlapObjectCache(String queryId) {
        if (queryId == null) {
            throw new RuntimeException("Query ID cannot be null");
        }
        ObjectCache result = llapQueryCaches.get(queryId);
        if (result != null) {
            return result;
        }
        result = new LlapObjectCache();
        ObjectCache old = llapQueryCaches.putIfAbsent(queryId, result);
        if (old == null && LOG.isInfoEnabled()) {
            LOG.info("Created object cache for " + queryId);
        }
        return old != null ? old : result;
    }

    public static void removeLlapQueryCache(String queryId) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Removing object cache for " + queryId);
        }
        llapQueryCaches.remove(queryId);
    }
}

