/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import io.prestosql.hive.$internal.com.google.common.collect.Lists;
import io.prestosql.hive.$internal.com.google.common.collect.MapMaker;
import io.prestosql.hive.$internal.com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordReader;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.StatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.ReflectionUtil;

public class StatsNoJobTask
extends Task<StatsNoJobWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(StatsNoJobTask.class);
    private ConcurrentMap<String, Partition> partUpdates;
    private Table table;
    private String tableFullName;
    private JobConf jc = null;

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext driverContext, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, driverContext, opContext);
        this.jc = new JobConf((Configuration)this.conf);
    }

    @Override
    public int execute(DriverContext driverContext) {
        LOG.info("Executing stats (no job) task");
        String tableName = "";
        ExecutorService threadPool = null;
        Hive db = this.getHive();
        try {
            tableName = ((StatsNoJobWork)this.work).getTableSpecs().tableName;
            this.table = db.getTable(tableName);
            int numThreads = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVE_STATS_GATHER_NUM_THREADS);
            this.tableFullName = this.table.getDbName() + "." + this.table.getTableName();
            threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("StatsNoJobTask-Thread-%d").build());
            this.partUpdates = new MapMaker().concurrencyLevel(numThreads).makeMap();
            LOG.info("Initialized threadpool for stats computation with " + numThreads + " threads");
        }
        catch (HiveException e) {
            LOG.error("Cannot get table " + tableName, e);
            this.console.printError("Cannot get table " + tableName, e.toString());
        }
        return this.aggregateStats(threadPool, db);
    }

    @Override
    public StageType getType() {
        return StageType.STATS;
    }

    @Override
    public String getName() {
        return "STATS-NO-JOB";
    }

    private int aggregateStats(ExecutorService threadPool, Hive db) {
        int ret;
        block10: {
            ret = 0;
            try {
                Collection<Partition> partitions = null;
                partitions = ((StatsNoJobWork)this.work).getPrunedPartitionList() == null ? this.getPartitionsList() : ((StatsNoJobWork)this.work).getPrunedPartitionList().getPartitions();
                if (partitions == null) {
                    org.apache.hadoop.hive.metastore.api.Table tTable = this.table.getTTable();
                    Map<String, String> parameters = tTable.getParameters();
                    try {
                        Path dir = new Path(tTable.getSd().getLocation());
                        long numRows = 0L;
                        long rawDataSize = 0L;
                        long fileSize = 0L;
                        long numFiles = 0L;
                        FileSystem fs = dir.getFileSystem((Configuration)this.conf);
                        FileStatus[] fileList = HiveStatsUtils.getFileStatusRecurse(dir, -1, fs);
                        boolean statsAvailable = false;
                        for (FileStatus file : fileList) {
                            if (file.isDir()) continue;
                            InputFormat inputFormat = ReflectionUtil.newInstance(this.table.getInputFormatClass(), (Configuration)this.jc);
                            FileSplit dummySplit = new FileSplit(file.getPath(), 0L, 0L, new String[]{this.table.getDataLocation().toString()});
                            if (file.getLen() == 0L) {
                                ++numFiles;
                                statsAvailable = true;
                                continue;
                            }
                            RecordReader recordReader = inputFormat.getRecordReader((InputSplit)dummySplit, this.jc, Reporter.NULL);
                            if (recordReader instanceof StatsProvidingRecordReader) {
                                StatsProvidingRecordReader statsRR = (StatsProvidingRecordReader)recordReader;
                                numRows += statsRR.getStats().getRowCount();
                                rawDataSize += statsRR.getStats().getRawDataSize();
                                fileSize += file.getLen();
                                ++numFiles;
                                statsAvailable = true;
                            }
                            recordReader.close();
                        }
                        if (statsAvailable) {
                            parameters.put("numRows", String.valueOf(numRows));
                            parameters.put("rawDataSize", String.valueOf(rawDataSize));
                            parameters.put("totalSize", String.valueOf(fileSize));
                            parameters.put("numFiles", String.valueOf(numFiles));
                            EnvironmentContext environmentContext = new EnvironmentContext();
                            environmentContext.putToProperties("STATS_GENERATED", "TASK");
                            db.alterTable(this.tableFullName, new Table(tTable), environmentContext);
                            String msg = "Table " + this.tableFullName + " stats: [" + this.toString(parameters) + ']';
                            LOG.debug(msg);
                            this.console.printInfo(msg);
                            break block10;
                        }
                        String msg = "Table " + this.tableFullName + " does not provide stats.";
                        LOG.debug(msg);
                    }
                    catch (Exception e) {
                        this.console.printInfo("[Warning] could not update stats for " + this.tableFullName + ".", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                    }
                    break block10;
                }
                for (Partition partn : partitions) {
                    threadPool.execute(new StatsCollection(partn));
                }
                LOG.debug("Stats collection waiting for threadpool to shutdown..");
                this.shutdownAndAwaitTermination(threadPool);
                LOG.debug("Stats collection threadpool shutdown successful.");
                ret = this.updatePartitions(db);
            }
            catch (Exception e) {
                if (!((StatsNoJobWork)this.work).isStatsReliable()) break block10;
                ret = -1;
            }
        }
        return ret;
    }

    private int updatePartitions(Hive db) throws InvalidOperationException, HiveException {
        if (!this.partUpdates.isEmpty()) {
            ArrayList updatedParts = Lists.newArrayList(this.partUpdates.values());
            if (updatedParts.contains(null) && ((StatsNoJobWork)this.work).isStatsReliable()) {
                LOG.debug("Stats requested to be reliable. Empty stats found and hence failing the task.");
                return -1;
            }
            LOG.debug("Bulk updating partitions..");
            EnvironmentContext environmentContext = new EnvironmentContext();
            environmentContext.putToProperties("STATS_GENERATED", "TASK");
            db.alterPartitions(this.tableFullName, Lists.newArrayList(this.partUpdates.values()), environmentContext);
            LOG.debug("Bulk updated " + this.partUpdates.values().size() + " partitions.");
        }
        return 0;
    }

    private void shutdownAndAwaitTermination(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            while (!threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                LOG.debug("Waiting for all stats tasks to finish...");
            }
            threadPool.shutdownNow();
            if (!threadPool.awaitTermination(100L, TimeUnit.SECONDS)) {
                LOG.debug("Stats collection thread pool did not terminate");
            }
        }
        catch (InterruptedException ie) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private String toString(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (String statType : StatsSetupConst.supportedStats) {
            String value = parameters.get(statType);
            if (value == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(statType).append('=').append(value);
        }
        return builder.toString();
    }

    private List<Partition> getPartitionsList() throws HiveException {
        if (((StatsNoJobWork)this.work).getTableSpecs() != null) {
            BaseSemanticAnalyzer.TableSpec tblSpec = ((StatsNoJobWork)this.work).getTableSpecs();
            this.table = tblSpec.tableHandle;
            if (!this.table.isPartitioned()) {
                return null;
            }
            return tblSpec.partitions;
        }
        return null;
    }

    class StatsCollection
    implements Runnable {
        private final Partition partn;

        public StatsCollection(Partition part) {
            this.partn = part;
        }

        @Override
        public void run() {
            block6: {
                org.apache.hadoop.hive.metastore.api.Partition tPart = this.partn.getTPartition();
                Map<String, String> parameters = tPart.getParameters();
                try {
                    String threadName;
                    Path dir = new Path(tPart.getSd().getLocation());
                    long numRows = 0L;
                    long rawDataSize = 0L;
                    long fileSize = 0L;
                    long numFiles = 0L;
                    FileSystem fs = dir.getFileSystem((Configuration)StatsNoJobTask.this.conf);
                    FileStatus[] fileList = HiveStatsUtils.getFileStatusRecurse(dir, -1, fs);
                    boolean statsAvailable = false;
                    for (FileStatus file : fileList) {
                        if (file.isDir()) continue;
                        InputFormat inputFormat = ReflectionUtil.newInstance(this.partn.getInputFormatClass(), (Configuration)StatsNoJobTask.this.jc);
                        FileSplit dummySplit = new FileSplit(file.getPath(), 0L, 0L, new String[]{this.partn.getLocation()});
                        RecordReader recordReader = inputFormat.getRecordReader((InputSplit)dummySplit, StatsNoJobTask.this.jc, Reporter.NULL);
                        if (recordReader instanceof StatsProvidingRecordReader) {
                            StatsProvidingRecordReader statsRR = (StatsProvidingRecordReader)recordReader;
                            rawDataSize += statsRR.getStats().getRawDataSize();
                            numRows += statsRR.getStats().getRowCount();
                            fileSize += file.getLen();
                            ++numFiles;
                            statsAvailable = true;
                        }
                        recordReader.close();
                    }
                    if (statsAvailable) {
                        parameters.put("numRows", String.valueOf(numRows));
                        parameters.put("rawDataSize", String.valueOf(rawDataSize));
                        parameters.put("totalSize", String.valueOf(fileSize));
                        parameters.put("numFiles", String.valueOf(numFiles));
                        StatsNoJobTask.this.partUpdates.put(tPart.getSd().getLocation(), new Partition(StatsNoJobTask.this.table, tPart));
                        threadName = Thread.currentThread().getName();
                        String msg = "Partition " + StatsNoJobTask.this.tableFullName + this.partn.getSpec() + " stats: [" + this.toString(parameters) + ']';
                        LOG.debug(threadName + ": " + msg);
                        StatsNoJobTask.this.console.printInfo(msg);
                    } else {
                        threadName = Thread.currentThread().getName();
                        String msg = "Partition " + StatsNoJobTask.this.tableFullName + this.partn.getSpec() + " does not provide stats.";
                        LOG.debug(threadName + ": " + msg);
                    }
                }
                catch (Exception e) {
                    StatsNoJobTask.this.console.printInfo("[Warning] could not update stats for " + StatsNoJobTask.this.tableFullName + this.partn.getSpec() + ".", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                    if (!((StatsNoJobWork)StatsNoJobTask.this.work).isStatsReliable()) break block6;
                    StatsNoJobTask.this.partUpdates.put(tPart.getSd().getLocation(), null);
                }
            }
        }

        private String toString(Map<String, String> parameters) {
            StringBuilder builder = new StringBuilder();
            for (String statType : StatsSetupConst.supportedStats) {
                String value = parameters.get(statType);
                if (value == null) continue;
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(statType).append('=').append(value);
            }
            return builder.toString();
        }
    }
}

