/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TemporaryHashSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.spark.SmallTableCache;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SparkBucketMapJoinContext;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;

public class HashTableLoader
implements org.apache.hadoop.hive.ql.exec.HashTableLoader {
    private static final Logger LOG = LoggerFactory.getLogger(HashTableLoader.class.getName());
    private ExecMapperContext context;
    private Configuration hconf;
    private MapJoinOperator joinOp;
    private MapJoinDesc desc;
    private boolean useFastContainer = false;

    @Override
    public void init(ExecMapperContext context, MapredContext mrContext, Configuration hconf, MapJoinOperator joinOp) {
        this.context = context;
        this.hconf = hconf;
        this.joinOp = joinOp;
        this.desc = (MapJoinDesc)joinOp.getConf();
        if (this.desc.getVectorMode() && HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_FAST_HASHTABLE_ENABLED)) {
            VectorMapJoinDesc vectorDesc = (VectorMapJoinDesc)this.desc.getVectorDesc();
            this.useFastContainer = vectorDesc != null && vectorDesc.hashTableImplementationType() == VectorMapJoinDesc.HashTableImplementationType.FAST;
        }
    }

    @Override
    public void load(MapJoinTableContainer[] mapJoinTables, MapJoinTableContainerSerDe[] mapJoinTableSerdes) throws HiveException {
        String currentInputPath = this.context.getCurrentInputPath() == null ? null : this.context.getCurrentInputPath().toString();
        LOG.info("******* Load from HashTable for input file: " + currentInputPath);
        MapredLocalWork localWork = this.context.getLocalWork();
        try {
            Path baseDir;
            if (localWork.getDirectFetchOp() != null) {
                this.loadDirectly(mapJoinTables, currentInputPath);
            }
            if ((baseDir = localWork.getTmpPath()) == null) {
                return;
            }
            FileSystem fs = FileSystem.get((URI)baseDir.toUri(), (Configuration)this.hconf);
            BucketMapJoinContext mapJoinCtx = localWork.getBucketMapjoinContext();
            boolean firstContainer = true;
            boolean useOptimizedContainer = !this.useFastContainer && HiveConf.getBoolVar(this.hconf, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE);
            for (int pos = 0; pos < mapJoinTables.length; ++pos) {
                MapJoinObjectSerDeContext keyCtx;
                ObjectInspector keyOI;
                if (pos == this.desc.getPosBigTable() || mapJoinTables[pos] != null) continue;
                if (useOptimizedContainer && !MapJoinBytesTableContainer.isSupportedKey(keyOI = (keyCtx = mapJoinTableSerdes[pos].getKeyContext()).getSerDe().getObjectInspector())) {
                    if (firstContainer) {
                        LOG.warn("Not using optimized table container.Only a subset of mapjoin keys is supported.");
                        useOptimizedContainer = false;
                        HiveConf.setBoolVar(this.hconf, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE, false);
                    } else {
                        throw new HiveException("Only a subset of mapjoin keys is supported.");
                    }
                }
                firstContainer = false;
                String bigInputPath = currentInputPath;
                if (currentInputPath != null && mapJoinCtx != null) {
                    if (!this.desc.isBucketMapJoin()) {
                        bigInputPath = null;
                    } else {
                        Set<String> aliases = ((SparkBucketMapJoinContext)mapJoinCtx).getPosToAliasMap().get(pos);
                        String alias = aliases.iterator().next();
                        String smallInputPath = mapJoinCtx.getAliasBucketFileNameMapping().get(alias).get(bigInputPath).get(0);
                        bigInputPath = mapJoinCtx.getMappingBigFile(alias, smallInputPath);
                    }
                }
                String fileName = localWork.getBucketFileName(bigInputPath);
                Path path = Utilities.generatePath(baseDir, this.desc.getDumpFilePrefix(), (byte)pos, fileName);
                mapJoinTables[pos] = this.load(fs, path, mapJoinTableSerdes[pos]);
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapJoinTableContainer load(FileSystem fs, Path path, MapJoinTableContainerSerDe mapJoinTableSerde) throws HiveException {
        LOG.info("\tLoad back all hashtable files from tmp folder uri:" + path);
        if (!SparkUtilities.isDedicatedCluster(this.hconf)) {
            return this.useFastContainer ? mapJoinTableSerde.loadFastContainer(this.desc, fs, path, this.hconf) : mapJoinTableSerde.load(fs, path, this.hconf);
        }
        MapJoinTableContainer mapJoinTable = SmallTableCache.get(path);
        if (mapJoinTable == null) {
            String string = path.toString().intern();
            synchronized (string) {
                mapJoinTable = SmallTableCache.get(path);
                if (mapJoinTable == null) {
                    mapJoinTable = this.useFastContainer ? mapJoinTableSerde.loadFastContainer(this.desc, fs, path, this.hconf) : mapJoinTableSerde.load(fs, path, this.hconf);
                    SmallTableCache.cache(path, mapJoinTable);
                }
            }
        }
        return mapJoinTable;
    }

    private void loadDirectly(MapJoinTableContainer[] mapJoinTables, String inputFileName) throws Exception {
        MapredLocalWork localWork = this.context.getLocalWork();
        List<Operator<? extends OperatorDesc>> directWorks = localWork.getDirectFetchOp().get(this.joinOp);
        if (directWorks == null || directWorks.isEmpty()) {
            return;
        }
        JobConf job = new JobConf(this.hconf);
        MapredLocalTask localTask = new MapredLocalTask(localWork, job, false);
        TemporaryHashSinkOperator sink = new TemporaryHashSinkOperator(new CompilationOpContext(), this.desc);
        sink.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>(directWorks));
        for (Operator<? extends OperatorDesc> operator : directWorks) {
            if (operator == null) continue;
            operator.setChildOperators(Arrays.asList(sink));
        }
        localTask.setExecContext(this.context);
        localTask.startForward(inputFileName);
        Object[] tables = sink.getMapJoinTables();
        for (int i = 0; i < sink.getNumParent(); ++i) {
            if (sink.getParentOperators().get(i) == null) continue;
            mapJoinTables[i] = tables[i];
        }
        Arrays.fill(tables, null);
    }
}

