/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.prestosql.hive.;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.mapred.JobConf;

public class KryoSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object object) {
        .ByteArrayOutputStream stream = new .ByteArrayOutputStream();
        Output output = new Output((OutputStream)stream);
        Kryo kryo = SerializationUtilities.borrowKryo();
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            kryo.writeObject(output, object);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        output.close();
        return stream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserialize(byte[] buffer, Class<T> clazz) {
        Kryo kryo = SerializationUtilities.borrowKryo();
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        Object result = null;
        try {
            result = kryo.readObject(new Input((InputStream)new ByteArrayInputStream(buffer)), clazz);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeJobConf(JobConf jobConf) {
        .ByteArrayOutputStream out = new .ByteArrayOutputStream();
        try {
            jobConf.write((DataOutput)new DataOutputStream((OutputStream)out));
        }
        catch (IOException e) {
            LOG.error("Error serializing job configuration: " + e, e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                LOG.error("Error closing output stream: " + e, e);
            }
        }
        return out.toByteArray();
    }

    public static JobConf deserializeJobConf(byte[] buffer) {
        JobConf conf = new JobConf();
        try {
            conf.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(buffer)));
        }
        catch (IOException e) {
            String msg = "Error de-serializing job configuration: " + e;
            throw new IllegalStateException(msg, e);
        }
        return conf;
    }
}

