/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.session;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.HiveSparkClientFactory;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionImpl;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManager;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.hive.spark.client.SparkClientFactory;

public class SparkSessionManagerImpl
implements SparkSessionManager {
    private static final Logger LOG = LoggerFactory.getLogger(SparkSessionManagerImpl.class);
    private Set<SparkSession> createdSessions = Collections.synchronizedSet(new HashSet());
    private volatile boolean inited = false;
    private static SparkSessionManagerImpl instance;

    public static synchronized SparkSessionManagerImpl getInstance() throws HiveException {
        if (instance == null) {
            instance = new SparkSessionManagerImpl();
        }
        return instance;
    }

    private SparkSessionManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup(HiveConf hiveConf) throws HiveException {
        if (!this.inited) {
            SparkSessionManagerImpl sparkSessionManagerImpl = this;
            synchronized (sparkSessionManagerImpl) {
                if (!this.inited) {
                    LOG.info("Setting up the session manager.");
                    Map<String, String> conf = HiveSparkClientFactory.initiateSparkConf(hiveConf);
                    try {
                        SparkClientFactory.initialize(conf);
                        this.inited = true;
                    }
                    catch (IOException e) {
                        throw new HiveException("Error initializing SparkClientFactory", e);
                    }
                }
            }
        }
    }

    @Override
    public SparkSession getSession(SparkSession existingSession, HiveConf conf, boolean doOpen) throws HiveException {
        this.setup(conf);
        if (existingSession != null) {
            if (!existingSession.isOpen() && doOpen) {
                existingSession.open(conf);
            }
            return existingSession;
        }
        SparkSessionImpl sparkSession = new SparkSessionImpl();
        if (doOpen) {
            sparkSession.open(conf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("New session (%s) is created.", sparkSession.getSessionId()));
        }
        this.createdSessions.add(sparkSession);
        return sparkSession;
    }

    @Override
    public void returnSession(SparkSession sparkSession) throws HiveException {
    }

    @Override
    public void closeSession(SparkSession sparkSession) throws HiveException {
        if (sparkSession == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Closing session (%s).", sparkSession.getSessionId()));
        }
        sparkSession.close();
        this.createdSessions.remove(sparkSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        LOG.info("Closing the session manager.");
        Set<SparkSession> set = this.createdSessions;
        synchronized (set) {
            for (SparkSession session : this.createdSessions) {
                session.close();
            }
            this.createdSessions.clear();
        }
        this.inited = false;
        SparkClientFactory.stop();
    }

    static {
        ShutdownHookManager.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                try {
                    if (instance != null) {
                        instance.shutdown();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

