/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import io.prestosql.hive.$internal.com.google.common.annotations.VisibleForTesting;
import java.io.DataOutput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;

public class VectorAppMasterEventOperator
extends AppMasterEventOperator {
    private static final long serialVersionUID = 1L;
    private VectorizationContext vContext;
    private transient boolean firstBatch;
    private transient VectorExtractRow vectorExtractRow;
    protected transient Object[] singleRow;

    public VectorAppMasterEventOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) {
        super(ctx);
        this.conf = (AppMasterEventDesc)conf;
        this.vContext = vContext;
    }

    @VisibleForTesting
    public VectorAppMasterEventOperator() {
    }

    public VectorAppMasterEventOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        this.inputObjInspectors[0] = VectorizedBatchUtil.convertToStandardStructObjectInspector((StructObjectInspector)this.inputObjInspectors[0]);
        super.initializeOp(hconf);
        this.firstBatch = true;
    }

    @Override
    public void process(Object data, int tag) throws HiveException {
        ObjectInspector rowInspector;
        block7: {
            if (this.hasReachedMaxSize) {
                return;
            }
            VectorizedRowBatch batch = (VectorizedRowBatch)data;
            if (this.firstBatch) {
                this.vectorExtractRow = new VectorExtractRow();
                this.vectorExtractRow.init((StructObjectInspector)this.inputObjInspectors[0], this.vContext.getProjectedColumns());
                this.singleRow = new Object[this.vectorExtractRow.getCount()];
                this.firstBatch = false;
            }
            rowInspector = this.inputObjInspectors[0];
            try {
                if (batch.selectedInUse) {
                    int[] selected = batch.selected;
                    for (int logical = 0; logical < batch.size; ++logical) {
                        int batchIndex = selected[logical];
                        this.vectorExtractRow.extractRow(batch, batchIndex, this.singleRow);
                        Writable writableRow = this.serializer.serialize(this.singleRow, rowInspector);
                        writableRow.write((DataOutput)this.buffer);
                        if ((long)this.buffer.getLength() <= this.MAX_SIZE) continue;
                        this.LOG.info("Disabling AM events. Buffer size too large: " + this.buffer.getLength());
                        this.hasReachedMaxSize = true;
                        this.buffer = null;
                        break block7;
                    }
                    break block7;
                }
                for (int batchIndex = 0; batchIndex < batch.size; ++batchIndex) {
                    this.vectorExtractRow.extractRow(batch, batchIndex, this.singleRow);
                    Writable writableRow = this.serializer.serialize(this.singleRow, rowInspector);
                    writableRow.write((DataOutput)this.buffer);
                    if ((long)this.buffer.getLength() <= this.MAX_SIZE) continue;
                    this.LOG.info("Disabling AM events. Buffer size too large: " + this.buffer.getLength());
                    this.hasReachedMaxSize = true;
                    this.buffer = null;
                    break;
                }
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        this.forward(data, rowInspector);
    }
}

