/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import io.prestosql.hive.$internal.com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class VectorHashKeyWrapper
extends KeyWrapper {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final byte[][] EMPTY_BYTES_ARRAY = new byte[0][];
    private static final HiveDecimalWritable[] EMPTY_DECIMAL_ARRAY = new HiveDecimalWritable[0];
    private static final Timestamp[] EMPTY_TIMESTAMP_ARRAY = new Timestamp[0];
    private static final HiveIntervalDayTime[] EMPTY_INTERVAL_DAY_TIME_ARRAY = new HiveIntervalDayTime[0];
    public static final VectorHashKeyWrapper EMPTY_KEY_WRAPPER = new EmptyVectorHashKeyWrapper();
    private long[] longValues;
    private double[] doubleValues;
    private byte[][] byteValues;
    private int[] byteStarts;
    private int[] byteLengths;
    private HiveDecimalWritable[] decimalValues;
    private Timestamp[] timestampValues;
    private static Timestamp ZERO_TIMESTAMP = new Timestamp(0L);
    private HiveIntervalDayTime[] intervalDayTimeValues;
    private static HiveIntervalDayTime ZERO_INTERVALDAYTIME = new HiveIntervalDayTime(0L, 0);
    private boolean[] isNull;
    private int hashcode;

    private VectorHashKeyWrapper(int longValuesCount, int doubleValuesCount, int byteValuesCount, int decimalValuesCount, int timestampValuesCount, int intervalDayTimeValuesCount, int keyCount) {
        int i;
        this.longValues = longValuesCount > 0 ? new long[longValuesCount] : EMPTY_LONG_ARRAY;
        this.doubleValues = doubleValuesCount > 0 ? new double[doubleValuesCount] : EMPTY_DOUBLE_ARRAY;
        this.decimalValues = decimalValuesCount > 0 ? new HiveDecimalWritable[decimalValuesCount] : EMPTY_DECIMAL_ARRAY;
        this.timestampValues = timestampValuesCount > 0 ? new Timestamp[timestampValuesCount] : EMPTY_TIMESTAMP_ARRAY;
        this.intervalDayTimeValues = intervalDayTimeValuesCount > 0 ? new HiveIntervalDayTime[intervalDayTimeValuesCount] : EMPTY_INTERVAL_DAY_TIME_ARRAY;
        for (i = 0; i < decimalValuesCount; ++i) {
            this.decimalValues[i] = new HiveDecimalWritable(HiveDecimal.ZERO);
        }
        if (byteValuesCount > 0) {
            this.byteValues = new byte[byteValuesCount][];
            this.byteStarts = new int[byteValuesCount];
            this.byteLengths = new int[byteValuesCount];
        } else {
            this.byteValues = EMPTY_BYTES_ARRAY;
            this.byteStarts = EMPTY_INT_ARRAY;
            this.byteLengths = EMPTY_INT_ARRAY;
        }
        for (i = 0; i < timestampValuesCount; ++i) {
            this.timestampValues[i] = new Timestamp(0L);
        }
        for (i = 0; i < intervalDayTimeValuesCount; ++i) {
            this.intervalDayTimeValues[i] = new HiveIntervalDayTime();
        }
        this.isNull = new boolean[keyCount];
        this.hashcode = 0;
    }

    private VectorHashKeyWrapper() {
    }

    public static VectorHashKeyWrapper allocate(int longValuesCount, int doubleValuesCount, int byteValuesCount, int decimalValuesCount, int timestampValuesCount, int intervalDayTimeValuesCount, int keyCount) {
        if (longValuesCount + doubleValuesCount + byteValuesCount + decimalValuesCount + timestampValuesCount + intervalDayTimeValuesCount == 0) {
            return EMPTY_KEY_WRAPPER;
        }
        return new VectorHashKeyWrapper(longValuesCount, doubleValuesCount, byteValuesCount, decimalValuesCount, timestampValuesCount, intervalDayTimeValuesCount, keyCount);
    }

    @Override
    public void getNewKey(Object row, ObjectInspector rowInspector) throws HiveException {
        throw new HiveException("Should not be called");
    }

    @Override
    public void setHashKey() {
        int i;
        this.hashcode = Arrays.hashCode(this.longValues) ^ Arrays.hashCode(this.doubleValues) ^ Arrays.hashCode(this.isNull);
        for (i = 0; i < this.decimalValues.length; ++i) {
            this.hashcode ^= this.decimalValues[i].newFasterHashCode();
        }
        for (i = 0; i < this.timestampValues.length; ++i) {
            this.hashcode ^= this.timestampValues[i].hashCode();
        }
        for (i = 0; i < this.intervalDayTimeValues.length; ++i) {
            this.hashcode ^= this.intervalDayTimeValues[i].hashCode();
        }
        for (i = 0; i < this.byteValues.length; ++i) {
            if (this.byteLengths[i] == -1) continue;
            byte[] bytes = this.byteValues[i];
            int start = this.byteStarts[i];
            int length = this.byteLengths[i];
            for (int j = start; j < start + length; ++j) {
                this.hashcode ^= 461 * bytes[j];
            }
        }
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object that) {
        if (that instanceof VectorHashKeyWrapper) {
            VectorHashKeyWrapper keyThat = (VectorHashKeyWrapper)that;
            return this.hashcode == keyThat.hashcode && Arrays.equals(this.longValues, keyThat.longValues) && Arrays.equals(this.doubleValues, keyThat.doubleValues) && Arrays.equals(this.decimalValues, keyThat.decimalValues) && Arrays.equals(this.timestampValues, keyThat.timestampValues) && Arrays.equals(this.intervalDayTimeValues, keyThat.intervalDayTimeValues) && Arrays.equals(this.isNull, keyThat.isNull) && this.byteValues.length == keyThat.byteValues.length && (0 == this.byteValues.length || this.bytesEquals(keyThat));
        }
        return false;
    }

    private boolean bytesEquals(VectorHashKeyWrapper keyThat) {
        for (int i = 0; i < this.byteValues.length; ++i) {
            if (this.byteLengths[i] == -1 || StringExpr.equal(this.byteValues[i], this.byteStarts[i], this.byteLengths[i], keyThat.byteValues[i], keyThat.byteStarts[i], keyThat.byteLengths[i])) continue;
            return false;
        }
        return true;
    }

    protected Object clone() {
        VectorHashKeyWrapper clone = new VectorHashKeyWrapper();
        this.duplicateTo(clone);
        return clone;
    }

    public void duplicateTo(VectorHashKeyWrapper clone) {
        int i;
        clone.longValues = this.longValues.length > 0 ? (long[])this.longValues.clone() : EMPTY_LONG_ARRAY;
        clone.doubleValues = this.doubleValues.length > 0 ? (double[])this.doubleValues.clone() : EMPTY_DOUBLE_ARRAY;
        clone.isNull = (boolean[])this.isNull.clone();
        if (this.decimalValues.length > 0) {
            clone.decimalValues = new HiveDecimalWritable[this.decimalValues.length];
            for (i = 0; i < this.decimalValues.length; ++i) {
                clone.decimalValues[i] = new HiveDecimalWritable(this.decimalValues[i]);
            }
        } else {
            clone.decimalValues = EMPTY_DECIMAL_ARRAY;
        }
        if (this.byteLengths.length > 0) {
            clone.byteValues = new byte[this.byteValues.length][];
            clone.byteStarts = new int[this.byteValues.length];
            clone.byteLengths = (int[])this.byteLengths.clone();
            for (i = 0; i < this.byteValues.length; ++i) {
                if (this.byteLengths[i] == -1) continue;
                clone.byteValues[i] = Arrays.copyOfRange(this.byteValues[i], this.byteStarts[i], this.byteStarts[i] + this.byteLengths[i]);
            }
        } else {
            clone.byteValues = EMPTY_BYTES_ARRAY;
            clone.byteStarts = EMPTY_INT_ARRAY;
            clone.byteLengths = EMPTY_INT_ARRAY;
        }
        if (this.timestampValues.length > 0) {
            clone.timestampValues = new Timestamp[this.timestampValues.length];
            for (i = 0; i < this.timestampValues.length; ++i) {
                clone.timestampValues[i] = (Timestamp)this.timestampValues[i].clone();
            }
        } else {
            clone.timestampValues = EMPTY_TIMESTAMP_ARRAY;
        }
        if (this.intervalDayTimeValues.length > 0) {
            clone.intervalDayTimeValues = new HiveIntervalDayTime[this.intervalDayTimeValues.length];
            for (i = 0; i < this.intervalDayTimeValues.length; ++i) {
                clone.intervalDayTimeValues[i] = (HiveIntervalDayTime)this.intervalDayTimeValues[i].clone();
            }
        } else {
            clone.intervalDayTimeValues = EMPTY_INTERVAL_DAY_TIME_ARRAY;
        }
        clone.hashcode = this.hashcode;
        assert (clone.equals(this));
    }

    @Override
    public KeyWrapper copyKey() {
        return (KeyWrapper)this.clone();
    }

    @Override
    public void copyKey(KeyWrapper oldWrapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] getKeyArray() {
        throw new UnsupportedOperationException();
    }

    public void assignLong(int index, long v) {
        this.longValues[index] = v;
    }

    public void assignNullLong(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.longValues[index] = 0L;
    }

    public void assignDouble(int index, double d) {
        this.doubleValues[index] = d;
    }

    public void assignNullDouble(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.doubleValues[index] = 0.0;
    }

    public void assignString(int index, byte[] bytes, int start, int length) {
        Preconditions.checkState(bytes != null);
        this.byteValues[index] = bytes;
        this.byteStarts[index] = start;
        this.byteLengths[index] = length;
    }

    public void assignNullString(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.byteValues[index] = null;
        this.byteStarts[index] = 0;
        this.byteLengths[index] = -1;
    }

    public void assignDecimal(int index, HiveDecimalWritable value) {
        this.decimalValues[index].set(value);
    }

    public void assignNullDecimal(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.decimalValues[index].set(HiveDecimal.ZERO);
    }

    public void assignTimestamp(int index, Timestamp value) {
        this.timestampValues[index] = value;
    }

    public void assignTimestamp(int index, TimestampColumnVector colVector, int elementNum) {
        colVector.timestampUpdate(this.timestampValues[index], elementNum);
    }

    public void assignNullTimestamp(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.timestampValues[index] = ZERO_TIMESTAMP;
    }

    public void assignIntervalDayTime(int index, HiveIntervalDayTime value) {
        this.intervalDayTimeValues[index].set(value);
    }

    public void assignIntervalDayTime(int index, IntervalDayTimeColumnVector colVector, int elementNum) {
        this.intervalDayTimeValues[index].set(colVector.asScratchIntervalDayTime(elementNum));
    }

    public void assignNullIntervalDayTime(int keyIndex, int index) {
        this.isNull[keyIndex] = true;
        this.intervalDayTimeValues[index] = ZERO_INTERVALDAYTIME;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        if (this.longValues.length > 0) {
            isFirst = false;
            sb.append("longs ");
            sb.append(Arrays.toString(this.longValues));
        }
        if (this.doubleValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("doubles ");
            sb.append(Arrays.toString(this.doubleValues));
        }
        if (this.byteValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("byte lengths ");
            sb.append(Arrays.toString(this.byteLengths));
        }
        if (this.decimalValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("decimals ");
            sb.append(Arrays.toString(this.decimalValues));
        }
        if (this.timestampValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("timestamps ");
            sb.append(Arrays.toString(this.timestampValues));
        }
        if (this.intervalDayTimeValues.length > 0) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append("interval day times ");
            sb.append(Arrays.toString(this.intervalDayTimeValues));
        }
        if (isFirst) {
            isFirst = false;
        } else {
            sb.append(", ");
        }
        sb.append("nulls ");
        sb.append(Arrays.toString(this.isNull));
        return sb.toString();
    }

    public long getLongValue(int i) {
        return this.longValues[i];
    }

    public double getDoubleValue(int i) {
        return this.doubleValues[i];
    }

    public byte[] getBytes(int i) {
        return this.byteValues[i];
    }

    public int getByteStart(int i) {
        return this.byteStarts[i];
    }

    public int getByteLength(int i) {
        return this.byteLengths[i];
    }

    public int getVariableSize() {
        int variableSize = 0;
        for (int i = 0; i < this.byteLengths.length; ++i) {
            JavaDataModel model = JavaDataModel.get();
            variableSize += model.lengthForByteArrayOfSize(this.byteLengths[i]);
        }
        return variableSize;
    }

    public HiveDecimalWritable getDecimal(int i) {
        return this.decimalValues[i];
    }

    public Timestamp getTimestamp(int i) {
        return this.timestampValues[i];
    }

    public HiveIntervalDayTime getIntervalDayTime(int i) {
        return this.intervalDayTimeValues[i];
    }

    public void clearIsNull() {
        Arrays.fill(this.isNull, false);
    }

    public boolean isNull(int keyIndex) {
        return this.isNull[keyIndex];
    }

    public static final class EmptyVectorHashKeyWrapper
    extends VectorHashKeyWrapper {
        private EmptyVectorHashKeyWrapper() {
            super(0, 0, 0, 0, 0, 0, 0);
        }

        @Override
        protected Object clone() {
            return this;
        }

        @Override
        public boolean equals(Object that) {
            if (that == this) {
                return true;
            }
            return super.equals(that);
        }
    }
}

