/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import io.prestosql.hive.$internal.com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterExprOrExpr
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final transient int[] initialSelected = new int[1024];
    private transient int[] unselected = new int[1024];
    private transient int[] unselectedCopy = new int[1024];
    private transient int[] difference = new int[1024];
    private final transient int[] tmp = new int[1024];

    private int subtract(int[] all, int allSize, int[] remove, int removeSize, int[] difference) {
        Preconditions.checkState(all != remove && remove != difference && difference != all);
        if (!this.verifyMonotonicallyIncreasing(all, allSize)) {
            throw new RuntimeException("all is not in sort order and unique");
        }
        if (!this.verifyMonotonicallyIncreasing(remove, removeSize)) {
            throw new RuntimeException("remove is not in sort order and unique");
        }
        int differenceCount = 0;
        int removeIndex = 0;
        for (int i = 0; i < allSize; ++i) {
            int candidateIndex = all[i];
            if (removeIndex < removeSize && candidateIndex == remove[removeIndex]) {
                ++removeIndex;
                continue;
            }
            difference[differenceCount++] = candidateIndex;
        }
        if (removeIndex != removeSize) {
            throw new RuntimeException("Not all batch indices removed");
        }
        if (!this.verifyMonotonicallyIncreasing(difference, differenceCount)) {
            throw new RuntimeException("difference is not in sort order and unique");
        }
        return differenceCount;
    }

    public boolean verifyMonotonicallyIncreasing(int[] selected, int size) {
        if (size == 0) {
            return true;
        }
        int prevBatchIndex = selected[0];
        for (int i = 1; i < size; ++i) {
            int batchIndex = selected[i];
            if (batchIndex <= prevBatchIndex) {
                return false;
            }
            prevBatchIndex = batchIndex;
        }
        return true;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        int j;
        int n = batch.size;
        if (n <= 0) {
            return;
        }
        VectorExpression childExpr1 = this.childExpressions[0];
        boolean prevSelectInUse = batch.selectedInUse;
        int[] sel = batch.selected;
        if (batch.selectedInUse) {
            System.arraycopy(sel, 0, this.initialSelected, 0, n);
        } else {
            for (int i = 0; i < n; ++i) {
                this.initialSelected[i] = i;
                sel[i] = i;
            }
            batch.selectedInUse = true;
        }
        childExpr1.evaluate(batch);
        int sizeAfterFirstChild = batch.size;
        int[] selectedAfterFirstChild = batch.selected;
        for (j = 0; j < n; ++j) {
            this.tmp[this.initialSelected[j]] = 0;
        }
        for (j = 0; j < batch.size; ++j) {
            this.tmp[selectedAfterFirstChild[j]] = 1;
        }
        int unselectedSize = 0;
        for (int j2 = 0; j2 < n; ++j2) {
            int i = this.initialSelected[j2];
            if (this.tmp[i] != 0) continue;
            this.unselected[unselectedSize++] = i;
        }
        int newSize = sizeAfterFirstChild;
        batch.selected = this.unselected;
        batch.size = unselectedSize;
        if (unselectedSize > 0) {
            int childrenCount = this.childExpressions.length;
            int childIndex = 1;
            while (true) {
                boolean isLastChild;
                boolean bl = isLastChild = childIndex + 1 >= childrenCount;
                if (!isLastChild) {
                    System.arraycopy(batch.selected, 0, this.unselectedCopy, 0, unselectedSize);
                }
                VectorExpression childExpr = this.childExpressions[childIndex];
                childExpr.evaluate(batch);
                newSize += batch.size;
                for (int i = 0; i < batch.size; ++i) {
                    this.tmp[batch.selected[i]] = 1;
                }
                if (isLastChild || (unselectedSize = this.subtract(this.unselectedCopy, unselectedSize, batch.selected, batch.size, this.difference)) == 0) break;
                System.arraycopy(this.difference, 0, batch.selected, 0, unselectedSize);
                batch.size = unselectedSize;
                ++childIndex;
            }
        }
        batch.selected = selectedAfterFirstChild;
        int k = 0;
        for (int j3 = 0; j3 < n; ++j3) {
            int i = this.initialSelected[j3];
            if (this.tmp[i] != 1) continue;
            batch.selected[k++] = i;
        }
        batch.size = newSize;
        if (newSize == n) {
            batch.selectedInUse = prevSelectInUse;
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public String vectorExpressionParameters() {
        return null;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

