/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FilterCharColumnBetween;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

public class FilterCharColumnBetweenDynamicValue
extends FilterCharColumnBetween {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FilterCharColumnBetweenDynamicValue.class);
    protected DynamicValue leftDynamicValue;
    protected DynamicValue rightDynamicValue;
    protected transient boolean initialized = false;
    protected transient boolean isLeftOrRightNull = false;

    public FilterCharColumnBetweenDynamicValue(int colNum, DynamicValue leftValue, DynamicValue rightValue) {
        super(colNum, new HiveChar("", 1), new HiveChar("", 1));
        this.leftDynamicValue = leftValue;
        this.rightDynamicValue = rightValue;
    }

    public FilterCharColumnBetweenDynamicValue() {
    }

    public DynamicValue getLeftDynamicValue() {
        return this.leftDynamicValue;
    }

    public void setLeftDynamicValue(DynamicValue leftValue) {
        this.leftDynamicValue = leftValue;
    }

    public DynamicValue getRightDynamicValue() {
        return this.rightDynamicValue;
    }

    public void getRightDynamicValue(DynamicValue rightValue) {
        this.rightDynamicValue = rightValue;
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        this.leftDynamicValue.setConf(conf);
        this.rightDynamicValue.setConf(conf);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (!this.initialized) {
            Object lVal = this.leftDynamicValue.getValue();
            Object rVal = this.rightDynamicValue.getValue();
            if (lVal == null || rVal == null) {
                this.isLeftOrRightNull = true;
            } else {
                byte[] min = PrimitiveObjectInspectorUtils.getHiveChar(lVal, this.leftDynamicValue.getObjectInspector()).getStrippedValue().getBytes();
                this.setLeftValue(min);
                byte[] max = PrimitiveObjectInspectorUtils.getHiveChar(rVal, this.rightDynamicValue.getObjectInspector()).getStrippedValue().getBytes();
                this.setRightValue(max);
            }
            this.initialized = true;
        }
        if (this.isLeftOrRightNull) {
            batch.size = 0;
        }
        super.evaluate(batch);
    }
}

