/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;

public class WriteEntity
extends Entity
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(WriteEntity.class);
    private boolean isTempURI = false;
    private transient boolean isDynamicPartitionWrite = false;
    private WriteType writeType;

    public WriteEntity() {
    }

    public WriteEntity(Database database, WriteType type) {
        super(database, true);
        this.writeType = type;
    }

    public WriteEntity(Table t, WriteType type) {
        super(t, true);
        this.writeType = type;
    }

    public WriteEntity(Table t, WriteType type, boolean complete) {
        super(t, complete);
        this.writeType = type;
    }

    public WriteEntity(Database db, String objName, Entity.Type type, WriteType writeType) {
        super(db, objName, type);
        this.writeType = writeType;
    }

    public WriteEntity(Partition p, WriteType type) {
        super(p, true);
        this.writeType = type;
    }

    public WriteEntity(DummyPartition p, WriteType type, boolean complete) {
        super(p, complete);
        this.writeType = type;
    }

    public WriteEntity(Path d, boolean islocal) {
        this(d, islocal, false);
    }

    public WriteEntity(Path d, boolean islocal, boolean isTemp) {
        super(d, islocal, true);
        this.isTempURI = isTemp;
        this.writeType = WriteType.PATH_WRITE;
    }

    public WriteType getWriteType() {
        return this.writeType;
    }

    public void setWriteType(WriteType type) {
        this.writeType = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof WriteEntity) {
            WriteEntity ore = (WriteEntity)o;
            return this.getName().equalsIgnoreCase(ore.getName()) && this.writeType == ore.writeType;
        }
        return false;
    }

    public String toStringDetail() {
        return "WriteEntity(" + this.toString() + ") Type=" + (Object)((Object)this.getType()) + " WriteType=" + (Object)((Object)this.getWriteType());
    }

    public boolean isTempURI() {
        return this.isTempURI;
    }

    public static WriteType determineAlterTableWriteType(AlterTableDesc.AlterTableTypes op) {
        switch (op) {
            case RENAMECOLUMN: 
            case ADDCLUSTERSORTCOLUMN: 
            case ADDFILEFORMAT: 
            case ADDSERDE: 
            case DROPPROPS: 
            case REPLACECOLS: 
            case ARCHIVE: 
            case UNARCHIVE: 
            case ALTERLOCATION: 
            case DROPPARTITION: 
            case RENAMEPARTITION: 
            case ADDSKEWEDBY: 
            case ALTERSKEWEDLOCATION: 
            case ALTERBUCKETNUM: 
            case ALTERPARTITION: 
            case ADDCOLS: 
            case RENAME: 
            case TRUNCATE: 
            case MERGEFILES: 
            case DROPCONSTRAINT: {
                return WriteType.DDL_EXCLUSIVE;
            }
            case ADDPARTITION: 
            case ADDSERDEPROPS: 
            case ADDPROPS: {
                return WriteType.DDL_SHARED;
            }
            case COMPACT: 
            case TOUCH: {
                return WriteType.DDL_NO_LOCK;
            }
        }
        throw new RuntimeException("Unknown operation " + op.toString());
    }

    public boolean isDynamicPartitionWrite() {
        return this.isDynamicPartitionWrite;
    }

    public void setDynamicPartitionWrite(boolean t) {
        this.isDynamicPartitionWrite = t;
    }

    public String toDetailedString() {
        return this.toString() + " Type=" + (Object)((Object)this.getTyp()) + " WriteType=" + (Object)((Object)this.getWriteType()) + " isDP=" + this.isDynamicPartitionWrite();
    }

    public static enum WriteType {
        DDL_EXCLUSIVE,
        DDL_SHARED,
        DDL_NO_LOCK,
        INSERT,
        INSERT_OVERWRITE,
        UPDATE,
        DELETE,
        PATH_WRITE;

    }
}

