/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import io.prestosql.hive.$internal.com.google.common.annotations.VisibleForTesting;
import io.prestosql.hive.$internal.com.google.common.collect.Iterables;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.index.IndexResult;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;

public final class SplitFilter {
    public static final Logger LOG = LoggerFactory.getLogger(SplitFilter.class);
    private final IndexResult indexResult;
    private final long maxInputSize;

    public SplitFilter(IndexResult indexResult, long maxInputSize) {
        this.indexResult = indexResult;
        this.maxInputSize = maxInputSize;
    }

    public List<HiveInputFormat.HiveInputSplit> filter(HiveInputFormat.HiveInputSplit[] splits) throws IOException {
        long sumSplitLengths = 0L;
        ArrayList<HiveInputFormat.HiveInputSplit> newSplits = new ArrayList<HiveInputFormat.HiveInputSplit>();
        Arrays.sort(splits, new HiveInputSplitComparator());
        for (HiveInputFormat.HiveInputSplit split : splits) {
            LOG.info("split start : " + split.getStart());
            LOG.info("split end : " + (split.getStart() + split.getLength()));
            try {
                if (!this.indexResult.contains(split)) continue;
                HiveInputFormat.HiveInputSplit newSplit = split;
                if (this.isAdjustmentRequired(newSplits, split)) {
                    newSplit = this.adjustSplit(split);
                }
                if ((sumSplitLengths += newSplit.getLength()) > this.maxInputSize) {
                    String messageTemplate = "Size of data to read during a compact-index-based query exceeded the maximum of %d set in %s";
                    throw new IOException(String.format(messageTemplate, this.maxInputSize, HiveConf.ConfVars.HIVE_INDEX_COMPACT_QUERY_MAX_SIZE.varname));
                }
                newSplits.add(newSplit);
            }
            catch (HiveException e) {
                throw new RuntimeException("Unable to get metadata for input table split " + split.getPath(), e);
            }
        }
        LOG.info("Number of input splits: {}, new input splits: {}, sum of split lengths: {}", splits.length, newSplits.size(), sumSplitLengths);
        return newSplits;
    }

    private boolean isAdjustmentRequired(List<HiveInputFormat.HiveInputSplit> newSplits, HiveInputFormat.HiveInputSplit split) {
        return (split.inputFormatClassName().contains("RCFile") || split.inputFormatClassName().contains("SequenceFile")) && split.getStart() > 0L && !this.doesOverlap(newSplits, split.getPath(), this.adjustStart(split.getStart()));
    }

    private boolean doesOverlap(List<HiveInputFormat.HiveInputSplit> newSplits, Path path, long start) {
        if (newSplits.isEmpty()) {
            return false;
        }
        HiveInputFormat.HiveInputSplit lastSplit = Iterables.getLast(newSplits);
        if (lastSplit.getPath().equals((Object)path)) {
            return lastSplit.getStart() + lastSplit.getLength() > start;
        }
        return false;
    }

    private long adjustStart(long start) {
        return start > 2000L ? start - 2000L : 0L;
    }

    private HiveInputFormat.HiveInputSplit adjustSplit(HiveInputFormat.HiveInputSplit split) throws IOException {
        long adjustedStart = this.adjustStart(split.getStart());
        return new HiveInputFormat.HiveInputSplit((InputSplit)new FileSplit(split.getPath(), adjustedStart, split.getStart() - adjustedStart + split.getLength(), split.getLocations()), split.inputFormatClassName());
    }

    @VisibleForTesting
    static final class HiveInputSplitComparator
    implements Comparator<HiveInputFormat.HiveInputSplit> {
        HiveInputSplitComparator() {
        }

        @Override
        public int compare(HiveInputFormat.HiveInputSplit o1, HiveInputFormat.HiveInputSplit o2) {
            int pathCompare = this.comparePath(o1.getPath(), o2.getPath());
            if (pathCompare != 0) {
                return pathCompare;
            }
            return Long.compare(o1.getStart(), o2.getStart());
        }

        private int comparePath(Path p1, Path p2) {
            return p1.compareTo((Object)p2);
        }
    }
}

