/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import io.prestosql.hive.$internal.com.google.common.collect.Lists;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.llap.DebugUtils;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.RecordReader;

public abstract class BatchToRowReader<StructType, UnionType>
implements RecordReader<NullWritable, Object> {
    protected static final Logger LOG = LoggerFactory.getLogger(BatchToRowReader.class);
    private final NullWritable key;
    private final VectorizedRowBatch batch;
    private final RecordReader<NullWritable, VectorizedRowBatch> vrbReader;
    private final List<TypeInfo> schema;
    private final boolean[] included;
    private int rowInBatch = 0;

    public BatchToRowReader(RecordReader<NullWritable, VectorizedRowBatch> vrbReader, VectorizedRowBatchCtx vrbCtx, List<Integer> includedCols) {
        this.vrbReader = vrbReader;
        this.key = (NullWritable)vrbReader.createKey();
        this.batch = (VectorizedRowBatch)vrbReader.createValue();
        this.schema = Lists.newArrayList(vrbCtx.getRowColumnTypeInfos());
        boolean[] included = new boolean[this.schema.size()];
        if (includedCols != null) {
            for (int colIx : includedCols) {
                included[colIx] = true;
            }
        } else {
            Arrays.fill(included, true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Including the columns " + DebugUtils.toString(included));
        }
        this.included = included;
    }

    protected abstract StructType createStructObject(Object var1, List<TypeInfo> var2);

    protected abstract void setStructCol(StructType var1, int var2, Object var3);

    protected abstract Object getStructCol(StructType var1, int var2);

    protected abstract UnionType createUnionObject(List<TypeInfo> var1, Object var2);

    protected abstract void setUnion(UnionType var1, byte var2, Object var3);

    protected abstract Object getUnionField(UnionType var1);

    public NullWritable createKey() {
        return this.key;
    }

    public Object createValue() {
        return this.createStructObject(null, this.schema);
    }

    public long getPos() throws IOException {
        return -1L;
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    public boolean next(NullWritable key, Object previous) throws IOException {
        if (!this.ensureBatch()) {
            return false;
        }
        Object value = previous;
        for (int i = 0; i < this.schema.size(); ++i) {
            if (!this.included[i]) continue;
            try {
                this.setStructCol(value, i, this.nextValue(this.batch.cols[i], this.rowInBatch, this.schema.get(i), this.getStructCol(value, i)));
                continue;
            }
            catch (Throwable t) {
                LOG.error("Error at row " + this.rowInBatch + "/" + this.batch.size + ", column " + i + "/" + this.schema.size() + " " + this.batch.cols[i], t);
                throw t instanceof IOException ? (IOException)t : new IOException(t);
            }
        }
        ++this.rowInBatch;
        return true;
    }

    private boolean ensureBatch() throws IOException {
        if (this.rowInBatch >= this.batch.size) {
            this.rowInBatch = 0;
            return this.vrbReader.next((Object)this.key, (Object)this.batch) && this.batch.size > 0;
        }
        return true;
    }

    public void close() throws IOException {
        this.vrbReader.close();
        this.batch.cols = null;
    }

    public static BooleanWritable nextBoolean(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            BooleanWritable result = previous == null || previous.getClass() != BooleanWritable.class ? new BooleanWritable() : (BooleanWritable)previous;
            result.set(((LongColumnVector)vector).vector[row] != 0L);
            return result;
        }
        return null;
    }

    public static ByteWritable nextByte(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            ByteWritable result = previous == null || previous.getClass() != ByteWritable.class ? new ByteWritable() : (ByteWritable)((Object)previous);
            result.set((byte)((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    public static ShortWritable nextShort(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            ShortWritable result = previous == null || previous.getClass() != ShortWritable.class ? new ShortWritable() : (ShortWritable)previous;
            result.set((short)((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    public static IntWritable nextInt(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            IntWritable result = previous == null || previous.getClass() != IntWritable.class ? new IntWritable() : (IntWritable)previous;
            result.set((int)((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    public static LongWritable nextLong(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            LongWritable result = previous == null || previous.getClass() != LongWritable.class ? new LongWritable() : (LongWritable)previous;
            result.set(((LongColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    public static FloatWritable nextFloat(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            FloatWritable result = previous == null || previous.getClass() != FloatWritable.class ? new FloatWritable() : (FloatWritable)previous;
            result.set((float)((DoubleColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    public static DoubleWritable nextDouble(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            DoubleWritable result = previous == null || previous.getClass() != DoubleWritable.class ? new DoubleWritable() : (DoubleWritable)((Object)previous);
            result.set(((DoubleColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    public static Text nextString(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            Text result = previous == null || previous.getClass() != Text.class ? new Text() : (Text)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.vector[row], bytes.start[row], bytes.length[row]);
            return result;
        }
        return null;
    }

    public static HiveCharWritable nextChar(ColumnVector vector, int row, int size, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            HiveCharWritable result = previous == null || previous.getClass() != HiveCharWritable.class ? new HiveCharWritable() : (HiveCharWritable)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.toString(row), size);
            return result;
        }
        return null;
    }

    public static HiveVarcharWritable nextVarchar(ColumnVector vector, int row, int size, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            HiveVarcharWritable result = previous == null || previous.getClass() != HiveVarcharWritable.class ? new HiveVarcharWritable() : (HiveVarcharWritable)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.toString(row), size);
            return result;
        }
        return null;
    }

    public static BytesWritable nextBinary(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            BytesWritable result = previous == null || previous.getClass() != BytesWritable.class ? new BytesWritable() : (BytesWritable)previous;
            BytesColumnVector bytes = (BytesColumnVector)vector;
            result.set(bytes.vector[row], bytes.start[row], bytes.length[row]);
            return result;
        }
        return null;
    }

    public static HiveDecimalWritable nextDecimal(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            HiveDecimalWritable result = previous == null || previous.getClass() != HiveDecimalWritable.class ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
            result.set(((DecimalColumnVector)vector).vector[row]);
            return result;
        }
        return null;
    }

    public static DateWritable nextDate(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            DateWritable result = previous == null || previous.getClass() != DateWritable.class ? new DateWritable() : (DateWritable)previous;
            int date = (int)((LongColumnVector)vector).vector[row];
            result.set(date);
            return result;
        }
        return null;
    }

    public static TimestampWritable nextTimestamp(ColumnVector vector, int row, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            TimestampWritable result = previous == null || previous.getClass() != TimestampWritable.class ? new TimestampWritable() : (TimestampWritable)previous;
            TimestampColumnVector tcv = (TimestampColumnVector)vector;
            result.setInternal(tcv.time[row], tcv.nanos[row]);
            return result;
        }
        return null;
    }

    public StructType nextStruct(ColumnVector vector, int row, StructTypeInfo schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            ArrayList<TypeInfo> childrenTypes = schema.getAllStructFieldTypeInfos();
            StructType result = this.createStructObject(previous, childrenTypes);
            StructColumnVector struct = (StructColumnVector)vector;
            for (int f = 0; f < childrenTypes.size(); ++f) {
                this.setStructCol(result, f, this.nextValue(struct.fields[f], row, (TypeInfo)childrenTypes.get(f), this.getStructCol(result, f)));
            }
            return result;
        }
        return null;
    }

    private UnionType nextUnion(ColumnVector vector, int row, UnionTypeInfo schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            List<TypeInfo> childrenTypes = schema.getAllUnionObjectTypeInfos();
            UnionType result = this.createUnionObject(childrenTypes, previous);
            UnionColumnVector union = (UnionColumnVector)vector;
            byte tag = (byte)union.tags[row];
            this.setUnion(result, tag, this.nextValue(union.fields[tag], row, childrenTypes.get(tag), this.getUnionField(result)));
            return result;
        }
        return null;
    }

    private ArrayList<Object> nextList(ColumnVector vector, int row, ListTypeInfo schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            int idx;
            ArrayList result = previous == null || previous.getClass() != ArrayList.class ? new ArrayList() : (ArrayList)previous;
            ListColumnVector list = (ListColumnVector)vector;
            int length = (int)list.lengths[row];
            int offset = (int)list.offsets[row];
            result.ensureCapacity(length);
            int oldLength = result.size();
            TypeInfo childType = schema.getListElementTypeInfo();
            for (idx = 0; idx < length && idx < oldLength; ++idx) {
                result.set(idx, this.nextValue(list.child, offset + idx, childType, result.get(idx)));
            }
            if (length < oldLength) {
                for (int i = oldLength - 1; i >= length; --i) {
                    result.remove(i);
                }
            } else if (oldLength < length) {
                while (idx < length) {
                    result.add(this.nextValue(list.child, offset + idx, childType, null));
                    ++idx;
                }
            }
            return result;
        }
        return null;
    }

    private HashMap<Object, Object> nextMap(ColumnVector vector, int row, MapTypeInfo schema, Object previous) {
        if (vector.isRepeating) {
            row = 0;
        }
        if (vector.noNulls || !vector.isNull[row]) {
            HashMap result;
            MapColumnVector map = (MapColumnVector)vector;
            int length = (int)map.lengths[row];
            int offset = (int)map.offsets[row];
            TypeInfo keyType = schema.getMapKeyTypeInfo();
            TypeInfo valueType = schema.getMapValueTypeInfo();
            if (previous == null || previous.getClass() != HashMap.class) {
                result = new HashMap(length);
            } else {
                result = (HashMap)previous;
                result.clear();
            }
            for (int e = 0; e < length; ++e) {
                result.put(this.nextValue(map.keys, e + offset, keyType, null), this.nextValue(map.values, e + offset, valueType, null));
            }
            return result;
        }
        return null;
    }

    private Object nextValue(ColumnVector vector, int row, TypeInfo schema, Object previous) {
        switch (schema.getCategory()) {
            case STRUCT: {
                return this.nextStruct(vector, row, (StructTypeInfo)schema, previous);
            }
            case UNION: {
                return this.nextUnion(vector, row, (UnionTypeInfo)schema, previous);
            }
            case LIST: {
                return this.nextList(vector, row, (ListTypeInfo)schema, previous);
            }
            case MAP: {
                return this.nextMap(vector, row, (MapTypeInfo)schema, previous);
            }
            case PRIMITIVE: {
                PrimitiveTypeInfo pschema = (PrimitiveTypeInfo)schema;
                switch (pschema.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return BatchToRowReader.nextBoolean(vector, row, previous);
                    }
                    case BYTE: {
                        return BatchToRowReader.nextByte(vector, row, previous);
                    }
                    case SHORT: {
                        return BatchToRowReader.nextShort(vector, row, previous);
                    }
                    case INT: {
                        return BatchToRowReader.nextInt(vector, row, previous);
                    }
                    case LONG: {
                        return BatchToRowReader.nextLong(vector, row, previous);
                    }
                    case FLOAT: {
                        return BatchToRowReader.nextFloat(vector, row, previous);
                    }
                    case DOUBLE: {
                        return BatchToRowReader.nextDouble(vector, row, previous);
                    }
                    case STRING: {
                        return BatchToRowReader.nextString(vector, row, previous);
                    }
                    case CHAR: {
                        return BatchToRowReader.nextChar(vector, row, ((CharTypeInfo)pschema).getLength(), previous);
                    }
                    case VARCHAR: {
                        return BatchToRowReader.nextVarchar(vector, row, ((VarcharTypeInfo)pschema).getLength(), previous);
                    }
                    case BINARY: {
                        return BatchToRowReader.nextBinary(vector, row, previous);
                    }
                    case DECIMAL: {
                        return BatchToRowReader.nextDecimal(vector, row, previous);
                    }
                    case DATE: {
                        return BatchToRowReader.nextDate(vector, row, previous);
                    }
                    case TIMESTAMP: {
                        return BatchToRowReader.nextTimestamp(vector, row, previous);
                    }
                }
                throw new IllegalArgumentException("Unknown type " + schema);
            }
        }
        throw new IllegalArgumentException("Unknown type " + schema);
    }
}

