/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.hadoop.hive.common.Pool;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.ql.io.orc.encoded.CacheChunk;
import org.apache.hadoop.hive.ql.io.orc.encoded.Consumer;
import org.apache.hadoop.hive.ql.io.orc.encoded.EncodedReader;
import org.apache.hadoop.hive.ql.io.orc.encoded.IncompleteCb;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.orc.CompressionCodec;
import org.apache.orc.DataReader;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.apache.orc.impl.BufferChunk;
import org.apache.orc.impl.RecordReaderUtils;
import org.apache.orc.impl.StreamName;
import sun.misc.Cleaner;

class EncodedReaderImpl
implements EncodedReader {
    public static final Logger LOG = LoggerFactory.getLogger(EncodedReaderImpl.class);
    private static Field cleanerField;
    private static final Object POOLS_CREATION_LOCK;
    private static Pools POOLS;
    private static final DataCache.DiskRangeListFactory CC_FACTORY;
    private final Object fileKey;
    private final DataReader dataReader;
    private boolean isDataReaderOpen = false;
    private final CompressionCodec codec;
    private final int bufferSize;
    private final List<OrcProto.Type> types;
    private final long rowIndexStride;
    private final DataCache cacheWrapper;
    private boolean isTracingEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncodedReaderImpl(Object fileKey, List<OrcProto.Type> types, CompressionCodec codec, int bufferSize, long strideRate, DataCache cacheWrapper, DataReader dataReader, Reader.PoolFactory pf) throws IOException {
        this.fileKey = fileKey;
        this.codec = codec;
        this.types = types;
        this.bufferSize = bufferSize;
        this.rowIndexStride = strideRate;
        this.cacheWrapper = cacheWrapper;
        this.dataReader = dataReader;
        if (POOLS != null) {
            return;
        }
        if (pf == null) {
            pf = new NoopPoolFactory();
        }
        Pools pools = EncodedReaderImpl.createPools(pf);
        Object object = POOLS_CREATION_LOCK;
        synchronized (object) {
            if (POOLS != null) {
                return;
            }
            POOLS = pools;
        }
    }

    @Override
    public void readEncodedColumns(int stripeIx, StripeInformation stripe, OrcProto.RowIndex[] indexes, List<OrcProto.ColumnEncoding> encodings, List<OrcProto.Stream> streamList, boolean[] included, boolean[][] colRgs, Consumer<Reader.OrcEncodedColumnBatch> consumer) throws IOException {
        boolean hasFileId;
        ColumnReadContext ctx;
        long stripeOffset = stripe.getOffset();
        long offset = 0L;
        boolean[] hasNull = RecordReaderUtils.findPresentStreamsByColumn(streamList, this.types);
        if (this.isTracingEnabled) {
            LOG.trace("The following columns have PRESENT streams: " + EncodedReaderImpl.arrayToString(hasNull));
        }
        ColumnReadContext[] colCtxs = new ColumnReadContext[included.length];
        int colRgIx = -1;
        for (int i = 1; i < included.length; ++i) {
            if (!included[i]) continue;
            colCtxs[i] = new ColumnReadContext(i, encodings.get(i), indexes[i], ++colRgIx);
            if (!this.isTracingEnabled) continue;
            LOG.trace("Creating context: " + colCtxs[i].toString());
        }
        boolean isCompressed = this.codec != null;
        DiskRangeList.CreateHelper listToRead = new DiskRangeList.CreateHelper();
        boolean hasIndexOnlyCols = false;
        boolean[] includedRgs = null;
        for (OrcProto.Stream stream : streamList) {
            long length = stream.getLength();
            int colIx = stream.getColumn();
            OrcProto.Stream.Kind streamKind = stream.getKind();
            if (!included[colIx] || StreamName.getArea(streamKind) != StreamName.Area.DATA) {
                boolean bl = hasIndexOnlyCols = hasIndexOnlyCols || included[colIx];
                if (this.isTracingEnabled) {
                    LOG.trace("Skipping stream for column " + colIx + ": " + streamKind + " at " + offset + ", " + length);
                }
                offset += length;
                continue;
            }
            ctx = colCtxs[colIx];
            assert (ctx != null);
            includedRgs = colRgs[ctx.includedIx];
            int indexIx = RecordReaderUtils.getIndexPosition(ctx.encoding.getKind(), this.types.get(colIx).getKind(), streamKind, isCompressed, hasNull[colIx]);
            ctx.addStream(offset, stream, indexIx);
            if (this.isTracingEnabled) {
                LOG.trace("Adding stream for column " + colIx + ": " + streamKind + " at " + offset + ", " + length + ", index position " + indexIx);
            }
            if (includedRgs == null || RecordReaderUtils.isDictionary(streamKind, encodings.get(colIx))) {
                RecordReaderUtils.addEntireStreamToRanges(offset, length, listToRead, true);
                if (this.isTracingEnabled) {
                    LOG.trace("Will read whole stream " + streamKind + "; added to " + listToRead.getTail());
                }
            } else {
                RecordReaderUtils.addRgFilteredStreamToRanges(stream, includedRgs, this.codec != null, indexes[colIx], encodings.get(colIx), this.types.get(colIx), this.bufferSize, hasNull[colIx], offset, length, listToRead, true);
            }
            offset += length;
        }
        boolean bl = hasFileId = this.fileKey != null;
        if (listToRead.get() == null) {
            if (hasIndexOnlyCols && includedRgs == null) {
                Reader.OrcEncodedColumnBatch ecb = EncodedReaderImpl.POOLS.ecbPool.take();
                ecb.init(this.fileKey, stripeIx, -1, included.length);
                consumer.consumeData(ecb);
            } else {
                LOG.warn("Nothing to read for stripe [" + stripe + "]");
            }
            return;
        }
        DiskRangeList.MutateHelper toRead = new DiskRangeList.MutateHelper(listToRead.get());
        if (LOG.isInfoEnabled()) {
            LOG.info("Resulting disk ranges to read (file " + this.fileKey + "): " + RecordReaderUtils.stringifyDiskRanges(toRead.next));
        }
        DataCache.BooleanRef isAllInCache = new DataCache.BooleanRef();
        if (hasFileId) {
            this.cacheWrapper.getFileData(this.fileKey, toRead.next, stripeOffset, CC_FACTORY, isAllInCache);
            if (LOG.isInfoEnabled()) {
                LOG.info("Disk ranges after cache (found everything " + isAllInCache.value + "; file " + this.fileKey + ", base offset " + stripeOffset + "): " + RecordReaderUtils.stringifyDiskRanges(toRead.next));
            }
        }
        IdentityHashMap<ByteBuffer, Boolean> toRelease = null;
        if (!isAllInCache.value) {
            if (!this.isDataReaderOpen) {
                this.dataReader.open();
                this.isDataReaderOpen = true;
            }
            this.dataReader.readFileData(toRead.next, stripeOffset, this.cacheWrapper.getAllocator().isDirectAlloc());
            toRelease = new IdentityHashMap<ByteBuffer, Boolean>();
            DiskRangeList drl = toRead.next;
            while (drl != null) {
                if (drl instanceof BufferChunk) {
                    toRelease.put(drl.getData(), true);
                }
                drl = drl.next;
            }
        }
        DiskRangeList iter = toRead.next;
        if (this.codec == null) {
            for (int colIx = 0; colIx < colCtxs.length; ++colIx) {
                ctx = colCtxs[colIx];
                if (ctx == null) continue;
                for (int streamIx = 0; streamIx < ctx.streamCount; ++streamIx) {
                    StreamContext sctx = ctx.streams[streamIx];
                    DiskRangeList newIter = this.preReadUncompressedStream(stripeOffset, iter, sctx.offset, sctx.offset + sctx.length);
                    if (newIter == null) continue;
                    iter = newIter;
                }
            }
            if (toRelease != null) {
                this.releaseBuffers(toRelease.keySet(), true);
                toRelease = null;
            }
            if (this.isTracingEnabled) {
                LOG.trace("Disk ranges after pre-read (file " + this.fileKey + ", base offset " + stripeOffset + "): " + RecordReaderUtils.stringifyDiskRanges(toRead.next));
            }
            iter = toRead.next;
        }
        int rgCount = (int)Math.ceil((double)stripe.getNumberOfRows() / (double)this.rowIndexStride);
        for (int rgIx = 0; rgIx < rgCount; ++rgIx) {
            boolean isLastRg = rgIx == rgCount - 1;
            Reader.OrcEncodedColumnBatch ecb = EncodedReaderImpl.POOLS.ecbPool.take();
            ecb.init(this.fileKey, stripeIx, rgIx, included.length);
            boolean isRGSelected = true;
            for (int colIx = 0; colIx < colCtxs.length; ++colIx) {
                ColumnReadContext ctx2 = colCtxs[colIx];
                if (ctx2 == null) continue;
                if (this.isTracingEnabled) {
                    LOG.trace("ctx: {} rgIx: {} isLastRg: {} rgCount: {}", ctx2, rgIx, isLastRg, rgCount);
                }
                if (colRgs[ctx2.includedIx] != null && !colRgs[ctx2.includedIx][rgIx]) {
                    isRGSelected = false;
                    if (!this.isTracingEnabled) continue;
                    LOG.trace("colIxMod: {} rgIx: {} colRgs[{}]: {} colRgs[{}][{}]: {}", ctx2.includedIx, rgIx, ctx2.includedIx, Arrays.toString(colRgs[ctx2.includedIx]), ctx2.includedIx, rgIx, colRgs[ctx2.includedIx][rgIx]);
                    continue;
                }
                OrcProto.RowIndexEntry index = ctx2.rowIndex.getEntry(rgIx);
                OrcProto.RowIndexEntry nextIndex = isLastRg ? null : ctx2.rowIndex.getEntry(rgIx + 1);
                ecb.initOrcColumn(ctx2.colIx);
                for (int streamIx = 0; streamIx < ctx2.streamCount; ++streamIx) {
                    StreamContext sctx = ctx2.streams[streamIx];
                    EncodedColumnBatch.ColumnStreamData cb = null;
                    try {
                        if (RecordReaderUtils.isDictionary(sctx.kind, ctx2.encoding)) {
                            if (this.isTracingEnabled) {
                                LOG.trace("Getting stripe-level stream [" + sctx.kind + ", " + ctx2.encoding + "] for" + " column " + ctx2.colIx + " RG " + rgIx + " at " + sctx.offset + ", " + sctx.length);
                            }
                            if (sctx.stripeLevelStream == null) {
                                sctx.stripeLevelStream = EncodedReaderImpl.POOLS.csdPool.take();
                                sctx.stripeLevelStream.incRef();
                                long unlockUntilCOffset = sctx.offset + sctx.length;
                                DiskRangeList lastCached = this.readEncodedStream(stripeOffset, iter, sctx.offset, sctx.offset + sctx.length, sctx.stripeLevelStream, unlockUntilCOffset, sctx.offset, toRelease);
                                if (lastCached != null) {
                                    iter = lastCached;
                                }
                            }
                            sctx.stripeLevelStream.incRef();
                            cb = sctx.stripeLevelStream;
                        } else {
                            long cOffset = sctx.offset + index.getPositions(sctx.streamIndexOffset);
                            long nextCOffsetRel = isLastRg ? sctx.length : nextIndex.getPositions(sctx.streamIndexOffset);
                            long endCOffset = sctx.offset + RecordReaderUtils.estimateRgEndOffset(isCompressed, isLastRg, nextCOffsetRel, sctx.length, this.bufferSize);
                            long unlockUntilCOffset = sctx.offset + nextCOffsetRel;
                            boolean isStartOfStream = sctx.bufferIter == null;
                            DiskRangeList lastCached = this.readEncodedStream(stripeOffset, isStartOfStream ? iter : sctx.bufferIter, cOffset, endCOffset, cb = this.createRgColumnStreamData(rgIx, isLastRg, ctx2.colIx, sctx, cOffset, endCOffset, isCompressed), unlockUntilCOffset, sctx.offset, toRelease);
                            if (lastCached != null) {
                                sctx.bufferIter = iter = lastCached;
                            }
                        }
                        ecb.setStreamData(ctx2.colIx, sctx.kind.getNumber(), cb);
                        continue;
                    }
                    catch (Exception ex) {
                        DiskRangeList drl = toRead == null ? null : toRead.next;
                        LOG.error("Error getting stream [" + sctx.kind + ", " + ctx2.encoding + "] for" + " column " + ctx2.colIx + " RG " + rgIx + " at " + sctx.offset + ", " + sctx.length + "; toRead " + RecordReaderUtils.stringifyDiskRanges(drl), ex);
                        throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
                    }
                }
            }
            if (!isRGSelected) continue;
            consumer.consumeData(ecb);
        }
        if (this.isTracingEnabled) {
            LOG.trace("Disk ranges after preparing all the data " + RecordReaderUtils.stringifyDiskRanges(toRead.next));
        }
        for (int colIx = 0; colIx < colCtxs.length; ++colIx) {
            ColumnReadContext ctx3 = colCtxs[colIx];
            if (ctx3 == null) continue;
            for (int streamIx = 0; streamIx < ctx3.streamCount; ++streamIx) {
                StreamContext sctx = ctx3.streams[streamIx];
                if (sctx == null || sctx.stripeLevelStream == null || 0 != sctx.stripeLevelStream.decRef()) continue;
                for (MemoryBuffer buf : sctx.stripeLevelStream.getCacheBuffers()) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Unlocking {} at the end of processing", (Object)buf);
                    }
                    this.cacheWrapper.releaseBuffer(buf);
                }
            }
        }
        this.releaseInitialRefcounts(toRead.next);
        if (toRelease != null) {
            this.releaseBuffers(toRelease.keySet(), true);
        }
        EncodedReaderImpl.releaseCacheChunksIntoObjectPool(toRead.next);
    }

    private static String arrayToString(boolean[] a) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < a.length; ++i) {
            b.append(a[i] ? "1" : "0");
        }
        b.append(']');
        return b.toString();
    }

    private EncodedColumnBatch.ColumnStreamData createRgColumnStreamData(int rgIx, boolean isLastRg, int colIx, StreamContext sctx, long cOffset, long endCOffset, boolean isCompressed) {
        EncodedColumnBatch.ColumnStreamData cb = EncodedReaderImpl.POOLS.csdPool.take();
        cb.incRef();
        if (this.isTracingEnabled) {
            LOG.trace("Getting data for column " + colIx + " " + (isLastRg ? "last " : "") + "RG " + rgIx + " stream " + sctx.kind + " at " + sctx.offset + ", " + sctx.length + " index position " + sctx.streamIndexOffset + ": " + (isCompressed ? "" : "un") + "compressed [" + cOffset + ", " + endCOffset + ")");
        }
        return cb;
    }

    private void releaseInitialRefcounts(DiskRangeList current) {
        while (current != null) {
            CacheChunk cc;
            DiskRangeList toFree = current;
            current = current.next;
            if (!(toFree instanceof CacheChunk) || (cc = (CacheChunk)toFree).getBuffer() == null) continue;
            MemoryBuffer buffer = cc.getBuffer();
            this.cacheWrapper.releaseBuffer(buffer);
            cc.setBuffer(null);
        }
    }

    @Override
    public void setTracing(boolean isEnabled) {
        this.isTracingEnabled = isEnabled;
    }

    @Override
    public void close() throws IOException {
        this.dataReader.close();
    }

    public DiskRangeList readEncodedStream(long baseOffset, DiskRangeList start, long cOffset, long endCOffset, EncodedColumnBatch.ColumnStreamData csd, long unlockUntilCOffset, long streamOffset, IdentityHashMap<ByteBuffer, Boolean> toRelease) throws IOException {
        if (csd.getCacheBuffers() == null) {
            csd.setCacheBuffers(new ArrayList<MemoryBuffer>());
        } else {
            csd.getCacheBuffers().clear();
        }
        if (cOffset == endCOffset) {
            return null;
        }
        boolean isCompressed = this.codec != null;
        ArrayList<ProcCacheChunk> toDecompress = null;
        ArrayList<IncompleteCb> badEstimates = null;
        ArrayList<ByteBuffer> toReleaseCopies = null;
        if (isCompressed) {
            toReleaseCopies = new ArrayList<ByteBuffer>();
            toDecompress = new ArrayList<ProcCacheChunk>();
            badEstimates = new ArrayList<IncompleteCb>();
        }
        DiskRangeList current = EncodedReaderImpl.findExactPosition(start, cOffset);
        if (this.isTracingEnabled) {
            LOG.trace("Starting read for [" + cOffset + "," + endCOffset + ") at " + current);
        }
        CacheChunk lastUncompressed = null;
        try {
            lastUncompressed = isCompressed ? this.prepareRangesForCompressedRead(cOffset, endCOffset, streamOffset, unlockUntilCOffset, current, csd, toRelease, toReleaseCopies, toDecompress, badEstimates) : this.prepareRangesForUncompressedRead(cOffset, endCOffset, streamOffset, unlockUntilCOffset, current, csd);
        }
        catch (Exception ex) {
            LOG.error("Failed " + (isCompressed ? "" : "un") + "compressed read; cOffset " + cOffset + ", endCOffset " + endCOffset + ", streamOffset " + streamOffset + ", unlockUntilCOffset " + unlockUntilCOffset + "; ranges passed in " + RecordReaderUtils.stringifyDiskRanges(start) + "; ranges passed to prepare " + RecordReaderUtils.stringifyDiskRanges(current));
            throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
        }
        if (badEstimates != null && !badEstimates.isEmpty()) {
            DiskRange[] cacheKeys = badEstimates.toArray(new DiskRange[badEstimates.size()]);
            long[] result = this.cacheWrapper.putFileData(this.fileKey, cacheKeys, null, baseOffset);
            assert (result == null);
        }
        if (toDecompress == null || toDecompress.isEmpty()) {
            this.releaseBuffers(toReleaseCopies, false);
            return lastUncompressed;
        }
        MemoryBuffer[] targetBuffers = new MemoryBuffer[toDecompress.size()];
        DiskRange[] cacheKeys = new DiskRange[toDecompress.size()];
        int ix = 0;
        for (ProcCacheChunk chunk : toDecompress) {
            cacheKeys[ix] = chunk;
            targetBuffers[ix] = chunk.getBuffer();
            ++ix;
        }
        this.cacheWrapper.getAllocator().allocateMultiple(targetBuffers, this.bufferSize);
        for (ProcCacheChunk chunk : toDecompress) {
            ByteBuffer dest = chunk.getBuffer().getByteBufferRaw();
            if (chunk.isOriginalDataCompressed) {
                EncodedReaderImpl.decompressChunk(chunk.originalData, this.codec, dest);
            } else {
                EncodedReaderImpl.copyUncompressedChunk(chunk.originalData, dest);
            }
            chunk.originalData = null;
            if (this.isTracingEnabled) {
                LOG.trace("Locking " + chunk.getBuffer() + " due to reuse (after decompression)");
            }
            this.cacheWrapper.reuseBuffer(chunk.getBuffer());
        }
        this.releaseBuffers(toReleaseCopies, false);
        if (this.fileKey != null) {
            long[] collisionMask = this.cacheWrapper.putFileData(this.fileKey, cacheKeys, targetBuffers, baseOffset);
            this.processCacheCollisions(collisionMask, toDecompress, targetBuffers, csd.getCacheBuffers());
        }
        for (ProcCacheChunk chunk : toDecompress) {
            this.ponderReleaseInitialRefcount(unlockUntilCOffset, streamOffset, chunk);
        }
        return lastUncompressed;
    }

    private CacheChunk prepareRangesForCompressedRead(long cOffset, long endCOffset, long streamOffset, long unlockUntilCOffset, DiskRangeList current, EncodedColumnBatch.ColumnStreamData columnStreamData, IdentityHashMap<ByteBuffer, Boolean> toRelease, List<ByteBuffer> toReleaseCopies, List<ProcCacheChunk> toDecompress, List<IncompleteCb> badEstimates) throws IOException {
        if (cOffset > current.getOffset()) {
            current = current.split((long)cOffset).next;
        }
        long currentOffset = cOffset;
        CacheChunk lastUncompressed = null;
        while (true) {
            DiskRangeList next = null;
            if (current instanceof CacheChunk) {
                CacheChunk cc = (CacheChunk)current;
                if (this.isTracingEnabled) {
                    LOG.trace("Locking " + cc.getBuffer() + " due to reuse");
                }
                this.cacheWrapper.reuseBuffer(cc.getBuffer());
                columnStreamData.getCacheBuffers().add(cc.getBuffer());
                currentOffset = cc.getEnd();
                if (this.isTracingEnabled) {
                    LOG.trace("Adding an already-uncompressed buffer " + cc.getBuffer());
                }
                this.ponderReleaseInitialRefcount(unlockUntilCOffset, streamOffset, cc);
                lastUncompressed = cc;
                next = current.next;
                if (next != null && endCOffset >= 0L && currentOffset < endCOffset && next.getOffset() >= endCOffset) {
                    throw new IOException("Expected data at " + currentOffset + " (reading until " + endCOffset + "), but the next buffer starts at " + next.getOffset());
                }
            } else if (current instanceof IncompleteCb) {
                if (this.isTracingEnabled) {
                    LOG.trace("Cannot read " + current);
                }
                next = null;
                currentOffset = -1L;
            } else {
                if (!(current instanceof BufferChunk)) {
                    String msg = "Found an unexpected " + current.getClass().getSimpleName() + ": " + current + " while looking at " + currentOffset;
                    LOG.error(msg);
                    throw new RuntimeException(msg);
                }
                BufferChunk bc = (BufferChunk)current;
                ProcCacheChunk newCached = this.addOneCompressionBuffer(bc, columnStreamData.getCacheBuffers(), toDecompress, toRelease, toReleaseCopies, badEstimates);
                lastUncompressed = newCached == null ? lastUncompressed : newCached;
                next = newCached != null ? newCached.next : null;
                long l = currentOffset = next != null ? next.getOffset() : -1L;
            }
            if (next == null || endCOffset >= 0L && currentOffset >= endCOffset) break;
            current = next;
        }
        return lastUncompressed;
    }

    private CacheChunk prepareRangesForUncompressedRead(long cOffset, long endCOffset, long streamOffset, long unlockUntilCOffset, DiskRangeList current, EncodedColumnBatch.ColumnStreamData columnStreamData) throws IOException {
        long currentOffset = cOffset;
        CacheChunk lastUncompressed = null;
        boolean isFirst = true;
        while (true) {
            DiskRangeList next = null;
            assert (current instanceof CacheChunk);
            lastUncompressed = (CacheChunk)current;
            if (this.isTracingEnabled) {
                LOG.trace("Locking " + lastUncompressed.getBuffer() + " due to reuse");
            }
            this.cacheWrapper.reuseBuffer(lastUncompressed.getBuffer());
            if (isFirst) {
                columnStreamData.setIndexBaseOffset((int)(lastUncompressed.getOffset() - streamOffset));
                isFirst = false;
            }
            columnStreamData.getCacheBuffers().add(lastUncompressed.getBuffer());
            currentOffset = lastUncompressed.getEnd();
            if (this.isTracingEnabled) {
                LOG.trace("Adding an uncompressed buffer " + lastUncompressed.getBuffer());
            }
            this.ponderReleaseInitialRefcount(unlockUntilCOffset, streamOffset, lastUncompressed);
            next = current.next;
            if (next == null || endCOffset >= 0L && currentOffset >= endCOffset) break;
            current = next;
        }
        return lastUncompressed;
    }

    private DiskRangeList preReadUncompressedStream(long baseOffset, DiskRangeList start, long streamOffset, long streamEnd) throws IOException {
        if (streamOffset == streamEnd) {
            return null;
        }
        ArrayList<UncompressedCacheChunk> toCache = null;
        DiskRangeList current = EncodedReaderImpl.findIntersectingPosition(start, streamOffset, streamEnd);
        if (this.isTracingEnabled) {
            LOG.trace("Starting pre-read for [" + streamOffset + "," + streamEnd + ") at " + current);
        }
        if (streamOffset > current.getOffset()) {
            current = current.split((long)streamOffset).next;
        }
        long streamLen = streamEnd - streamOffset;
        int partSize = this.determineUncompressedPartSize();
        int partCount = (int)(streamLen / (long)partSize) + (streamLen % (long)partSize != 0L ? 1 : 0);
        CacheChunk lastUncompressed = null;
        MemoryBuffer[] singleAlloc = new MemoryBuffer[1];
        for (int i = 0; i < partCount; ++i) {
            long partOffset = streamOffset + (long)(i * partSize);
            long partEnd = Math.min(partOffset + (long)partSize, streamEnd);
            long hasEntirePartTo = partOffset;
            if (current == null) break;
            assert (partOffset <= current.getOffset());
            if (partOffset == current.getOffset() && current instanceof CacheChunk) {
                assert (current.getOffset() == partOffset && current.getEnd() == partEnd);
                lastUncompressed = (CacheChunk)current;
                current = current.next;
                continue;
            }
            if (current.getOffset() >= partEnd) continue;
            UncompressedCacheChunk candidateCached = null;
            DiskRangeList next = current;
            while (true) {
                boolean noMoreDataForPart;
                boolean bl = noMoreDataForPart = next == null || next.getOffset() >= partEnd;
                if (noMoreDataForPart && hasEntirePartTo < partEnd && candidateCached != null) {
                    lastUncompressed = EncodedReaderImpl.copyAndReplaceCandidateToNonCached(candidateCached, partOffset, hasEntirePartTo, this.cacheWrapper, singleAlloc);
                    candidateCached = null;
                }
                current = next;
                if (noMoreDataForPart) break;
                if (current.getEnd() > partEnd) {
                    current = current.split(partEnd);
                }
                if (this.isTracingEnabled) {
                    LOG.trace("Processing uncompressed file data at [" + current.getOffset() + ", " + current.getEnd() + ")");
                }
                BufferChunk curBc = (BufferChunk)current;
                long hadEntirePartTo = hasEntirePartTo;
                long l = hasEntirePartTo = hasEntirePartTo == current.getOffset() ? current.getEnd() : -1L;
                if (hasEntirePartTo == -1L) {
                    if (candidateCached != null) {
                        assert (hadEntirePartTo != -1L);
                        EncodedReaderImpl.copyAndReplaceCandidateToNonCached(candidateCached, partOffset, hadEntirePartTo, this.cacheWrapper, singleAlloc);
                        candidateCached = null;
                    }
                    lastUncompressed = EncodedReaderImpl.copyAndReplaceUncompressedToNonCached(curBc, this.cacheWrapper, singleAlloc);
                    next = lastUncompressed.next;
                    continue;
                }
                if (candidateCached == null) {
                    candidateCached = new UncompressedCacheChunk(curBc);
                } else {
                    candidateCached.addChunk(curBc);
                }
                next = current.next;
            }
            if (candidateCached == null) continue;
            if (toCache == null) {
                toCache = new ArrayList<UncompressedCacheChunk>(partCount - i);
            }
            toCache.add(candidateCached);
        }
        if (toCache == null) {
            return lastUncompressed;
        }
        MemoryBuffer[] targetBuffers = toCache.size() == 1 ? singleAlloc : new MemoryBuffer[toCache.size()];
        targetBuffers[0] = null;
        DiskRange[] cacheKeys = new DiskRange[toCache.size()];
        int ix = 0;
        for (UncompressedCacheChunk chunk : toCache) {
            cacheKeys[ix] = chunk;
            ++ix;
        }
        this.cacheWrapper.getAllocator().allocateMultiple(targetBuffers, (int)(partCount == 1 ? streamLen : (long)partSize));
        ix = 0;
        for (UncompressedCacheChunk candidateCached : toCache) {
            candidateCached.setBuffer(targetBuffers[ix]);
            ByteBuffer dest = candidateCached.getBuffer().getByteBufferRaw();
            EncodedReaderImpl.copyAndReplaceUncompressedChunks(candidateCached, dest, candidateCached);
            candidateCached.clear();
            lastUncompressed = candidateCached;
            ++ix;
        }
        if (this.fileKey != null) {
            long[] collisionMask = this.cacheWrapper.putFileData(this.fileKey, cacheKeys, targetBuffers, baseOffset);
            this.processCacheCollisions(collisionMask, toCache, targetBuffers, null);
        }
        return lastUncompressed;
    }

    private int determineUncompressedPartSize() {
        long orcCbSizeDefault = ((Number)OrcConf.BUFFER_SIZE.getDefaultValue()).longValue();
        int maxAllocSize = this.cacheWrapper.getAllocator().getMaxAllocation();
        return (int)Math.min((long)maxAllocSize, orcCbSizeDefault);
    }

    private static void copyUncompressedChunk(ByteBuffer src, ByteBuffer dest) {
        int startPos = dest.position();
        int startLim = dest.limit();
        dest.put(src);
        int newPos = dest.position();
        if (newPos > startLim) {
            throw new AssertionError((Object)("After copying, buffer [" + startPos + ", " + startLim + ") became [" + newPos + ", " + dest.limit() + ")"));
        }
        dest.position(startPos);
        dest.limit(newPos);
    }

    private static CacheChunk copyAndReplaceCandidateToNonCached(UncompressedCacheChunk candidateCached, long partOffset, long candidateEnd, DataCache cacheWrapper, MemoryBuffer[] singleAlloc) {
        singleAlloc[0] = null;
        cacheWrapper.getAllocator().allocateMultiple(singleAlloc, (int)(candidateEnd - partOffset));
        MemoryBuffer buffer = singleAlloc[0];
        cacheWrapper.reuseBuffer(buffer);
        ByteBuffer dest = buffer.getByteBufferRaw();
        CacheChunk tcc = EncodedReaderImpl.POOLS.tccPool.take();
        tcc.init(buffer, partOffset, candidateEnd);
        EncodedReaderImpl.copyAndReplaceUncompressedChunks(candidateCached, dest, tcc);
        return tcc;
    }

    private static CacheChunk copyAndReplaceUncompressedToNonCached(BufferChunk bc, DataCache cacheWrapper, MemoryBuffer[] singleAlloc) {
        singleAlloc[0] = null;
        cacheWrapper.getAllocator().allocateMultiple(singleAlloc, bc.getLength());
        MemoryBuffer buffer = singleAlloc[0];
        cacheWrapper.reuseBuffer(buffer);
        ByteBuffer dest = buffer.getByteBufferRaw();
        CacheChunk tcc = EncodedReaderImpl.POOLS.tccPool.take();
        tcc.init(buffer, bc.getOffset(), bc.getEnd());
        EncodedReaderImpl.copyUncompressedChunk(bc.getChunk(), dest);
        bc.replaceSelfWith(tcc);
        return tcc;
    }

    private static void copyAndReplaceUncompressedChunks(UncompressedCacheChunk candidateCached, ByteBuffer dest, CacheChunk tcc) {
        int startPos = dest.position();
        int startLim = dest.limit();
        DiskRangeList next = null;
        for (int i = 0; i < candidateCached.getCount(); ++i) {
            BufferChunk chunk = i == 0 ? candidateCached.getChunk() : (BufferChunk)next;
            dest.put(chunk.getData());
            next = chunk.next;
            if (i == 0) {
                chunk.replaceSelfWith(tcc);
                continue;
            }
            chunk.removeSelf();
        }
        int newPos = dest.position();
        if (newPos > startLim) {
            throw new AssertionError((Object)("After copying, buffer [" + startPos + ", " + startLim + ") became [" + newPos + ", " + dest.limit() + ")"));
        }
        dest.position(startPos);
        dest.limit(newPos);
    }

    private static void decompressChunk(ByteBuffer src, CompressionCodec codec, ByteBuffer dest) throws IOException {
        int startPos = dest.position();
        int startLim = dest.limit();
        codec.decompress(src, dest);
        dest.position(startPos);
        int newLim = dest.limit();
        if (newLim > startLim) {
            throw new AssertionError((Object)("After codec, buffer [" + startPos + ", " + startLim + ") became [" + dest.position() + ", " + newLim + ")"));
        }
    }

    public static void releaseCacheChunksIntoObjectPool(DiskRangeList current) {
        while (current != null) {
            if (current instanceof ProcCacheChunk) {
                EncodedReaderImpl.POOLS.pccPool.offer((ProcCacheChunk)current);
            } else if (current instanceof CacheChunk) {
                EncodedReaderImpl.POOLS.tccPool.offer((CacheChunk)current);
            }
            current = current.next;
        }
    }

    private void ponderReleaseInitialRefcount(long unlockUntilCOffset, long streamStartOffset, CacheChunk cc) {
        if (cc.getEnd() > unlockUntilCOffset) {
            return;
        }
        assert (cc.getBuffer() != null);
        try {
            this.releaseInitialRefcount(cc, false);
        }
        catch (AssertionError e) {
            LOG.error("BUG: releasing initial refcount; stream start " + streamStartOffset + ", " + "unlocking until " + unlockUntilCOffset + " from [" + cc + "]: " + ((Throwable)((Object)e)).getMessage());
            throw e;
        }
        DiskRangeList prev = cc.prev;
        while (prev != null && prev.getEnd() > streamStartOffset && prev.getClass() == CacheChunk.class) {
            CacheChunk prevCc = (CacheChunk)prev;
            if (prevCc.buffer == null) break;
            try {
                this.releaseInitialRefcount(prevCc, true);
            }
            catch (AssertionError e) {
                LOG.error("BUG: releasing initial refcount; stream start " + streamStartOffset + ", " + "unlocking until " + unlockUntilCOffset + " from [" + cc + "] and backtracked to [" + prevCc + "]: " + ((Throwable)((Object)e)).getMessage());
                throw e;
            }
            prev = prev.prev;
        }
    }

    private void releaseInitialRefcount(CacheChunk cc, boolean isBacktracking) {
        if (this.isTracingEnabled) {
            LOG.trace("Unlocking " + cc.getBuffer() + " for the fetching thread" + (isBacktracking ? "; backtracking" : ""));
        }
        this.cacheWrapper.releaseBuffer(cc.getBuffer());
        cc.setBuffer(null);
    }

    private void processCacheCollisions(long[] collisionMask, List<? extends CacheChunk> toDecompress, MemoryBuffer[] targetBuffers, List<MemoryBuffer> cacheBuffers) {
        if (collisionMask == null) {
            return;
        }
        assert (collisionMask.length >= toDecompress.size() >>> 6);
        long maskVal = -1L;
        for (int i = 0; i < toDecompress.size(); ++i) {
            if ((i & 0x3F) == 0) {
                maskVal = collisionMask[i >>> 6];
            }
            if ((maskVal & 1L) == 1L) {
                CacheChunk replacedChunk = toDecompress.get(i);
                MemoryBuffer replacementBuffer = targetBuffers[i];
                if (this.isTracingEnabled) {
                    LOG.trace("Discarding data due to cache collision: " + replacedChunk.getBuffer() + " replaced with " + replacementBuffer);
                }
                assert (replacedChunk.getBuffer() != replacementBuffer) : i + " was not replaced in the results " + "even though mask is [" + Long.toBinaryString(maskVal) + "]";
                replacedChunk.handleCacheCollision(this.cacheWrapper, replacementBuffer, cacheBuffers);
            }
            maskVal >>= 1;
        }
    }

    private static DiskRangeList findExactPosition(DiskRangeList ranges, long offset) {
        if (offset < 0L) {
            return ranges;
        }
        ranges = EncodedReaderImpl.findUpperBound(ranges, offset);
        if (offset < (ranges = EncodedReaderImpl.findLowerBound(ranges, offset)).getOffset() || offset >= ranges.getEnd()) {
            EncodedReaderImpl.throwRangesError(ranges, offset, offset);
        }
        return ranges;
    }

    private static DiskRangeList findIntersectingPosition(DiskRangeList ranges, long offset, long end) {
        if (offset < 0L) {
            return ranges;
        }
        ranges = EncodedReaderImpl.findUpperBound(ranges, offset);
        ranges = EncodedReaderImpl.findLowerBound(ranges, end);
        while (ranges.prev != null && ranges.prev.getEnd() > offset) {
            if (ranges.prev.getEnd() > ranges.getOffset()) {
                EncodedReaderImpl.throwRangesError(ranges, offset, end);
            }
            ranges = ranges.prev;
        }
        return ranges;
    }

    public static DiskRangeList findLowerBound(DiskRangeList ranges, long end) {
        while (ranges.getOffset() > end) {
            if (ranges.prev.getEnd() > ranges.getOffset()) {
                EncodedReaderImpl.throwRangesError(ranges, end, end);
            }
            ranges = ranges.prev;
        }
        return ranges;
    }

    public static DiskRangeList findUpperBound(DiskRangeList ranges, long offset) {
        while (ranges.getEnd() <= offset) {
            if (ranges.next.getOffset() < ranges.getEnd()) {
                EncodedReaderImpl.throwRangesError(ranges, offset, offset);
            }
            ranges = ranges.next;
        }
        return ranges;
    }

    private static void throwRangesError(DiskRangeList ranges, long offset, long end) {
        IdentityHashMap<DiskRangeList, Boolean> seen = new IdentityHashMap<DiskRangeList, Boolean>();
        seen.put(ranges, true);
        StringBuilder errors = new StringBuilder();
        while (ranges.prev != null) {
            if (ranges.prev.next != ranges) {
                errors.append("inconsistent list going back: [").append(ranges).append("].prev = [").append(ranges.prev).append("]; prev.next = [").append(ranges.prev.next).append("]; ");
                break;
            }
            if (seen.containsKey(ranges.prev)) {
                errors.append("loop: [").append(ranges).append("].prev = [").append(ranges.prev).append("]; ");
                break;
            }
            ranges = ranges.prev;
            seen.put(ranges, true);
        }
        seen.clear();
        seen.put(ranges, true);
        StringBuilder sb = new StringBuilder("Incorrect ranges detected while looking for ");
        if (offset == end) {
            sb.append(offset);
        } else {
            sb.append("[").append(offset).append(", ").append(end).append(")");
        }
        sb.append(": [").append(ranges).append("], ");
        while (ranges.next != null) {
            if (ranges.next.prev != ranges) {
                errors.append("inconsistent list going forward: [").append(ranges).append("].next.prev = [").append(ranges.next.prev).append("]; ");
            }
            if (seen.containsKey(ranges.next)) {
                errors.append("loop: [").append(ranges).append("].next = [").append(ranges.next).append("]; ");
                break;
            }
            ranges = ranges.next;
            sb.append("[").append(ranges).append("], ");
            seen.put(ranges, true);
        }
        sb.append("; ").append((CharSequence)errors);
        String error = sb.toString();
        LOG.error(error);
        throw new RuntimeException(error);
    }

    private ProcCacheChunk addOneCompressionBuffer(BufferChunk current, List<MemoryBuffer> cacheBuffers, List<ProcCacheChunk> toDecompress, IdentityHashMap<ByteBuffer, Boolean> toRelease, List<ByteBuffer> toReleaseCopies, List<IncompleteCb> badEstimates) throws IOException {
        DiskRangeList tmp;
        boolean isUncompressed;
        ByteBuffer slice = null;
        ByteBuffer compressed = current.getChunk();
        long cbStartOffset = current.getOffset();
        int b0 = compressed.get() & 0xFF;
        int b1 = compressed.get() & 0xFF;
        int b2 = compressed.get() & 0xFF;
        int chunkLength = b2 << 15 | b1 << 7 | b0 >> 1;
        if (chunkLength > this.bufferSize) {
            throw new IllegalArgumentException("Buffer size too small. size = " + this.bufferSize + " needed = " + chunkLength);
        }
        int consumedLength = chunkLength + 3;
        long cbEndOffset = cbStartOffset + (long)consumedLength;
        boolean bl = isUncompressed = (b0 & 1) == 1;
        if (this.isTracingEnabled) {
            LOG.trace("Found CB at " + cbStartOffset + ", chunk length " + chunkLength + ", total " + consumedLength + ", " + (isUncompressed ? "not " : "") + "compressed");
        }
        if (compressed.remaining() >= chunkLength) {
            slice = compressed.slice();
            slice.limit(chunkLength);
            return this.addOneCompressionBlockByteBuffer(slice, isUncompressed, cbStartOffset, cbEndOffset, chunkLength, current, toDecompress, cacheBuffers);
        }
        if (current.getEnd() < cbEndOffset && !current.hasContiguousNext()) {
            badEstimates.add(this.addIncompleteCompressionBuffer(cbStartOffset, current, 0));
            return null;
        }
        ByteBuffer copy = EncodedReaderImpl.allocateBuffer(chunkLength, compressed.isDirect());
        toReleaseCopies.add(copy);
        int remaining = chunkLength - compressed.remaining();
        int originalPos = compressed.position();
        copy.put(compressed);
        if (this.isTracingEnabled) {
            LOG.trace("Removing partial CB " + current + " from ranges after copying its contents");
        }
        DiskRangeList next = current.next;
        current.removeSelf();
        if (originalPos == 0 && toRelease.remove(compressed).booleanValue()) {
            this.releaseBuffer(compressed, true);
        }
        int extraChunkCount = 0;
        while (true) {
            if (!(next instanceof BufferChunk)) {
                throw new IOException("Trying to extend compressed block into uncompressed block " + next);
            }
            compressed = next.getData();
            ++extraChunkCount;
            if (compressed.remaining() >= remaining) {
                slice = compressed.slice();
                slice.limit(remaining);
                copy.put(slice);
                ProcCacheChunk cc = this.addOneCompressionBlockByteBuffer(copy, isUncompressed, cbStartOffset, cbEndOffset, remaining, (BufferChunk)next, toDecompress, cacheBuffers);
                if (compressed.remaining() <= 0 && toRelease.remove(compressed).booleanValue()) {
                    this.releaseBuffer(compressed, true);
                }
                return cc;
            }
            remaining -= compressed.remaining();
            copy.put(compressed);
            if (toRelease.remove(compressed).booleanValue()) {
                this.releaseBuffer(compressed, true);
            }
            tmp = next;
            DiskRangeList diskRangeList = next = next.hasContiguousNext() ? next.next : null;
            if (next == null) break;
            if (this.isTracingEnabled) {
                LOG.trace("Removing partial CB " + tmp + " from ranges after copying its contents");
            }
            tmp.removeSelf();
        }
        badEstimates.add(this.addIncompleteCompressionBuffer(cbStartOffset, tmp, extraChunkCount));
        return null;
    }

    private void releaseBuffers(Collection<ByteBuffer> toRelease, boolean isFromDataReader) {
        if (toRelease == null) {
            return;
        }
        for (ByteBuffer buf : toRelease) {
            this.releaseBuffer(buf, isFromDataReader);
        }
    }

    private void releaseBuffer(ByteBuffer bb, boolean isFromDataReader) {
        if (this.isTracingEnabled) {
            LOG.trace("Releasing the buffer " + System.identityHashCode(bb));
        }
        if (isFromDataReader && this.dataReader.isTrackingDiskRanges()) {
            this.dataReader.releaseBuffer(bb);
            return;
        }
        Field localCf = cleanerField;
        if (!bb.isDirect() || localCf == null) {
            return;
        }
        try {
            Cleaner cleaner = (Cleaner)localCf.get(bb);
            if (cleaner != null) {
                cleaner.clean();
            } else {
                LOG.debug("Unable to clean a buffer using cleaner - no cleaner");
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to clean direct buffers using Cleaner.");
            cleanerField = null;
        }
    }

    private IncompleteCb addIncompleteCompressionBuffer(long cbStartOffset, DiskRangeList target, int extraChunkCount) {
        IncompleteCb icb = new IncompleteCb(cbStartOffset, target.getEnd());
        if (this.isTracingEnabled) {
            LOG.trace("Replacing " + target + " (and " + extraChunkCount + " previous chunks) with " + icb + " in the buffers");
        }
        target.replaceSelfWith(icb);
        return icb;
    }

    private ProcCacheChunk addOneCompressionBlockByteBuffer(ByteBuffer fullCompressionBlock, boolean isUncompressed, long cbStartOffset, long cbEndOffset, int lastChunkLength, BufferChunk lastChunk, List<ProcCacheChunk> toDecompress, List<MemoryBuffer> cacheBuffers) {
        MemoryBuffer futureAlloc = this.cacheWrapper.getAllocator().createUnallocated();
        cacheBuffers.add(futureAlloc);
        ProcCacheChunk cc = EncodedReaderImpl.POOLS.pccPool.take();
        cc.init(cbStartOffset, cbEndOffset, !isUncompressed, fullCompressionBlock, futureAlloc, cacheBuffers.size() - 1);
        toDecompress.add(cc);
        if (this.isTracingEnabled) {
            LOG.trace("Adjusting " + lastChunk + " to consume " + lastChunkLength + " compressed bytes");
        }
        lastChunk.getChunk().position(lastChunk.getChunk().position() + lastChunkLength);
        if (lastChunk.getChunk().remaining() <= 0) {
            if (this.isTracingEnabled) {
                LOG.trace("Replacing " + lastChunk + " with " + cc + " in the buffers");
            }
            lastChunk.replaceSelfWith(cc);
        } else {
            if (this.isTracingEnabled) {
                LOG.trace("Adding " + cc + " before " + lastChunk + " in the buffers");
            }
            lastChunk.insertPartBefore(cc);
        }
        return cc;
    }

    private static ByteBuffer allocateBuffer(int size, boolean isDirect) {
        return isDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    private static Pools createPools(Reader.PoolFactory pf) {
        Pools pools = new Pools();
        pools.pccPool = pf.createPool(1024, new Pool.PoolObjectHelper<ProcCacheChunk>(){

            @Override
            public ProcCacheChunk create() {
                return new ProcCacheChunk();
            }

            @Override
            public void resetBeforeOffer(ProcCacheChunk t) {
                t.reset();
            }
        });
        pools.tccPool = pf.createPool(1024, new Pool.PoolObjectHelper<CacheChunk>(){

            @Override
            public CacheChunk create() {
                return new CacheChunk();
            }

            @Override
            public void resetBeforeOffer(CacheChunk t) {
                t.reset();
            }
        });
        pools.ecbPool = pf.createEncodedColumnBatchPool();
        pools.csdPool = pf.createColumnStreamDataPool();
        return pools;
    }

    static {
        try {
            Class<?> dbClazz = Class.forName("java.nio.DirectByteBuffer");
            cleanerField = dbClazz.getDeclaredField("cleaner");
            cleanerField.setAccessible(true);
        }
        catch (Throwable t) {
            cleanerField = null;
        }
        POOLS_CREATION_LOCK = new Object();
        CC_FACTORY = new DataCache.DiskRangeListFactory(){

            @Override
            public DiskRangeList createCacheChunk(MemoryBuffer buffer, long offset, long end) {
                CacheChunk tcc = POOLS.tccPool.take();
                tcc.init(buffer, offset, end);
                return tcc;
            }
        };
    }

    private static class NoopPoolFactory
    implements Reader.PoolFactory {
        private NoopPoolFactory() {
        }

        @Override
        public <T> Pool<T> createPool(final int size, final Pool.PoolObjectHelper<T> helper) {
            return new Pool<T>(){

                @Override
                public void offer(T t) {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public T take() {
                    return helper.create();
                }
            };
        }

        @Override
        public Pool<Reader.OrcEncodedColumnBatch> createEncodedColumnBatchPool() {
            return this.createPool(0, new Pool.PoolObjectHelper<Reader.OrcEncodedColumnBatch>(){

                @Override
                public Reader.OrcEncodedColumnBatch create() {
                    return new Reader.OrcEncodedColumnBatch();
                }

                @Override
                public void resetBeforeOffer(Reader.OrcEncodedColumnBatch t) {
                }
            });
        }

        @Override
        public Pool<EncodedColumnBatch.ColumnStreamData> createColumnStreamDataPool() {
            return this.createPool(0, new Pool.PoolObjectHelper<EncodedColumnBatch.ColumnStreamData>(){

                @Override
                public EncodedColumnBatch.ColumnStreamData create() {
                    return new EncodedColumnBatch.ColumnStreamData();
                }

                @Override
                public void resetBeforeOffer(EncodedColumnBatch.ColumnStreamData t) {
                }
            });
        }
    }

    private static class ProcCacheChunk
    extends CacheChunk {
        private ByteBuffer originalData = null;
        private boolean isOriginalDataCompressed;
        private int originalCbIndex;

        private ProcCacheChunk() {
        }

        public void init(long cbStartOffset, long cbEndOffset, boolean isCompressed, ByteBuffer originalData, MemoryBuffer targetBuffer, int originalCbIndex) {
            super.init(targetBuffer, cbStartOffset, cbEndOffset);
            this.isOriginalDataCompressed = isCompressed;
            this.originalData = originalData;
            this.originalCbIndex = originalCbIndex;
        }

        @Override
        public void reset() {
            super.reset();
            this.originalData = null;
        }

        @Override
        public String toString() {
            return super.toString() + ", original is set " + (this.originalData != null) + ", buffer was replaced " + (this.originalCbIndex == -1);
        }

        @Override
        public void handleCacheCollision(DataCache cacheWrapper, MemoryBuffer replacementBuffer, List<MemoryBuffer> cacheBuffers) {
            assert (this.originalCbIndex >= 0);
            cacheWrapper.getAllocator().deallocate(this.getBuffer());
            cacheWrapper.reuseBuffer(replacementBuffer);
            this.buffer = replacementBuffer;
            cacheBuffers.set(this.originalCbIndex, replacementBuffer);
            this.originalCbIndex = -1;
        }
    }

    private static class UncompressedCacheChunk
    extends CacheChunk {
        private BufferChunk chunk;
        private int count;

        public UncompressedCacheChunk(BufferChunk bc) {
            this.init(null, bc.getOffset(), bc.getEnd());
            this.chunk = bc;
            this.count = 1;
        }

        public void addChunk(BufferChunk bc) {
            assert (bc.getOffset() == this.getEnd());
            this.end = bc.getEnd();
            ++this.count;
        }

        public BufferChunk getChunk() {
            return this.chunk;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void handleCacheCollision(DataCache cacheWrapper, MemoryBuffer replacementBuffer, List<MemoryBuffer> cacheBuffers) {
            assert (cacheBuffers == null);
            cacheWrapper.getAllocator().deallocate(this.getBuffer());
            this.setBuffer(replacementBuffer);
        }

        public void clear() {
            this.chunk = null;
            this.count = -1;
        }
    }

    private static final class StreamContext {
        public long offset;
        public long length;
        public int streamIndexOffset;
        public OrcProto.Stream.Kind kind;
        DiskRangeList bufferIter;
        EncodedColumnBatch.ColumnStreamData stripeLevelStream;

        public StreamContext(OrcProto.Stream stream, long streamOffset, int streamIndexOffset) {
            this.kind = stream.getKind();
            this.length = stream.getLength();
            this.offset = streamOffset;
            this.streamIndexOffset = streamIndexOffset;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" kind: ").append(this.kind);
            sb.append(" offset: ").append(this.offset);
            sb.append(" length: ").append(this.length);
            sb.append(" index_offset: ").append(this.streamIndexOffset);
            return sb.toString();
        }
    }

    private static final class ColumnReadContext {
        public static final int MAX_STREAMS = 6;
        int streamCount = 0;
        final StreamContext[] streams = new StreamContext[6];
        OrcProto.ColumnEncoding encoding;
        OrcProto.RowIndex rowIndex;
        int colIx;
        int includedIx;

        public ColumnReadContext(int colIx, OrcProto.ColumnEncoding encoding, OrcProto.RowIndex rowIndex, int colRgIx) {
            this.encoding = encoding;
            this.rowIndex = rowIndex;
            this.colIx = colIx;
            this.includedIx = colRgIx;
            this.streamCount = 0;
        }

        public void addStream(long offset, OrcProto.Stream stream, int indexIx) {
            this.streams[this.streamCount++] = new StreamContext(stream, offset, indexIx);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(" column_index: ").append(this.colIx);
            sb.append(" included_index: ").append(this.includedIx);
            sb.append(" encoding: ").append(this.encoding);
            sb.append(" stream_count: ").append(this.streamCount);
            int i = 0;
            for (StreamContext sc : this.streams) {
                if (sc != null) {
                    sb.append(" stream_").append(i).append(":").append(sc.toString());
                }
                ++i;
            }
            return sb.toString();
        }
    }

    private static class Pools {
        Pool<CacheChunk> tccPool;
        Pool<ProcCacheChunk> pccPool;
        Pool<Reader.OrcEncodedColumnBatch> ecbPool;
        Pool<EncodedColumnBatch.ColumnStreamData> csdPool;

        private Pools() {
        }
    }
}

