/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.stats;

import io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.mr.Throttle;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanWork;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;

public class PartialScanTask
extends Task<PartialScanWork>
implements Serializable,
HadoopJobExecHook {
    private static final long serialVersionUID = 1L;
    protected transient JobConf job;
    protected HadoopJobExecHelper jobExecHelper;
    boolean success = true;
    public static final String INPUT_SEPERATOR = ":";

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext driverContext, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, driverContext, opContext);
        this.job = new JobConf((Configuration)this.conf, PartialScanTask.class);
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, this);
    }

    @Override
    public boolean requireLock() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int execute(DriverContext driverContext) {
        StatsFactory factory;
        HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT, CombineHiveInputFormat.class.getName());
        this.success = true;
        HiveFileFormatUtils.prepareJobOutput(this.job);
        this.job.setOutputFormat(HiveOutputFormatImpl.class);
        this.job.setMapperClass(((PartialScanWork)this.work).getMapperClass());
        Context ctx = driverContext.getCtx();
        boolean ctxCreated = false;
        try {
            if (ctx == null) {
                ctx = new Context((Configuration)this.job);
                ctxCreated = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.console.printError("Error launching map-reduce job", "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 5;
        }
        this.job.setMapOutputKeyClass(NullWritable.class);
        this.job.setMapOutputValueClass(NullWritable.class);
        if (((PartialScanWork)this.work).getNumMapTasks() != null) {
            this.job.setNumMapTasks(((PartialScanWork)this.work).getNumMapTasks().intValue());
        }
        this.job.setNumReduceTasks(0);
        if (((PartialScanWork)this.work).getMinSplitSize() != null) {
            HiveConf.setLongVar((Configuration)this.job, HiveConf.ConfVars.MAPREDMINSPLITSIZE, ((PartialScanWork)this.work).getMinSplitSize());
        }
        if (((PartialScanWork)this.work).getInputformat() != null) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT, ((PartialScanWork)this.work).getInputformat());
        }
        String inpFormat = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.HIVEINPUTFORMAT);
        LOG.info("Using " + inpFormat);
        try {
            this.job.setInputFormat(JavaUtils.loadClass(inpFormat));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.job.setOutputKeyClass(NullWritable.class);
        this.job.setOutputValueClass(NullWritable.class);
        int returnVal = 0;
        RunningJob rj = null;
        boolean noName = StringUtils.isEmpty(this.job.get("mapreduce.job.name"));
        String jobName = null;
        if (noName && this.getQueryPlan() != null) {
            int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
            jobName = Utilities.abbreviate(this.getQueryPlan().getQueryStr(), maxlen - 6);
        }
        if (noName) {
            this.job.set("mapreduce.job.name", jobName != null ? jobName : "JOB" + Utilities.randGen.nextInt());
        }
        HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.HIVE_STATS_KEY_PREFIX, ((PartialScanWork)this.work).getAggKey());
        this.job.set("hive.stats.tmp.loc", ((PartialScanWork)this.work).getStatsTmpDir());
        this.addInputPaths(this.job, (PartialScanWork)this.work);
        MapredWork mrWork = new MapredWork();
        mrWork.setMapWork((MapWork)this.work);
        Utilities.setMapRedWork((Configuration)this.job, mrWork, ctx.getMRTmpPath());
        String pwd = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD);
        if (pwd != null) {
            HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, "HIVE");
        }
        JobClient jc = new JobClient(this.job);
        String addedJars = Utilities.getResourceFiles((Configuration)this.job, SessionState.ResourceType.JAR);
        if (!addedJars.isEmpty()) {
            this.job.set("tmpjars", addedJars);
        }
        Throttle.checkJobTracker(this.job, LOG);
        if (((PartialScanWork)this.work).isGatheringStats() && (factory = StatsFactory.newFactory((Configuration)this.job)) != null) {
            StatsPublisher statsPublisher = factory.getStatsPublisher();
            StatsCollectionContext sc = new StatsCollectionContext((Configuration)this.job);
            sc.setStatsTmpDir(((PartialScanWork)this.work).getStatsTmpDir());
            if (!statsPublisher.init(sc) && HiveConf.getBoolVar((Configuration)this.job, HiveConf.ConfVars.HIVE_STATS_RELIABLE)) {
                throw new HiveException(ErrorMsg.STATSPUBLISHER_INITIALIZATION_ERROR.getErrorCodedMsg());
            }
        }
        rj = jc.submitJob(this.job);
        this.jobID = rj.getJobID();
        returnVal = this.jobExecHelper.progress(rj, jc, ctx);
        this.success = returnVal == 0;
        try {
            if (ctxCreated) {
                ctx.clear();
            }
            if (rj == null || returnVal == 0) return returnVal;
            rj.killJob();
            return returnVal;
        }
        catch (Exception e) {
            LOG.warn("Failed in cleaning up ", e);
            return returnVal;
        }
        finally {
            HadoopJobExecHelper.runningJobs.remove(rj);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.setException(e);
                String mesg = " with exception '" + Utilities.getNameMessage(e) + "'";
                mesg = rj != null ? "Ended Job = " + rj.getJobID() + mesg : "Job Submission failed" + mesg;
                this.console.printError(mesg, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                this.success = false;
                returnVal = 1;
            }
            catch (Throwable throwable) {
                try {
                    if (ctxCreated) {
                        ctx.clear();
                    }
                    if (rj == null || returnVal == 0) throw throwable;
                    rj.killJob();
                    throw throwable;
                }
                catch (Exception e2) {
                    LOG.warn("Failed in cleaning up ", e2);
                    throw throwable;
                }
                finally {
                    HadoopJobExecHelper.runningJobs.remove(rj);
                }
            }
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
                if (rj != null && returnVal != 0) {
                    rj.killJob();
                }
                HadoopJobExecHelper.runningJobs.remove(rj);
            }
            catch (Exception e3) {
                try {
                    LOG.warn("Failed in cleaning up ", e3);
                    HadoopJobExecHelper.runningJobs.remove(rj);
                }
                catch (Throwable throwable) {
                    HadoopJobExecHelper.runningJobs.remove(rj);
                    throw throwable;
                }
                return returnVal;
            }
            return returnVal;
        }
    }

    private void addInputPaths(JobConf job, PartialScanWork work) {
        for (Path path : work.getInputPaths()) {
            FileInputFormat.addInputPath((JobConf)job, (Path)path);
        }
    }

    @Override
    public String getName() {
        return "RCFile Statistics Partial Scan";
    }

    public static void main(String[] args) {
        String inputPathStr = null;
        String outputDir = null;
        String jobConfFileName = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-input")) {
                    inputPathStr = args[++i];
                    continue;
                }
                if (args[i].equals("-jobconffile")) {
                    jobConfFileName = args[++i];
                    continue;
                }
                if (!args[i].equals("-outputDir")) continue;
                outputDir = args[++i];
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Missing argument to option");
            PartialScanTask.printUsage();
        }
        if (inputPathStr == null || outputDir == null || outputDir.trim().equals("")) {
            PartialScanTask.printUsage();
        }
        ArrayList<Path> inputPaths = new ArrayList<Path>();
        String[] paths = inputPathStr.split(INPUT_SEPERATOR);
        if (paths == null || paths.length == 0) {
            PartialScanTask.printUsage();
        }
        FileSystem fs = null;
        JobConf conf = new JobConf(PartialScanTask.class);
        for (String path : paths) {
            try {
                FileStatus fstatus;
                Path pathObj = new Path(path);
                if (fs == null) {
                    fs = FileSystem.get((URI)pathObj.toUri(), (Configuration)conf);
                }
                if ((fstatus = fs.getFileStatus(pathObj)).isDir()) {
                    FileStatus[] fileStatus;
                    for (FileStatus st : fileStatus = fs.listStatus(pathObj)) {
                        inputPaths.add(st.getPath());
                    }
                    continue;
                }
                inputPaths.add(fstatus.getPath());
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        if (jobConfFileName != null) {
            conf.addResource(new Path(jobConfFileName));
        }
        Logger LOG = LoggerFactory.getLogger(PartialScanTask.class.getName());
        boolean isSilent = HiveConf.getBoolVar((Configuration)conf, HiveConf.ConfVars.HIVESESSIONSILENT);
        SessionState.LogHelper console = new SessionState.LogHelper(LOG, isSilent);
        for (Appender appender : ((org.apache.logging.log4j.core.Logger)LogManager.getRootLogger()).getAppenders().values()) {
            if (appender instanceof FileAppender) {
                console.printInfo("Execution log at: " + ((FileAppender)appender).getFileName());
                continue;
            }
            if (!(appender instanceof RollingFileAppender)) continue;
            console.printInfo("Execution log at: " + ((RollingFileAppender)appender).getFileName());
        }
        QueryState queryState = new QueryState(new HiveConf((Configuration)conf, PartialScanTask.class));
        PartialScanWork mergeWork = new PartialScanWork(inputPaths);
        DriverContext driverCxt = new DriverContext();
        PartialScanTask taskExec = new PartialScanTask();
        taskExec.initialize(queryState, null, driverCxt, new CompilationOpContext());
        taskExec.setWork(mergeWork);
        int ret = taskExec.execute(driverCxt);
        if (ret != 0) {
            System.exit(2);
        }
    }

    private static void printUsage() {
        System.exit(1);
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        return false;
    }

    @Override
    public void logPlanProgress(SessionState ss) throws IOException {
    }
}

