/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.thrift.TException;

public class SessionHiveMetaStoreClient
extends HiveMetaStoreClient
implements IMetaStoreClient {
    private Warehouse wh = null;

    SessionHiveMetaStoreClient(HiveConf conf, Boolean allowEmbedded) throws MetaException {
        super(conf, null, allowEmbedded);
    }

    SessionHiveMetaStoreClient(HiveConf conf, HiveMetaHookLoader hookLoader, Boolean allowEmbedded) throws MetaException {
        super(conf, hookLoader, allowEmbedded);
    }

    private Warehouse getWh() throws MetaException {
        if (this.wh == null) {
            this.wh = new Warehouse(this.conf);
        }
        return this.wh;
    }

    @Override
    protected void create_table_with_environment_context(org.apache.hadoop.hive.metastore.api.Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        if (tbl.isTemporary()) {
            this.createTempTable(tbl, envContext);
            return;
        }
        super.create_table_with_environment_context(tbl, envContext);
    }

    @Override
    protected void drop_table_with_environment_context(String dbname, String name, boolean deleteData, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbname, name);
        if (table != null) {
            try {
                this.deleteTempTableColumnStatsForTable(dbname, name);
            }
            catch (NoSuchObjectException err) {
                LOG.info("Object not found in metastore", (Throwable)((Object)err));
            }
            this.dropTempTable(table, deleteData, envContext);
            return;
        }
        super.drop_table_with_environment_context(dbname, name, deleteData, envContext);
    }

    @Override
    public org.apache.hadoop.hive.metastore.api.Table getTable(String dbname, String name) throws MetaException, TException, NoSuchObjectException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbname, name);
        if (table != null) {
            return this.deepCopy(table);
        }
        return super.getTable(dbname, name);
    }

    @Override
    public List<String> getAllTables(String dbName) throws MetaException {
        List<String> tableNames = super.getAllTables(dbName);
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName);
        if (tables == null || tables.size() == 0) {
            return tableNames;
        }
        Set<String> tempTableNames = tables.keySet();
        HashSet<String> allTableNames = new HashSet<String>(tableNames.size() + tempTableNames.size());
        allTableNames.addAll(tableNames);
        allTableNames.addAll(tempTableNames);
        tableNames = new ArrayList<String>(allTableNames);
        Collections.sort(tableNames);
        return tableNames;
    }

    @Override
    public List<String> getTables(String dbName, String tablePattern) throws MetaException {
        List<String> tableNames = super.getTables(dbName, tablePattern);
        dbName = dbName.toLowerCase();
        tablePattern = tablePattern.toLowerCase();
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName);
        if (tables == null || tables.size() == 0) {
            return tableNames;
        }
        tablePattern = tablePattern.replaceAll("\\*", ".*");
        Pattern pattern = Pattern.compile(tablePattern);
        Matcher matcher = pattern.matcher("");
        HashSet<String> combinedTableNames = new HashSet<String>();
        for (String tableName : tables.keySet()) {
            matcher.reset(tableName);
            if (!matcher.matches()) continue;
            combinedTableNames.add(tableName);
        }
        combinedTableNames.addAll(tableNames);
        tableNames = new ArrayList<String>(combinedTableNames);
        Collections.sort(tableNames);
        return tableNames;
    }

    @Override
    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException {
        List<TableMeta> tableMetas = super.getTableMeta(dbPatterns, tablePatterns, tableTypes);
        Map<String, Map<String, Table>> tmpTables = SessionHiveMetaStoreClient.getTempTables();
        if (tmpTables.isEmpty()) {
            return tableMetas;
        }
        ArrayList<Matcher> dbPatternList = new ArrayList<Matcher>();
        for (String element : dbPatterns.split("\\|")) {
            dbPatternList.add(Pattern.compile(element.replaceAll("\\*", ".*")).matcher(""));
        }
        ArrayList<Matcher> tblPatternList = new ArrayList<Matcher>();
        for (String element : tablePatterns.split("\\|")) {
            tblPatternList.add(Pattern.compile(element.replaceAll("\\*", ".*")).matcher(""));
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Map<String, Table>> outer : tmpTables.entrySet()) {
            if (!this.matchesAny(outer.getKey(), dbPatternList)) continue;
            for (Map.Entry<String, Table> inner : outer.getValue().entrySet()) {
                Table table = inner.getValue();
                String tableName = table.getTableName();
                String typeString = table.getTableType().name();
                if (tableTypes != null && !tableTypes.contains(typeString) || !this.matchesAny(inner.getKey(), tblPatternList)) continue;
                TableMeta tableMeta = new TableMeta(table.getDbName(), tableName, typeString);
                tableMeta.setComments(table.getProperty("comment"));
                tableMetas.add(tableMeta);
            }
        }
        return tableMetas;
    }

    private boolean matchesAny(String string, List<Matcher> matchers) {
        for (Matcher matcher : matchers) {
            if (!matcher.reset(string).matches()) continue;
            return true;
        }
        return matchers.isEmpty();
    }

    @Override
    public List<org.apache.hadoop.hive.metastore.api.Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        dbName = dbName.toLowerCase();
        if (SessionState.get().getTempTables().size() == 0) {
            return super.getTableObjectsByName(dbName, tableNames);
        }
        ArrayList<org.apache.hadoop.hive.metastore.api.Table> tables = new ArrayList<org.apache.hadoop.hive.metastore.api.Table>();
        for (String tableName : tableNames) {
            try {
                org.apache.hadoop.hive.metastore.api.Table table = this.getTable(dbName, tableName);
                if (table == null) continue;
                tables.add(table);
            }
            catch (NoSuchObjectException noSuchObjectException) {}
        }
        return tables;
    }

    @Override
    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(databaseName, tableName);
        if (table != null) {
            return true;
        }
        return super.tableExists(databaseName, tableName);
    }

    @Override
    public List<FieldSchema> getSchema(String dbName, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        org.apache.hadoop.hive.metastore.api.Table table = this.getTempTable(dbName, tableName);
        if (table != null) {
            return this.deepCopyFieldSchemas(table.getSd().getCols());
        }
        return super.getSchema(dbName, tableName);
    }

    @Override
    @Deprecated
    public void alter_table(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl, boolean cascade) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbname, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbname, tbl_name, old_tbl, new_tbl, null);
            return;
        }
        super.alter_table(dbname, tbl_name, new_tbl, cascade);
    }

    @Override
    public void alter_table(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbname, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbname, tbl_name, old_tbl, new_tbl, null);
            return;
        }
        super.alter_table(dbname, tbl_name, new_tbl);
    }

    @Override
    public void alter_table_with_environmentContext(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table new_tbl, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table old_tbl = this.getTempTable(dbname, tbl_name);
        if (old_tbl != null) {
            this.alterTempTable(dbname, tbl_name, old_tbl, new_tbl, envContext);
            return;
        }
        super.alter_table_with_environmentContext(dbname, tbl_name, new_tbl, envContext);
    }

    @Override
    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
        org.apache.hadoop.hive.metastore.api.Table table;
        if (hiveObject.getObjectType() == HiveObjectType.TABLE && (table = this.getTempTable(hiveObject.getDbName(), hiveObject.getObjectName())) != null) {
            return this.deepCopy(table.getPrivileges());
        }
        return super.get_privilege_set(hiveObject, userName, groupNames);
    }

    @Override
    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        String tableName;
        ColumnStatistics colStats;
        ColumnStatisticsDesc desc;
        String dbName;
        if (request.getColStatsSize() == 1 && this.getTempTable(dbName = (desc = (colStats = request.getColStatsIterator().next()).getStatsDesc()).getDbName().toLowerCase(), tableName = desc.getTableName().toLowerCase()) != null) {
            return this.updateTempTableColumnStats(dbName, tableName, colStats);
        }
        return super.setPartitionColumnStatistics(request);
    }

    @Override
    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException, InvalidInputException, InvalidObjectException {
        if (this.getTempTable(dbName, tableName) != null) {
            return this.getTempTableColumnStats(dbName, tableName, colNames);
        }
        return super.getTableColumnStatistics(dbName, tableName, colNames);
    }

    @Override
    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        if (this.getTempTable(dbName, tableName) != null) {
            return this.deleteTempTableColumnStats(dbName, tableName, colName);
        }
        return super.deleteTableColumnStatistics(dbName, tableName, colName);
    }

    private void createTempTable(org.apache.hadoop.hive.metastore.api.Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        SessionState ss = SessionState.get();
        if (ss == null) {
            throw new MetaException("No current SessionState, cannot create temporary table" + tbl.getDbName() + "." + tbl.getTableName());
        }
        tbl = this.deepCopyAndLowerCaseTable(tbl);
        String dbName = tbl.getDbName();
        String tblName = tbl.getTableName();
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName);
        if (tables != null && tables.containsKey(tblName)) {
            throw new MetaException("Temporary table " + dbName + "." + tblName + " already exists");
        }
        Warehouse wh = this.getWh();
        Path tblPath = wh.getDnsPath(new Path(tbl.getSd().getLocation()));
        if (tblPath == null) {
            throw new MetaException("Temp table path not set for " + tbl.getTableName());
        }
        if (!wh.isDir(tblPath) && !wh.mkdirs(tblPath, true)) {
            throw new MetaException(tblPath + " is not a directory or unable to create one");
        }
        tbl.getSd().setLocation(tblPath.toString());
        Table tTable = new Table(tbl);
        if (tables == null) {
            tables = new HashMap<String, Table>();
            ss.getTempTables().put(dbName, tables);
        }
        tables.put(tblName, tTable);
    }

    private org.apache.hadoop.hive.metastore.api.Table getTempTable(String dbName, String tableName) {
        Table table;
        Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName.toLowerCase());
        if (tables != null && (table = tables.get(tableName.toLowerCase())) != null) {
            return table.getTTable();
        }
        return null;
    }

    private void alterTempTable(String dbname, String tbl_name, org.apache.hadoop.hive.metastore.api.Table oldt, org.apache.hadoop.hive.metastore.api.Table newt, EnvironmentContext envContext) throws InvalidOperationException, MetaException, TException {
        dbname = dbname.toLowerCase();
        tbl_name = tbl_name.toLowerCase();
        boolean shouldDeleteColStats = false;
        if (!newt.getSd().getLocation().equals(oldt.getSd().getLocation())) {
            throw new MetaException("Temp table location cannot be changed");
        }
        org.apache.hadoop.hive.metastore.api.Table newtCopy = this.deepCopyAndLowerCaseTable(newt);
        MetaStoreUtils.updateTableStatsFast(newtCopy, this.getWh().getFileStatusesForSD(newtCopy.getSd()), false, true, envContext);
        Table newTable = new Table(newtCopy);
        String newDbName = newTable.getDbName();
        String newTableName = newTable.getTableName();
        if (!newDbName.equals(oldt.getDbName()) || !newTableName.equals(oldt.getTableName())) {
            if (this.getTempTable(newDbName, newTableName) != null) {
                throw new MetaException("Cannot rename temporary table to " + newTableName + " - temporary table already exists with the same name");
            }
            Map<String, Table> tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbname);
            if (tables == null || tables.remove(tbl_name) == null) {
                throw new MetaException("Could not find temp table entry for " + dbname + "." + tbl_name);
            }
            shouldDeleteColStats = true;
            tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(newDbName);
            if (tables == null) {
                tables = new HashMap<String, Table>();
                SessionState.get().getTempTables().put(newDbName, tables);
            }
            tables.put(newTableName, newTable);
        } else {
            if (SessionHiveMetaStoreClient.haveTableColumnsChanged(oldt, newt)) {
                shouldDeleteColStats = true;
            }
            SessionHiveMetaStoreClient.getTempTablesForDatabase(dbname).put(tbl_name, newTable);
        }
        if (shouldDeleteColStats) {
            try {
                this.deleteTempTableColumnStatsForTable(dbname, tbl_name);
            }
            catch (NoSuchObjectException err) {
                LOG.info("Object not found in metastore", (Throwable)((Object)err));
            }
        }
    }

    private static boolean haveTableColumnsChanged(org.apache.hadoop.hive.metastore.api.Table oldt, org.apache.hadoop.hive.metastore.api.Table newt) {
        List<FieldSchema> oldCols = oldt.getSd().getCols();
        List<FieldSchema> newCols = newt.getSd().getCols();
        if (oldCols.size() != newCols.size()) {
            return true;
        }
        Iterator<FieldSchema> oldColsIter = oldCols.iterator();
        Iterator<FieldSchema> newColsIter = newCols.iterator();
        while (oldColsIter.hasNext()) {
            if (SessionHiveMetaStoreClient.fieldSchemaEqualsIgnoreComment(oldColsIter.next(), newColsIter.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean fieldSchemaEqualsIgnoreComment(FieldSchema left, FieldSchema right) {
        if (!left.getName().equals(right.getName())) {
            return true;
        }
        return !left.getType().equals(right.getType());
    }

    private void dropTempTable(org.apache.hadoop.hive.metastore.api.Table table, boolean deleteData, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        Map<String, Table> tables;
        String dbName = table.getDbName().toLowerCase();
        String tableName = table.getTableName().toLowerCase();
        Path tablePath = null;
        String pathStr = table.getSd().getLocation();
        if (pathStr != null) {
            try {
                tablePath = new Path(table.getSd().getLocation());
                if (!this.getWh().isWritable(tablePath.getParent())) {
                    throw new MetaException("Table metadata not deleted since " + tablePath.getParent() + " is not writable by " + this.conf.getUser());
                }
            }
            catch (IOException err) {
                MetaException metaException = new MetaException("Error checking temp table path for " + table.getTableName());
                metaException.initCause(err);
                throw metaException;
            }
        }
        if ((tables = SessionHiveMetaStoreClient.getTempTablesForDatabase(dbName)) == null || tables.remove(tableName) == null) {
            throw new MetaException("Could not find temp table entry for " + dbName + "." + tableName);
        }
        if (deleteData && !MetaStoreUtils.isExternalTable(table)) {
            try {
                boolean ifPurge = false;
                if (envContext != null) {
                    ifPurge = Boolean.parseBoolean(envContext.getProperties().get("ifPurge"));
                }
                this.getWh().deleteDir(tablePath, true, ifPurge);
            }
            catch (Exception err) {
                LOG.error("Failed to delete temp table directory: " + tablePath, err);
            }
        }
    }

    private org.apache.hadoop.hive.metastore.api.Table deepCopyAndLowerCaseTable(org.apache.hadoop.hive.metastore.api.Table tbl) {
        org.apache.hadoop.hive.metastore.api.Table newCopy = this.deepCopy(tbl);
        newCopy.setDbName(newCopy.getDbName().toLowerCase());
        newCopy.setTableName(newCopy.getTableName().toLowerCase());
        return newCopy;
    }

    public static Map<String, Table> getTempTablesForDatabase(String dbName) {
        return SessionHiveMetaStoreClient.getTempTables().get(dbName);
    }

    public static Map<String, Map<String, Table>> getTempTables() {
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.debug("No current SessionState, skipping temp tables");
            return Collections.emptyMap();
        }
        return ss.getTempTables();
    }

    private Map<String, ColumnStatisticsObj> getTempTableColumnStatsForTable(String dbName, String tableName) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            LOG.debug("No current SessionState, skipping temp tables");
            return null;
        }
        String lookupName = StatsUtils.getFullyQualifiedTableName(dbName.toLowerCase(), tableName.toLowerCase());
        return ss.getTempTableColStats().get(lookupName);
    }

    private List<ColumnStatisticsObj> getTempTableColumnStats(String dbName, String tableName, List<String> colNames) {
        Map<String, ColumnStatisticsObj> tableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        ArrayList<ColumnStatisticsObj> retval = new ArrayList<ColumnStatisticsObj>();
        if (tableColStats != null) {
            for (String colName : colNames) {
                if (!tableColStats.containsKey(colName = colName.toLowerCase())) continue;
                retval.add(new ColumnStatisticsObj(tableColStats.get(colName)));
            }
        }
        return retval;
    }

    private boolean updateTempTableColumnStats(String dbName, String tableName, ColumnStatistics colStats) throws MetaException {
        SessionState ss = SessionState.get();
        if (ss == null) {
            throw new MetaException("No current SessionState, cannot update temporary table stats for " + dbName + "." + tableName);
        }
        Map<String, ColumnStatisticsObj> ssTableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (ssTableColStats == null) {
            ssTableColStats = new HashMap<String, ColumnStatisticsObj>();
            ss.getTempTableColStats().put(StatsUtils.getFullyQualifiedTableName(dbName, tableName), ssTableColStats);
        }
        SessionHiveMetaStoreClient.mergeColumnStats(ssTableColStats, colStats);
        return true;
    }

    private static void mergeColumnStats(Map<String, ColumnStatisticsObj> oldStats, ColumnStatistics newStats) {
        List<ColumnStatisticsObj> newColList = newStats.getStatsObj();
        if (newColList != null) {
            for (ColumnStatisticsObj colStat : newColList) {
                oldStats.put(colStat.getColName().toLowerCase(), colStat);
            }
        }
    }

    private boolean deleteTempTableColumnStatsForTable(String dbName, String tableName) throws NoSuchObjectException {
        Map<String, ColumnStatisticsObj> deletedEntry = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (deletedEntry == null) {
            throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " temp table=" + tableName);
        }
        SessionState.get().getTempTableColStats().remove(StatsUtils.getFullyQualifiedTableName(dbName, tableName));
        return true;
    }

    private boolean deleteTempTableColumnStats(String dbName, String tableName, String columnName) throws NoSuchObjectException {
        ColumnStatisticsObj deletedEntry = null;
        Map<String, ColumnStatisticsObj> ssTableColStats = this.getTempTableColumnStatsForTable(dbName, tableName);
        if (ssTableColStats != null) {
            deletedEntry = ssTableColStats.remove(columnName.toLowerCase());
        }
        if (deletedEntry == null) {
            throw new NoSuchObjectException("Column stats doesn't exist for db=" + dbName + " temp table=" + tableName);
        }
        return true;
    }
}

