/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatUtils;

public final class MetaDataPrettyFormatUtils {
    public static final int PRETTY_MAX_INTERCOL_SPACING = 4;
    private static final int PRETTY_ALIGNMENT = 10;
    private static final int MIN_COMMENT_COLUMN_LEN = 10;

    private MetaDataPrettyFormatUtils() {
    }

    public static String getAllColumnsInformation(List<FieldSchema> cols, List<FieldSchema> partCols, int prettyOutputNumCols) {
        StringBuilder columnInformation = new StringBuilder(2048);
        int maxColNameLen = MetaDataPrettyFormatUtils.findMaxColumnNameLen(cols);
        MetaDataPrettyFormatUtils.formatColumnsHeaderPretty(columnInformation, maxColNameLen, prettyOutputNumCols);
        MetaDataPrettyFormatUtils.formatAllFieldsPretty(columnInformation, cols, maxColNameLen, prettyOutputNumCols);
        if (partCols != null && !partCols.isEmpty()) {
            columnInformation.append("\n").append("# Partition Information").append("\n");
            MetaDataPrettyFormatUtils.formatColumnsHeaderPretty(columnInformation, maxColNameLen, prettyOutputNumCols);
            MetaDataPrettyFormatUtils.formatAllFieldsPretty(columnInformation, partCols, maxColNameLen, prettyOutputNumCols);
        }
        return columnInformation.toString();
    }

    private static int findMaxColumnNameLen(List<FieldSchema> cols) {
        int maxLen = -1;
        for (FieldSchema col : cols) {
            int colNameLen = col.getName().length();
            if (colNameLen <= maxLen) continue;
            maxLen = colNameLen;
        }
        return maxLen;
    }

    private static void formatColumnsHeaderPretty(StringBuilder columnInformation, int maxColNameLen, int prettyOutputNumCols) {
        String[] columnHeaders = MetaDataFormatUtils.getColumnsHeader(null);
        MetaDataPrettyFormatUtils.formatOutputPretty(columnHeaders[0], columnHeaders[1], columnHeaders[2], columnInformation, maxColNameLen, prettyOutputNumCols);
        columnInformation.append("\t").append("\t").append("\n");
    }

    private static void formatAllFieldsPretty(StringBuilder tableInfo, List<FieldSchema> cols, int maxColNameLen, int prettyOutputNumCols) {
        for (FieldSchema col : cols) {
            MetaDataPrettyFormatUtils.formatOutputPretty(col.getName(), col.getType(), MetaDataFormatUtils.getComment(col), tableInfo, maxColNameLen, prettyOutputNumCols);
        }
    }

    private static String breakCommentIntoMultipleLines(String comment, int columnsAlreadyConsumed, int prettyOutputNumCols) {
        int commentNumCols;
        if (prettyOutputNumCols == -1) {
            prettyOutputNumCols = 79;
        }
        if ((commentNumCols = prettyOutputNumCols - columnsAlreadyConsumed) < 10) {
            commentNumCols = 10;
        }
        int commentNumColsConsumed = 0;
        StringTokenizer st = new StringTokenizer(comment, " \t\n\r\f", true);
        StringBuilder commentBuilder = new StringBuilder(comment.length());
        while (st.hasMoreTokens()) {
            String currWord = st.nextToken();
            if (currWord.equals("\n") || currWord.equals("\r") || currWord.equals("\f")) {
                commentBuilder.append(currWord);
                commentNumColsConsumed = 0;
                continue;
            }
            if (commentNumColsConsumed + currWord.length() > commentNumCols) {
                if (currWord.length() > commentNumCols) {
                    while (currWord.length() > commentNumCols) {
                        int remainingLineLen = commentNumCols - commentNumColsConsumed;
                        String wordChunk = currWord.substring(0, remainingLineLen);
                        commentBuilder.append(wordChunk);
                        commentBuilder.append("\n");
                        commentNumColsConsumed = 0;
                        currWord = currWord.substring(remainingLineLen);
                    }
                    if (currWord.length() <= 0) continue;
                    commentBuilder.append(currWord);
                    commentNumColsConsumed = currWord.length();
                    continue;
                }
                commentBuilder.append("\n");
                if (!currWord.equals(" ")) {
                    commentBuilder.append(currWord);
                    commentNumColsConsumed = currWord.length();
                    continue;
                }
                commentNumColsConsumed = 0;
                continue;
            }
            commentBuilder.append(currWord);
            commentNumColsConsumed += currWord.length();
        }
        return commentBuilder.toString();
    }

    private static int appendFormattedColumn(StringBuilder sb, String text, int alignment) {
        String paddedText = String.format("%-" + alignment + "s", text);
        int delimCount = 0;
        delimCount = paddedText.length() < alignment + 4 ? alignment + 4 - paddedText.length() : 4;
        String delim = StringUtils.repeat(" ", delimCount);
        sb.append(paddedText);
        sb.append(delim);
        sb.append("\t");
        return paddedText.length() + delim.length();
    }

    private static void formatOutputPretty(String colName, String colType, String colComment, StringBuilder tableInfo, int maxColNameLength, int prettyOutputNumCols) {
        int colsNameConsumed = MetaDataPrettyFormatUtils.appendFormattedColumn(tableInfo, colName, maxColNameLength + 1);
        int colsTypeConsumed = MetaDataPrettyFormatUtils.appendFormattedColumn(tableInfo, colType, 10);
        colComment = MetaDataPrettyFormatUtils.breakCommentIntoMultipleLines(colComment, colsNameConsumed + colsTypeConsumed, prettyOutputNumCols);
        String[] commentSegments = colComment.split("\n|\r|\r\n");
        tableInfo.append(MetaDataPrettyFormatUtils.trimTrailingWS(commentSegments[0]));
        tableInfo.append("\n");
        for (int i = 1; i < commentSegments.length; ++i) {
            tableInfo.append(String.format("%" + colsNameConsumed + "s" + "\t" + "%" + colsTypeConsumed + "s" + "\t" + "%s", "", "", commentSegments[i]));
            tableInfo.append("\n");
        }
    }

    private static String trimTrailingWS(String str) {
        return str.replaceAll("\\s+$", "");
    }
}

