/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import io.prestosql.hive.$internal.com.google.common.collect.ArrayListMultimap;
import io.prestosql.hive.$internal.com.google.common.collect.ImmutableList;
import io.prestosql.hive.$internal.com.google.common.collect.LinkedHashMultimap;
import io.prestosql.hive.$internal.com.google.common.collect.Lists;
import io.prestosql.hive.$internal.com.google.common.collect.Maps;
import io.prestosql.hive.$internal.com.google.common.collect.Multimap;
import io.prestosql.hive.$internal.com.google.common.collect.Sets;
import io.prestosql.hive.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIn;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HivePointLookupOptimizerRule
extends RelOptRule {
    protected static final Log LOG = LogFactory.getLog(HivePointLookupOptimizerRule.class);
    private final int minNumORClauses;

    public HivePointLookupOptimizerRule(int minNumORClauses) {
        super(HivePointLookupOptimizerRule.operand(Filter.class, (RelOptRuleOperandChildren)HivePointLookupOptimizerRule.any()));
        this.minNumORClauses = minNumORClauses;
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexNode condition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)filter.getCondition());
        RexTransformIntoInClause transformIntoInClause = new RexTransformIntoInClause(rexBuilder, filter, this.minNumORClauses);
        RexNode newCondition = transformIntoInClause.apply(condition);
        RexMergeInClause mergeInClause = new RexMergeInClause(rexBuilder);
        if ((newCondition = mergeInClause.apply(newCondition)).toString().equals(condition.toString())) {
            return;
        }
        Filter newFilter = filter.copy(filter.getTraitSet(), filter.getInput(), newCondition);
        call.transformTo((RelNode)newFilter);
    }

    protected static class RexMergeInClause
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        RexMergeInClause(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            RexNode node;
            HashMap<String, RexNode> stringToExpr = Maps.newHashMap();
            LinkedHashMultimap<String, String> inLHSExprToRHSExprs = LinkedHashMultimap.create();
            switch (call.getKind()) {
                case AND: {
                    ArrayList operands = Lists.newArrayList(RexUtil.flattenAnd((Iterable)call.getOperands()));
                    for (int i = 0; i < operands.size(); ++i) {
                        RexCall inCall;
                        RexNode operand = (RexNode)operands.get(i);
                        if (operand.getKind() != SqlKind.IN || !HiveCalciteUtil.isDeterministic((RexNode)(inCall = (RexCall)operand).getOperands().get(0))) continue;
                        String ref = ((RexNode)inCall.getOperands().get(0)).toString();
                        stringToExpr.put(ref, (RexNode)inCall.getOperands().get(0));
                        if (inLHSExprToRHSExprs.containsKey(ref)) {
                            HashSet<String> expressions = Sets.newHashSet();
                            for (int j = 1; j < inCall.getOperands().size(); ++j) {
                                String expr = ((RexNode)inCall.getOperands().get(j)).toString();
                                expressions.add(expr);
                                stringToExpr.put(expr, (RexNode)inCall.getOperands().get(j));
                            }
                            inLHSExprToRHSExprs.get(ref).retainAll(expressions);
                        } else {
                            for (int j = 1; j < inCall.getOperands().size(); ++j) {
                                String expr = ((RexNode)inCall.getOperands().get(j)).toString();
                                inLHSExprToRHSExprs.put(ref, expr);
                                stringToExpr.put(expr, (RexNode)inCall.getOperands().get(j));
                            }
                        }
                        operands.remove(i);
                        --i;
                    }
                    List<RexNode> newOperands = RexMergeInClause.createInClauses(this.rexBuilder, stringToExpr, inLHSExprToRHSExprs);
                    newOperands.addAll(operands);
                    node = RexUtil.composeConjunction((RexBuilder)this.rexBuilder, newOperands, (boolean)false);
                    break;
                }
                case OR: {
                    ArrayList operands = Lists.newArrayList(RexUtil.flattenOr((Iterable)call.getOperands()));
                    for (int i = 0; i < operands.size(); ++i) {
                        RexCall inCall;
                        RexNode operand = (RexNode)operands.get(i);
                        if (operand.getKind() != SqlKind.IN || !HiveCalciteUtil.isDeterministic((RexNode)(inCall = (RexCall)operand).getOperands().get(0))) continue;
                        String ref = ((RexNode)inCall.getOperands().get(0)).toString();
                        stringToExpr.put(ref, (RexNode)inCall.getOperands().get(0));
                        for (int j = 1; j < inCall.getOperands().size(); ++j) {
                            String expr = ((RexNode)inCall.getOperands().get(j)).toString();
                            inLHSExprToRHSExprs.put(ref, expr);
                            stringToExpr.put(expr, (RexNode)inCall.getOperands().get(j));
                        }
                        operands.remove(i);
                        --i;
                    }
                    List<RexNode> newOperands = RexMergeInClause.createInClauses(this.rexBuilder, stringToExpr, inLHSExprToRHSExprs);
                    newOperands.addAll(operands);
                    node = RexUtil.composeDisjunction((RexBuilder)this.rexBuilder, newOperands, (boolean)false);
                    break;
                }
                default: {
                    return super.visitCall(call);
                }
            }
            return node;
        }

        private static List<RexNode> createInClauses(RexBuilder rexBuilder, Map<String, RexNode> stringToExpr, Multimap<String, String> inLHSExprToRHSExprs) {
            ArrayList<RexNode> newExpressions = Lists.newArrayList();
            for (Map.Entry<String, Collection<String>> entry : inLHSExprToRHSExprs.asMap().entrySet()) {
                String ref = entry.getKey();
                Collection<String> exprs = entry.getValue();
                if (exprs.isEmpty()) {
                    newExpressions.add((RexNode)rexBuilder.makeLiteral(false));
                    continue;
                }
                ArrayList<RexNode> newOperands = new ArrayList<RexNode>(exprs.size() + 1);
                newOperands.add(stringToExpr.get(ref));
                for (String expr : exprs) {
                    newOperands.add(stringToExpr.get(expr));
                }
                newExpressions.add(rexBuilder.makeCall((SqlOperator)HiveIn.INSTANCE, newOperands));
            }
            return newExpressions;
        }
    }

    protected static class RexTransformIntoInClause
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final Filter filterOp;
        private final int minNumORClauses;

        RexTransformIntoInClause(RexBuilder rexBuilder, Filter filterOp, int minNumORClauses) {
            this.filterOp = filterOp;
            this.rexBuilder = rexBuilder;
            this.minNumORClauses = minNumORClauses;
        }

        /*
         * Unable to fully structure code
         */
        public RexNode visitCall(RexCall call) {
            switch (1.$SwitchMap$org$apache$calcite$sql$SqlKind[call.getKind().ordinal()]) {
                case 1: {
                    operands = RexUtil.flattenAnd((Iterable)call.getOperands());
                    newOperands = new ArrayList<RexNode>();
                    for (RexNode operand : operands) {
                        if (operand.getKind() == SqlKind.OR) {
                            try {
                                newOperand = RexTransformIntoInClause.transformIntoInClauseCondition(this.rexBuilder, this.filterOp.getRowType(), operand, this.minNumORClauses);
                                if (newOperand != null) ** GOTO lbl16
                                newOperand = operand;
                            }
                            catch (SemanticException e) {
                                HivePointLookupOptimizerRule.LOG.error("Exception in HivePointLookupOptimizerRule", e);
                                return call;
                            }
                        } else {
                            newOperand = operand;
                        }
lbl16:
                        // 3 sources

                        newOperands.add(newOperand);
                    }
                    node = RexUtil.composeConjunction((RexBuilder)this.rexBuilder, newOperands, (boolean)false);
                    break;
                }
                case 2: {
                    try {
                        node = RexTransformIntoInClause.transformIntoInClauseCondition(this.rexBuilder, this.filterOp.getRowType(), (RexNode)call, this.minNumORClauses);
                        if (node == null) {
                            return call;
                        }
                        break;
                    }
                    catch (SemanticException e) {
                        HivePointLookupOptimizerRule.LOG.error("Exception in HivePointLookupOptimizerRule", e);
                        return call;
                    }
                }
                default: {
                    return super.visitCall(call);
                }
            }
            return node;
        }

        private static RexNode transformIntoInClauseCondition(RexBuilder rexBuilder, RelDataType inputSchema, RexNode condition, int minNumORClauses) throws SemanticException {
            assert (condition.getKind() == SqlKind.OR);
            ArrayListMultimap<RexInputRef, RexLiteral> columnConstantsMap = ArrayListMultimap.create();
            ImmutableList operands = RexUtil.flattenOr((Iterable)((RexCall)condition).getOperands());
            if (operands.size() < minNumORClauses) {
                return null;
            }
            for (int i = 0; i < operands.size(); ++i) {
                List conjunctions = RelOptUtil.conjunctions((RexNode)((RexNode)operands.get(i)));
                for (RexNode conjunction : conjunctions) {
                    if (!(conjunction instanceof RexCall)) {
                        return null;
                    }
                    RexCall conjCall = (RexCall)conjunction;
                    if (conjCall.getOperator().getKind() == SqlKind.EQUALS) {
                        RexLiteral literal;
                        RexInputRef ref;
                        if (conjCall.operands.get(0) instanceof RexInputRef && conjCall.operands.get(1) instanceof RexLiteral) {
                            ref = (RexInputRef)conjCall.operands.get(0);
                            literal = (RexLiteral)conjCall.operands.get(1);
                            columnConstantsMap.put(ref, literal);
                            if (columnConstantsMap.get(ref).size() == i + 1) continue;
                            return null;
                        }
                        if (conjCall.operands.get(1) instanceof RexInputRef && conjCall.operands.get(0) instanceof RexLiteral) {
                            ref = (RexInputRef)conjCall.operands.get(1);
                            literal = (RexLiteral)conjCall.operands.get(0);
                            columnConstantsMap.put(ref, literal);
                            if (columnConstantsMap.get(ref).size() == i + 1) continue;
                            return null;
                        }
                        return null;
                    }
                    return null;
                }
            }
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>(operands.size());
            ArrayList<RexInputRef> columns = new ArrayList<RexInputRef>();
            ArrayList names = new ArrayList();
            ImmutableList.Builder paramsTypes = ImmutableList.builder();
            ArrayList<TypeInfo> structReturnType = new ArrayList<TypeInfo>();
            ImmutableList.Builder newOperandsTypes = ImmutableList.builder();
            for (int i = 0; i < operands.size(); ++i) {
                ArrayList<RexLiteral> constantFields = new ArrayList<RexLiteral>(operands.size());
                for (RexInputRef ref : columnConstantsMap.keySet()) {
                    if (columnConstantsMap.get(ref).size() <= i) {
                        return null;
                    }
                    RexLiteral columnConstant = (RexLiteral)columnConstantsMap.get(ref).get(i);
                    if (i == 0) {
                        columns.add(ref);
                        names.add(inputSchema.getFieldNames().get(ref.getIndex()));
                        paramsTypes.add(ref.getType());
                        structReturnType.add(TypeConverter.convert(ref.getType()));
                    }
                    constantFields.add(columnConstant);
                }
                if (i == 0) {
                    RexNode columnsRefs = columns.size() == 1 ? (RexNode)columns.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ROW, columns);
                    newOperands.add(columnsRefs);
                    newOperandsTypes.add(columnsRefs.getType());
                }
                RexNode values = constantFields.size() == 1 ? (RexNode)constantFields.get(0) : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ROW, constantFields);
                newOperands.add(values);
                newOperandsTypes.add(values.getType());
            }
            return rexBuilder.makeCall((SqlOperator)HiveIn.INSTANCE, newOperands);
        }
    }
}

