/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import io.prestosql.hive.$internal.com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.SubstitutionVisitor;

public class MaterializedViewSubstitutionVisitor
extends SubstitutionVisitor {
    private static final ImmutableList<SubstitutionVisitor.UnifyRule> EXTENDED_RULES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)DEFAULT_RULES)).add(ProjectToProjectUnifyRule1.INSTANCE)).add(FilterToFilterUnifyRule1.INSTANCE)).add(FilterToProjectUnifyRule1.INSTANCE)).build();

    public MaterializedViewSubstitutionVisitor(RelNode target_, RelNode query_) {
        super(target_, query_, EXTENDED_RULES);
    }

    public MaterializedViewSubstitutionVisitor(RelNode target_, RelNode query_, RelBuilderFactory relBuilderFactory) {
        super(target_, query_, EXTENDED_RULES, relBuilderFactory);
    }

    @Override
    public List<RelNode> go(RelNode replacement_) {
        return super.go(replacement_);
    }

    private static RexNode transformRex(RexNode node, List<RelDataTypeField> oldFields, List<RelDataTypeField> newFields) {
        List<RexNode> nodes = MaterializedViewSubstitutionVisitor.transformRex(ImmutableList.of(node), oldFields, newFields);
        return nodes.get(0);
    }

    private static List<RexNode> transformRex(List<RexNode> nodes, final List<RelDataTypeField> oldFields, final List<RelDataTypeField> newFields) {
        RexShuttle shuttle = new RexShuttle(){

            public RexNode visitInputRef(RexInputRef ref) {
                RelDataTypeField f = (RelDataTypeField)oldFields.get(ref.getIndex());
                for (int index = 0; index < newFields.size(); ++index) {
                    RelDataTypeField newf = (RelDataTypeField)newFields.get(index);
                    if (!((String)f.getKey()).equals(newf.getKey()) || f.getValue() != newf.getValue()) continue;
                    return new RexInputRef(index, (RelDataType)f.getValue());
                }
                throw SubstitutionVisitor.MatchFailed.INSTANCE;
            }
        };
        return shuttle.apply(nodes);
    }

    private static class FilterToProjectUnifyRule1
    extends SubstitutionVisitor.AbstractUnifyRule {
        public static final FilterToProjectUnifyRule1 INSTANCE = new FilterToProjectUnifyRule1();

        private FilterToProjectUnifyRule1() {
            super(FilterToProjectUnifyRule1.operand(SubstitutionVisitor.MutableFilter.class, FilterToProjectUnifyRule1.query(0)), FilterToProjectUnifyRule1.operand(SubstitutionVisitor.MutableProject.class, FilterToProjectUnifyRule1.operand(SubstitutionVisitor.MutableFilter.class, FilterToProjectUnifyRule1.target(0))), 1);
        }

        @Override
        public SubstitutionVisitor.UnifyResult apply(SubstitutionVisitor.UnifyRuleCall call) {
            List newProjects;
            SubstitutionVisitor.MutableRel query = call.query;
            List oldFieldList = query.getRowType().getFieldList();
            List newFieldList = call.target.getRowType().getFieldList();
            try {
                newProjects = MaterializedViewSubstitutionVisitor.transformRex(call.getCluster().getRexBuilder().identityProjects(query.getRowType()), (List<RelDataTypeField>)oldFieldList, (List<RelDataTypeField>)newFieldList);
            }
            catch (SubstitutionVisitor.MatchFailed e) {
                return null;
            }
            SubstitutionVisitor.MutableProject newProject = SubstitutionVisitor.MutableProject.of(query.getRowType(), call.target, newProjects);
            SubstitutionVisitor.MutableRel newProject2 = SubstitutionVisitor.MutableRels.strip(newProject);
            return call.result(newProject2);
        }

        @Override
        protected SubstitutionVisitor.UnifyRuleCall match(SubstitutionVisitor visitor, SubstitutionVisitor.MutableRel query, SubstitutionVisitor.MutableRel target) {
            assert (query instanceof SubstitutionVisitor.MutableFilter && target instanceof SubstitutionVisitor.MutableProject);
            if (this.queryOperand.matches(visitor, query) && this.targetOperand.matches(visitor, target) && visitor.isWeaker(query, ((SubstitutionVisitor.MutableProject)target).getInput())) {
                RexNode newCondition;
                SubstitutionVisitor.MutableFilter filter = (SubstitutionVisitor.MutableFilter)query;
                try {
                    newCondition = MaterializedViewSubstitutionVisitor.transformRex(filter.getCondition(), (List<RelDataTypeField>)filter.getInput().getRowType().getFieldList(), (List<RelDataTypeField>)target.getRowType().getFieldList());
                }
                catch (SubstitutionVisitor.MatchFailed e) {
                    return null;
                }
                SubstitutionVisitor.MutableFilter newFilter = SubstitutionVisitor.MutableFilter.of(target, newCondition);
                SubstitutionVisitor substitutionVisitor = visitor;
                substitutionVisitor.getClass();
                return new SubstitutionVisitor.UnifyRuleCall(substitutionVisitor, this, query, newFilter, this.copy(visitor.slots, this.slotCount));
            }
            return null;
        }
    }

    private static class FilterToFilterUnifyRule1
    extends SubstitutionVisitor.AbstractUnifyRule {
        public static final FilterToFilterUnifyRule1 INSTANCE = new FilterToFilterUnifyRule1();

        private FilterToFilterUnifyRule1() {
            super(FilterToFilterUnifyRule1.operand(SubstitutionVisitor.MutableFilter.class, FilterToFilterUnifyRule1.query(0)), FilterToFilterUnifyRule1.operand(SubstitutionVisitor.MutableFilter.class, FilterToFilterUnifyRule1.target(0)), 1);
        }

        @Override
        public SubstitutionVisitor.UnifyResult apply(SubstitutionVisitor.UnifyRuleCall call) {
            SubstitutionVisitor.MutableFilter query = (SubstitutionVisitor.MutableFilter)call.query;
            SubstitutionVisitor.MutableFilter target = (SubstitutionVisitor.MutableFilter)call.target;
            SubstitutionVisitor.MutableFilter newFilter = SubstitutionVisitor.MutableFilter.of(target, query.getCondition());
            return call.result(newFilter);
        }

        @Override
        protected SubstitutionVisitor.UnifyRuleCall match(SubstitutionVisitor visitor, SubstitutionVisitor.MutableRel query, SubstitutionVisitor.MutableRel target) {
            if (this.queryOperand.matches(visitor, query) && this.targetOperand.matches(visitor, target) && visitor.isWeaker(query, target)) {
                SubstitutionVisitor substitutionVisitor = visitor;
                substitutionVisitor.getClass();
                return new SubstitutionVisitor.UnifyRuleCall(substitutionVisitor, this, query, target, this.copy(visitor.slots, this.slotCount));
            }
            return null;
        }
    }

    private static class ProjectToProjectUnifyRule1
    extends SubstitutionVisitor.AbstractUnifyRule {
        public static final ProjectToProjectUnifyRule1 INSTANCE = new ProjectToProjectUnifyRule1();

        private ProjectToProjectUnifyRule1() {
            super(ProjectToProjectUnifyRule1.operand(SubstitutionVisitor.MutableProject.class, ProjectToProjectUnifyRule1.query(0)), ProjectToProjectUnifyRule1.operand(SubstitutionVisitor.MutableProject.class, ProjectToProjectUnifyRule1.target(0)), 1);
        }

        @Override
        protected SubstitutionVisitor.UnifyResult apply(SubstitutionVisitor.UnifyRuleCall call) {
            List newProjects;
            SubstitutionVisitor.MutableProject query = (SubstitutionVisitor.MutableProject)call.query;
            List oldFieldList = query.getInput().getRowType().getFieldList();
            List newFieldList = call.target.getRowType().getFieldList();
            try {
                newProjects = MaterializedViewSubstitutionVisitor.transformRex(query.getProjects(), (List<RelDataTypeField>)oldFieldList, (List<RelDataTypeField>)newFieldList);
            }
            catch (SubstitutionVisitor.MatchFailed e) {
                return null;
            }
            SubstitutionVisitor.MutableProject newProject = SubstitutionVisitor.MutableProject.of(query.getRowType(), call.target, newProjects);
            SubstitutionVisitor.MutableRel newProject2 = SubstitutionVisitor.MutableRels.strip(newProject);
            return call.result(newProject2);
        }

        @Override
        protected SubstitutionVisitor.UnifyRuleCall match(SubstitutionVisitor visitor, SubstitutionVisitor.MutableRel query, SubstitutionVisitor.MutableRel target) {
            assert (query instanceof SubstitutionVisitor.MutableProject && target instanceof SubstitutionVisitor.MutableProject);
            if (this.queryOperand.matches(visitor, query)) {
                SubstitutionVisitor.MutableProject queryProject;
                if (this.targetOperand.matches(visitor, target)) {
                    return null;
                }
                if (this.targetOperand.isWeaker(visitor, target) && (queryProject = (SubstitutionVisitor.MutableProject)query).getInput() instanceof SubstitutionVisitor.MutableFilter) {
                    RexNode newCondition;
                    SubstitutionVisitor.MutableFilter innerFilter = (SubstitutionVisitor.MutableFilter)queryProject.getInput();
                    try {
                        newCondition = MaterializedViewSubstitutionVisitor.transformRex(innerFilter.getCondition(), (List<RelDataTypeField>)innerFilter.getInput().getRowType().getFieldList(), (List<RelDataTypeField>)target.getRowType().getFieldList());
                    }
                    catch (SubstitutionVisitor.MatchFailed e) {
                        return null;
                    }
                    SubstitutionVisitor.MutableFilter newFilter = SubstitutionVisitor.MutableFilter.of(target, newCondition);
                    SubstitutionVisitor substitutionVisitor = visitor;
                    substitutionVisitor.getClass();
                    return new SubstitutionVisitor.UnifyRuleCall(substitutionVisitor, this, query, newFilter, this.copy(visitor.slots, this.slotCount));
                }
            }
            return null;
        }
    }
}

