/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import io.prestosql.hive.$internal.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.HiveOpConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveGBOpConvUtil {
    private static HIVEGBPHYSICALMODE getAggOPMode(HiveConf hc, GBInfo gbInfo) {
        HIVEGBPHYSICALMODE gbPhysicalPipelineMode = HIVEGBPHYSICALMODE.MAP_SIDE_GB_NO_SKEW_NO_ADD_MR_JOB;
        gbPhysicalPipelineMode = hc.getBoolVar(HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE) ? (!hc.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) ? (!gbInfo.grpSetRqrAdditionalMRJob ? HIVEGBPHYSICALMODE.MAP_SIDE_GB_NO_SKEW_NO_ADD_MR_JOB : HIVEGBPHYSICALMODE.MAP_SIDE_GB_NO_SKEW_ADD_MR_JOB) : (gbInfo.containsDistinctAggr || !gbInfo.gbKeys.isEmpty() ? HIVEGBPHYSICALMODE.MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT : HIVEGBPHYSICALMODE.MAP_SIDE_GB_SKEW_GBKEYS_AND_DIST_UDAF_NOT_PRESENT)) : (!hc.getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW) ? HIVEGBPHYSICALMODE.NO_MAP_SIDE_GB_NO_SKEW : HIVEGBPHYSICALMODE.NO_MAP_SIDE_GB_SKEW);
        return gbPhysicalPipelineMode;
    }

    private static GBInfo getGBInfo(HiveAggregate aggRel, HiveOpConverter.OpAttr inputOpAf, HiveConf hc) throws SemanticException {
        GBInfo gbInfo = new GBInfo();
        gbInfo.outputColNames.addAll(aggRel.getRowType().getFieldNames());
        RelNode aggInputRel = aggRel.getInput();
        ExprNodeConverter exprConv = new ExprNodeConverter(inputOpAf.tabAlias, aggInputRel.getRowType(), new HashSet<Integer>(), aggRel.getCluster().getTypeFactory(), true);
        Iterator iterator = aggRel.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            RexInputRef iRef = new RexInputRef(i, ((RelDataTypeField)aggInputRel.getRowType().getFieldList().get(i)).getType());
            ExprNodeDesc tmpExprNodeDesc = (ExprNodeDesc)iRef.accept((RexVisitor)exprConv);
            gbInfo.gbKeys.add(tmpExprNodeDesc);
            gbInfo.gbKeyColNamesInInput.add(aggInputRel.getRowType().getFieldNames().get(i));
            gbInfo.gbKeyTypes.add(tmpExprNodeDesc.getTypeInfo());
        }
        if (aggRel.indicator) {
            ImmutableList lstGrpSet = aggRel.getGroupSets();
            int bitmap = 0;
            for (ImmutableBitSet grpSet : lstGrpSet) {
                bitmap = 0;
                for (Integer bitIdx : grpSet.asList()) {
                    bitmap = SemanticAnalyzer.setBit(bitmap, bitIdx);
                }
                gbInfo.grpSets.add(bitmap);
            }
            Collections.sort(gbInfo.grpSets);
            gbInfo.grpSetRqrAdditionalMRJob = gbInfo.grpSets.size() > hc.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY);
            if (!aggRel.getAggCallList().isEmpty() && ((AggregateCall)aggRel.getAggCallList().get(aggRel.getAggCallList().size() - 1)).getAggregation() == HiveGroupingID.INSTANCE) {
                gbInfo.grpIdFunctionNeeded = true;
            }
        }
        HashSet distinctRefs = new HashSet();
        HashMap distParamInRefsToOutputPos = new HashMap();
        for (AggregateCall aggCall : aggRel.getAggCallList()) {
            if (aggCall.getAggregation() == HiveGroupingID.INSTANCE || !aggCall.isDistinct()) continue;
            ArrayList<Integer> argLst = new ArrayList<Integer>(aggCall.getArgList());
            List<String> argNames = HiveCalciteUtil.getFieldNames(argLst, aggInputRel);
            for (int i = 0; i < argLst.size(); ++i) {
                if (distinctRefs.contains(argLst.get(i))) continue;
                distinctRefs.add(argLst.get(i));
                ExprNodeDesc distinctExpr = HiveCalciteUtil.getExprNode((Integer)argLst.get(i), aggInputRel, exprConv);
                if (ExprNodeDescUtils.indexOf(distinctExpr, gbInfo.gbKeys) >= 0) continue;
                distParamInRefsToOutputPos.put(argLst.get(i), gbInfo.distExprNodes.size());
                gbInfo.distExprNodes.add(distinctExpr);
                gbInfo.distExprNames.add(argNames.get(i));
                gbInfo.distExprTypes.add(distinctExpr.getTypeInfo());
            }
        }
        HashSet deDupedNonDistIrefsSet = new HashSet();
        for (AggregateCall aggCall : aggRel.getAggCallList()) {
            if (aggCall.getAggregation() == HiveGroupingID.INSTANCE) continue;
            UDAFAttrs udafAttrs = new UDAFAttrs();
            List<ExprNodeDesc> argExps = HiveCalciteUtil.getExprNodes(aggCall.getArgList(), aggInputRel, inputOpAf.tabAlias);
            udafAttrs.udafParams.addAll(argExps);
            udafAttrs.udafName = aggCall.getAggregation().getName();
            udafAttrs.argList = aggCall.getArgList();
            udafAttrs.isDistinctUDAF = aggCall.isDistinct();
            ArrayList argLst = new ArrayList(aggCall.getArgList());
            ArrayList<Integer> distColIndicesOfUDAF = new ArrayList<Integer>();
            ArrayList distUDAFParamsIndxInDistExprs = new ArrayList();
            for (int i = 0; i < argLst.size(); ++i) {
                if (udafAttrs.isDistinctUDAF) {
                    ExprNodeDesc argExpr = argExps.get(i);
                    Integer found = ExprNodeDescUtils.indexOf(argExpr, gbInfo.gbKeys);
                    distColIndicesOfUDAF.add(found < 0 ? (Integer)distParamInRefsToOutputPos.get(argLst.get(i)) + gbInfo.gbKeys.size() + (gbInfo.grpSets.size() > 0 ? 1 : 0) : found);
                    distUDAFParamsIndxInDistExprs.add(distParamInRefsToOutputPos.get(argLst.get(i)));
                    continue;
                }
                if (distParamInRefsToOutputPos.containsKey(argLst.get(i)) || deDupedNonDistIrefsSet.contains(argLst.get(i))) continue;
                deDupedNonDistIrefsSet.add(argLst.get(i));
                gbInfo.deDupedNonDistIrefs.add(udafAttrs.udafParams.get(i));
            }
            if (udafAttrs.isDistinctUDAF) {
                gbInfo.containsDistinctAggr = true;
                udafAttrs.udafParamsIndxInGBInfoDistExprs = distUDAFParamsIndxInDistExprs;
                gbInfo.distColIndices.add(distColIndicesOfUDAF);
            }
            udafAttrs.udafEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(udafAttrs.udafName, new ArrayList<ExprNodeDesc>(udafAttrs.udafParams), new ASTNode(), udafAttrs.isDistinctUDAF, udafAttrs.udafParams.size() == 0 && "count".equalsIgnoreCase(udafAttrs.udafName));
            gbInfo.udafAttrs.add(udafAttrs);
        }
        gbInfo.groupByMemoryUsage = HiveConf.getFloatVar(hc, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
        gbInfo.memoryThreshold = HiveConf.getFloatVar(hc, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
        gbInfo.gbPhysicalPipelineMode = HiveGBOpConvUtil.getAggOPMode(hc, gbInfo);
        return gbInfo;
    }

    static HiveOpConverter.OpAttr translateGB(HiveOpConverter.OpAttr inputOpAf, HiveAggregate aggRel, HiveConf hc) throws SemanticException {
        HiveOpConverter.OpAttr translatedGBOpAttr = null;
        GBInfo gbInfo = HiveGBOpConvUtil.getGBInfo(aggRel, inputOpAf, hc);
        switch (gbInfo.gbPhysicalPipelineMode) {
            case MAP_SIDE_GB_NO_SKEW_NO_ADD_MR_JOB: {
                translatedGBOpAttr = HiveGBOpConvUtil.genMapSideGBNoSkewNoAddMRJob(inputOpAf, aggRel, gbInfo);
                break;
            }
            case MAP_SIDE_GB_NO_SKEW_ADD_MR_JOB: {
                translatedGBOpAttr = HiveGBOpConvUtil.genMapSideGBNoSkewAddMRJob(inputOpAf, aggRel, gbInfo);
                break;
            }
            case MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT: {
                translatedGBOpAttr = HiveGBOpConvUtil.genMapSideGBSkewGBKeysOrDistUDAFPresent(inputOpAf, aggRel, gbInfo);
                break;
            }
            case MAP_SIDE_GB_SKEW_GBKEYS_AND_DIST_UDAF_NOT_PRESENT: {
                translatedGBOpAttr = HiveGBOpConvUtil.genMapSideGBSkewGBKeysAndDistUDAFNotPresent(inputOpAf, aggRel, gbInfo);
                break;
            }
            case NO_MAP_SIDE_GB_NO_SKEW: {
                translatedGBOpAttr = HiveGBOpConvUtil.genNoMapSideGBNoSkew(inputOpAf, aggRel, gbInfo);
                break;
            }
            case NO_MAP_SIDE_GB_SKEW: {
                translatedGBOpAttr = HiveGBOpConvUtil.genNoMapSideGBSkew(inputOpAf, aggRel, gbInfo);
            }
        }
        return translatedGBOpAttr;
    }

    private static HiveOpConverter.OpAttr genMapSideGBNoSkewNoAddMRJob(HiveOpConverter.OpAttr inputOpAf, HiveAggregate aggRel, GBInfo gbInfo) throws SemanticException {
        HiveOpConverter.OpAttr mapSideGB = null;
        HiveOpConverter.OpAttr mapSideRS = null;
        HiveOpConverter.OpAttr reduceSideGB = null;
        mapSideGB = HiveGBOpConvUtil.genMapSideGB(inputOpAf, gbInfo);
        mapSideRS = HiveGBOpConvUtil.genMapSideGBRS(mapSideGB, gbInfo);
        reduceSideGB = HiveGBOpConvUtil.genReduceSideGB1(mapSideRS, gbInfo, false, false, GroupByDesc.Mode.MERGEPARTIAL);
        return reduceSideGB;
    }

    private static HiveOpConverter.OpAttr genGBRSGBRSGBOpPipeLine(HiveOpConverter.OpAttr inputOpAf, HiveAggregate aggRel, GBInfo gbInfo) throws SemanticException {
        HiveOpConverter.OpAttr mapSideGB = null;
        HiveOpConverter.OpAttr mapSideRS = null;
        HiveOpConverter.OpAttr reduceSideGB1 = null;
        HiveOpConverter.OpAttr reduceSideRS = null;
        HiveOpConverter.OpAttr reduceSideGB2 = null;
        mapSideGB = HiveGBOpConvUtil.genMapSideGB(inputOpAf, gbInfo);
        mapSideRS = HiveGBOpConvUtil.genMapSideGBRS(mapSideGB, gbInfo);
        boolean computeGrpSet = gbInfo.gbPhysicalPipelineMode != HIVEGBPHYSICALMODE.MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT;
        reduceSideGB1 = HiveGBOpConvUtil.genReduceSideGB1(mapSideRS, gbInfo, computeGrpSet, false, GroupByDesc.Mode.PARTIALS);
        reduceSideRS = HiveGBOpConvUtil.genReduceGBRS(reduceSideGB1, gbInfo);
        reduceSideGB2 = HiveGBOpConvUtil.genReduceSideGB2(reduceSideRS, gbInfo);
        return reduceSideGB2;
    }

    private static HiveOpConverter.OpAttr genMapSideGBNoSkewAddMRJob(HiveOpConverter.OpAttr inputOpAf, HiveAggregate aggRel, GBInfo gbInfo) throws SemanticException {
        if (gbInfo.containsDistinctAggr) {
            String errorMsg = "The number of rows per input row due to grouping sets is " + gbInfo.grpSets.size();
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_DISTINCTS.getMsg(errorMsg));
        }
        return HiveGBOpConvUtil.genGBRSGBRSGBOpPipeLine(inputOpAf, aggRel, gbInfo);
    }

    private static HiveOpConverter.OpAttr genMapSideGBSkewGBKeysOrDistUDAFPresent(HiveOpConverter.OpAttr inputOpAf, HiveAggregate aggRel, GBInfo gbInfo) throws SemanticException {
        if (gbInfo.grpSetRqrAdditionalMRJob) {
            String errorMsg = "The number of rows per input row due to grouping sets is " + gbInfo.grpSets.size();
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW.getMsg(errorMsg));
        }
        return HiveGBOpConvUtil.genGBRSGBRSGBOpPipeLine(inputOpAf, aggRel, gbInfo);
    }

    private static HiveOpConverter.OpAttr genMapSideGBSkewGBKeysAndDistUDAFNotPresent(HiveOpConverter.OpAttr inputOpAf, HiveAggregate aggRel, GBInfo gbInfo) throws SemanticException {
        HiveOpConverter.OpAttr mapSideGB = null;
        HiveOpConverter.OpAttr mapSideRS = null;
        HiveOpConverter.OpAttr reduceSideGB2 = null;
        if (gbInfo.grpSetRqrAdditionalMRJob) {
            String errorMsg = "The number of rows per input row due to grouping sets is " + gbInfo.grpSets.size();
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW.getMsg(errorMsg));
        }
        mapSideGB = HiveGBOpConvUtil.genMapSideGB(inputOpAf, gbInfo);
        mapSideRS = HiveGBOpConvUtil.genMapSideGBRS(mapSideGB, gbInfo);
        reduceSideGB2 = HiveGBOpConvUtil.genReduceSideGB2(mapSideRS, gbInfo);
        return reduceSideGB2;
    }

    private static HiveOpConverter.OpAttr genNoMapSideGBNoSkew(HiveOpConverter.OpAttr inputOpAf, HiveAggregate aggRel, GBInfo gbInfo) throws SemanticException {
        HiveOpConverter.OpAttr mapSideRS = null;
        HiveOpConverter.OpAttr reduceSideGB1NoMapGB = null;
        mapSideRS = HiveGBOpConvUtil.genMapSideRS(inputOpAf, gbInfo);
        reduceSideGB1NoMapGB = HiveGBOpConvUtil.genReduceSideGB1NoMapGB(mapSideRS, gbInfo, GroupByDesc.Mode.COMPLETE);
        return reduceSideGB1NoMapGB;
    }

    private static HiveOpConverter.OpAttr genNoMapSideGBSkew(HiveOpConverter.OpAttr inputOpAf, HiveAggregate aggRel, GBInfo gbInfo) throws SemanticException {
        HiveOpConverter.OpAttr mapSideRS = null;
        HiveOpConverter.OpAttr reduceSideGB1NoMapGB = null;
        HiveOpConverter.OpAttr reduceSideRS = null;
        HiveOpConverter.OpAttr reduceSideGB2 = null;
        mapSideRS = HiveGBOpConvUtil.genMapSideRS(inputOpAf, gbInfo);
        reduceSideGB1NoMapGB = HiveGBOpConvUtil.genReduceSideGB1NoMapGB(mapSideRS, gbInfo, GroupByDesc.Mode.PARTIAL1);
        reduceSideRS = HiveGBOpConvUtil.genReduceGBRS(reduceSideGB1NoMapGB, gbInfo);
        reduceSideGB2 = HiveGBOpConvUtil.genReduceSideGB2(reduceSideRS, gbInfo);
        return reduceSideGB2;
    }

    private static int getParallelismForReduceSideRS(GBInfo gbInfo) {
        int degreeOfParallelism = 0;
        switch (gbInfo.gbPhysicalPipelineMode) {
            case MAP_SIDE_GB_NO_SKEW_ADD_MR_JOB: 
            case MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT: 
            case NO_MAP_SIDE_GB_SKEW: {
                if (gbInfo.gbKeys.isEmpty()) {
                    degreeOfParallelism = 1;
                    break;
                }
                degreeOfParallelism = -1;
                break;
            }
            default: {
                throw new RuntimeException("Unable to determine Reducer Parallelism - Invalid Physical Mode: " + (Object)((Object)gbInfo.gbPhysicalPipelineMode));
            }
        }
        return degreeOfParallelism;
    }

    private static int getParallelismForMapSideRS(GBInfo gbInfo) {
        int degreeOfParallelism = 0;
        switch (gbInfo.gbPhysicalPipelineMode) {
            case MAP_SIDE_GB_NO_SKEW_NO_ADD_MR_JOB: 
            case MAP_SIDE_GB_NO_SKEW_ADD_MR_JOB: 
            case NO_MAP_SIDE_GB_NO_SKEW: {
                if (gbInfo.gbKeys.isEmpty()) {
                    degreeOfParallelism = 1;
                    break;
                }
                degreeOfParallelism = -1;
                break;
            }
            case MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT: 
            case NO_MAP_SIDE_GB_SKEW: {
                degreeOfParallelism = -1;
                break;
            }
            case MAP_SIDE_GB_SKEW_GBKEYS_AND_DIST_UDAF_NOT_PRESENT: {
                degreeOfParallelism = 1;
                break;
            }
            default: {
                throw new RuntimeException("Unable to determine Reducer Parallelism - Invalid Physical Mode: " + (Object)((Object)gbInfo.gbPhysicalPipelineMode));
            }
        }
        return degreeOfParallelism;
    }

    private static int getNumPartFieldsForReduceSideRS(GBInfo gbInfo) {
        int numPartFields = 0;
        switch (gbInfo.gbPhysicalPipelineMode) {
            case MAP_SIDE_GB_NO_SKEW_ADD_MR_JOB: {
                numPartFields = gbInfo.gbKeys.size() + 1;
                break;
            }
            case MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT: 
            case NO_MAP_SIDE_GB_SKEW: {
                numPartFields = gbInfo.gbKeys.size();
                break;
            }
            default: {
                throw new RuntimeException("Unable to determine Number of Partition Fields - Invalid Physical Mode: " + (Object)((Object)gbInfo.gbPhysicalPipelineMode));
            }
        }
        return numPartFields;
    }

    private static int getNumPartFieldsForMapSideRS(GBInfo gbInfo) {
        int numPartFields = 0;
        switch (gbInfo.gbPhysicalPipelineMode) {
            case MAP_SIDE_GB_NO_SKEW_NO_ADD_MR_JOB: 
            case MAP_SIDE_GB_NO_SKEW_ADD_MR_JOB: 
            case MAP_SIDE_GB_SKEW_GBKEYS_AND_DIST_UDAF_NOT_PRESENT: 
            case NO_MAP_SIDE_GB_NO_SKEW: {
                numPartFields += gbInfo.gbKeys.size();
                break;
            }
            case MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT: 
            case NO_MAP_SIDE_GB_SKEW: {
                if (gbInfo.containsDistinctAggr) {
                    numPartFields = Integer.MAX_VALUE;
                    break;
                }
                numPartFields = -1;
                break;
            }
            default: {
                throw new RuntimeException("Unable to determine Number of Partition Fields - Invalid Physical Mode: " + (Object)((Object)gbInfo.gbPhysicalPipelineMode));
            }
        }
        return numPartFields;
    }

    private static boolean inclGrpSetInReduceSide(GBInfo gbInfo) {
        boolean inclGrpSet = false;
        if (gbInfo.grpSets.size() > 0 && (gbInfo.gbPhysicalPipelineMode == HIVEGBPHYSICALMODE.MAP_SIDE_GB_NO_SKEW_ADD_MR_JOB || gbInfo.gbPhysicalPipelineMode == HIVEGBPHYSICALMODE.MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT)) {
            inclGrpSet = true;
        }
        return inclGrpSet;
    }

    private static boolean inclGrpSetInMapSide(GBInfo gbInfo) {
        boolean inclGrpSet = false;
        if (gbInfo.grpSets.size() > 0 && (gbInfo.gbPhysicalPipelineMode == HIVEGBPHYSICALMODE.MAP_SIDE_GB_NO_SKEW_NO_ADD_MR_JOB || gbInfo.gbPhysicalPipelineMode == HIVEGBPHYSICALMODE.MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT)) {
            inclGrpSet = true;
        }
        return inclGrpSet;
    }

    private static HiveOpConverter.OpAttr genReduceGBRS(HiveOpConverter.OpAttr inputOpAf, GBInfo gbInfo) throws SemanticException {
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<ColumnInfo> colInfoLst = new ArrayList<ColumnInfo>();
        GroupByOperator reduceSideGB1 = (GroupByOperator)inputOpAf.inputs.get(0);
        ArrayList<ColumnInfo> gb1ColInfoLst = reduceSideGB1.getSchema().getSignature();
        ArrayList<ExprNodeDesc> reduceKeys = HiveGBOpConvUtil.getReduceKeysForRS(reduceSideGB1, 0, gbInfo.gbKeys.size() - 1, outputColumnNames, false, colInfoLst, colExprMap, true, true);
        if (HiveGBOpConvUtil.inclGrpSetInReduceSide(gbInfo)) {
            HiveGBOpConvUtil.addGrpSetCol(false, ((ColumnInfo)gb1ColInfoLst.get(reduceKeys.size())).getInternalName(), true, reduceKeys, outputColumnNames, colInfoLst, colExprMap);
        }
        ArrayList<ExprNodeDesc> reduceValues = HiveGBOpConvUtil.getValueKeysForRS(reduceSideGB1, ((GroupByDesc)reduceSideGB1.getConf()).getKeys().size(), outputColumnNames, colInfoLst, colExprMap, true, true);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, true, -1, HiveGBOpConvUtil.getNumPartFieldsForReduceSideRS(gbInfo), HiveGBOpConvUtil.getParallelismForReduceSideRS(gbInfo), AcidUtils.Operation.NOT_ACID), new RowSchema(colInfoLst), (Operator)reduceSideGB1, new Operator[0]);
        rsOp.setColumnExprMap(colExprMap);
        return new HiveOpConverter.OpAttr("", new HashSet<Integer>(), rsOp);
    }

    private static HiveOpConverter.OpAttr genMapSideGBRS(HiveOpConverter.OpAttr inputOpAf, GBInfo gbInfo) throws SemanticException {
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
        ArrayList<String> outputValueColumnNames = new ArrayList<String>();
        ArrayList<ColumnInfo> colInfoLst = new ArrayList<ColumnInfo>();
        GroupByOperator mapGB = (GroupByOperator)inputOpAf.inputs.get(0);
        ArrayList<ExprNodeDesc> reduceKeys = HiveGBOpConvUtil.getReduceKeysForRS(mapGB, 0, gbInfo.gbKeys.size() - 1, outputKeyColumnNames, false, colInfoLst, colExprMap, false, false);
        int keyLength = reduceKeys.size();
        if (HiveGBOpConvUtil.inclGrpSetInMapSide(gbInfo)) {
            HiveGBOpConvUtil.addGrpSetCol(false, SemanticAnalyzer.getColumnInternalName(reduceKeys.size()), true, reduceKeys, outputKeyColumnNames, colInfoLst, colExprMap);
            ++keyLength;
        }
        if (((GroupByDesc)mapGB.getConf()).getKeys().size() > reduceKeys.size()) {
            reduceKeys.addAll(HiveGBOpConvUtil.getReduceKeysForRS(mapGB, reduceKeys.size(), ((GroupByDesc)mapGB.getConf()).getKeys().size() - 1, outputKeyColumnNames, true, colInfoLst, colExprMap, false, false));
        } else if (!gbInfo.distColIndices.isEmpty()) {
            outputKeyColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size()));
        }
        ArrayList<ExprNodeDesc> reduceValues = HiveGBOpConvUtil.getValueKeysForRS(mapGB, ((GroupByDesc)mapGB.getConf()).getKeys().size(), outputValueColumnNames, colInfoLst, colExprMap, false, false);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, keyLength, reduceValues, gbInfo.distColIndices, outputKeyColumnNames, outputValueColumnNames, true, -1, HiveGBOpConvUtil.getNumPartFieldsForMapSideRS(gbInfo), HiveGBOpConvUtil.getParallelismForMapSideRS(gbInfo), AcidUtils.Operation.NOT_ACID), new RowSchema(colInfoLst), (Operator)mapGB, new Operator[0]);
        rsOp.setColumnExprMap(colExprMap);
        return new HiveOpConverter.OpAttr("", new HashSet<Integer>(), rsOp);
    }

    private static HiveOpConverter.OpAttr genMapSideRS(HiveOpConverter.OpAttr inputOpAf, GBInfo gbInfo) throws SemanticException {
        String field;
        String outputColName;
        int i;
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
        ArrayList<String> outputValueColumnNames = new ArrayList<String>();
        ArrayList<ColumnInfo> colInfoLst = new ArrayList<ColumnInfo>();
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        for (int i2 = 0; i2 < gbInfo.gbKeys.size(); ++i2) {
            reduceKeys.add((ExprNodeDesc)gbInfo.gbKeys.get(i2));
            String colOutputName = SemanticAnalyzer.getColumnInternalName(i2);
            outputKeyColumnNames.add(colOutputName);
            colInfoLst.add(new ColumnInfo(Utilities.ReduceField.KEY.toString() + "." + colOutputName, (TypeInfo)gbInfo.gbKeyTypes.get(i2), "", false));
            colExprMap.put(colOutputName, (ExprNodeDesc)gbInfo.gbKeys.get(i2));
        }
        int keyLength = reduceKeys.size();
        if (gbInfo.containsDistinctAggr) {
            String udafName = SemanticAnalyzer.getColumnInternalName(reduceKeys.size());
            outputKeyColumnNames.add(udafName);
            for (i = 0; i < gbInfo.distExprNodes.size(); ++i) {
                reduceKeys.add((ExprNodeDesc)gbInfo.distExprNodes.get(i));
                outputColName = SemanticAnalyzer.getColumnInternalName(0);
                field = Utilities.ReduceField.KEY.toString() + "." + udafName + ":" + i + "." + outputColName;
                ColumnInfo colInfo = new ColumnInfo(field, ((ExprNodeDesc)gbInfo.distExprNodes.get(i)).getTypeInfo(), null, false);
                colInfoLst.add(colInfo);
                colExprMap.put(field, (ExprNodeDesc)gbInfo.distExprNodes.get(i));
            }
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        for (i = 0; i < gbInfo.deDupedNonDistIrefs.size(); ++i) {
            reduceValues.add((ExprNodeDesc)gbInfo.deDupedNonDistIrefs.get(i));
            outputColName = SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
            outputValueColumnNames.add(outputColName);
            field = Utilities.ReduceField.VALUE.toString() + "." + outputColName;
            colInfoLst.add(new ColumnInfo(field, reduceValues.get(reduceValues.size() - 1).getTypeInfo(), null, false));
            colExprMap.put(field, reduceValues.get(reduceValues.size() - 1));
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, keyLength, reduceValues, gbInfo.distColIndices, outputKeyColumnNames, outputValueColumnNames, true, -1, HiveGBOpConvUtil.getNumPartFieldsForMapSideRS(gbInfo), HiveGBOpConvUtil.getParallelismForMapSideRS(gbInfo), AcidUtils.Operation.NOT_ACID), new RowSchema(colInfoLst), (Operator)inputOpAf.inputs.get(0), new Operator[0]);
        rsOp.setColumnExprMap(colExprMap);
        return new HiveOpConverter.OpAttr("", new HashSet<Integer>(), rsOp);
    }

    private static HiveOpConverter.OpAttr genReduceSideGB2(HiveOpConverter.OpAttr inputOpAf, GBInfo gbInfo) throws SemanticException {
        ArrayList<String> outputColNames = new ArrayList<String>();
        ArrayList<ColumnInfo> colInfoLst = new ArrayList<ColumnInfo>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        String colOutputName = null;
        ReduceSinkOperator rs = (ReduceSinkOperator)inputOpAf.inputs.get(0);
        ArrayList<ColumnInfo> rsColInfoLst = rs.getSchema().getSignature();
        ArrayList<ExprNodeDesc> gbKeys = ExprNodeDescUtils.genExprNodeDesc(rs, 0, gbInfo.gbKeys.size() - 1, false, false);
        for (int i = 0; i < gbInfo.gbKeys.size(); ++i) {
            ColumnInfo ci = (ColumnInfo)rsColInfoLst.get(i);
            colOutputName = (String)gbInfo.outputColNames.get(i);
            outputColNames.add(colOutputName);
            colInfoLst.add(new ColumnInfo(colOutputName, ci.getType(), "", false));
            colExprMap.put(colOutputName, gbKeys.get(i));
        }
        int groupingSetsPosition = -1;
        if (HiveGBOpConvUtil.inclGrpSetInReduceSide(gbInfo) && gbInfo.grpIdFunctionNeeded) {
            groupingSetsPosition = gbKeys.size();
            ExprNodeColumnDesc grpSetColExpr = new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, ((ColumnInfo)rsColInfoLst.get(groupingSetsPosition)).getInternalName(), null, false);
            gbKeys.add(grpSetColExpr);
            colOutputName = (String)gbInfo.outputColNames.get(gbInfo.outputColNames.size() - 1);
            outputColNames.add(colOutputName);
            colInfoLst.add(new ColumnInfo(colOutputName, TypeInfoFactory.stringTypeInfo, null, true));
            colExprMap.put(colOutputName, grpSetColExpr);
        }
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        int udafStartPosInGBInfOutputColNames = gbInfo.grpSets.isEmpty() ? gbInfo.gbKeys.size() : gbInfo.gbKeys.size() * 2;
        int udafStartPosInInputRS = gbInfo.grpSets.isEmpty() ? gbInfo.gbKeys.size() : gbInfo.gbKeys.size() + 1;
        for (int i = 0; i < gbInfo.udafAttrs.size(); ++i) {
            UDAFAttrs udafAttr = (UDAFAttrs)gbInfo.udafAttrs.get(i);
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            aggParameters.add(new ExprNodeColumnDesc((ColumnInfo)rsColInfoLst.get(udafStartPosInInputRS + i)));
            colOutputName = (String)gbInfo.outputColNames.get(udafStartPosInGBInfOutputColNames + i);
            outputColNames.add(colOutputName);
            GenericUDAFEvaluator.Mode udafMode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.FINAL, udafAttr.isDistinctUDAF);
            SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(udafAttr.udafEvaluator, udafMode, aggParameters);
            aggregations.add(new AggregationDesc(udafAttr.udafName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, false, udafMode));
            colInfoLst.add(new ColumnInfo(colOutputName, udaf.returnType, "", false));
        }
        Operator<GroupByDesc> rsGBOp2 = OperatorFactory.getAndMakeChild(new GroupByDesc(GroupByDesc.Mode.FINAL, outputColNames, gbKeys, aggregations, false, gbInfo.groupByMemoryUsage, gbInfo.memoryThreshold, null, false, groupingSetsPosition, gbInfo.containsDistinctAggr), new RowSchema(colInfoLst), (Operator)rs, new Operator[0]);
        rsGBOp2.setColumnExprMap(colExprMap);
        return new HiveOpConverter.OpAttr("", new HashSet<Integer>(), rsGBOp2);
    }

    private static HiveOpConverter.OpAttr genReduceSideGB1(HiveOpConverter.OpAttr inputOpAf, GBInfo gbInfo, boolean computeGrpSet, boolean propagateConstInDistinctUDAF, GroupByDesc.Mode gbMode) throws SemanticException {
        ArrayList<String> outputColNames = new ArrayList<String>();
        ArrayList<ColumnInfo> colInfoLst = new ArrayList<ColumnInfo>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        String colOutputName = null;
        ReduceSinkOperator rs = (ReduceSinkOperator)inputOpAf.inputs.get(0);
        ArrayList<ColumnInfo> rsColInfoLst = rs.getSchema().getSignature();
        boolean finalGB = gbInfo.gbPhysicalPipelineMode == HIVEGBPHYSICALMODE.MAP_SIDE_GB_NO_SKEW_NO_ADD_MR_JOB;
        ArrayList<ExprNodeDesc> gbKeys = ExprNodeDescUtils.genExprNodeDesc(rs, 0, gbInfo.gbKeys.size() - 1, false, false);
        for (int i = 0; i < gbInfo.gbKeys.size(); ++i) {
            ColumnInfo ci = (ColumnInfo)rsColInfoLst.get(i);
            colOutputName = finalGB ? (String)gbInfo.outputColNames.get(i) : SemanticAnalyzer.getColumnInternalName(i);
            outputColNames.add(colOutputName);
            colInfoLst.add(new ColumnInfo(colOutputName, ci.getType(), "", false));
            colExprMap.put(colOutputName, gbKeys.get(i));
        }
        int groupingSetsColPosition = -1;
        if (!finalGB && gbInfo.grpSets.size() > 0 || finalGB && gbInfo.grpIdFunctionNeeded) {
            groupingSetsColPosition = gbInfo.gbKeys.size();
            if (computeGrpSet) {
                gbKeys.add(new ExprNodeConstantDesc("0"));
            } else {
                gbKeys.addAll(ExprNodeDescUtils.genExprNodeDesc(rs, groupingSetsColPosition, groupingSetsColPosition, false, true));
            }
            colOutputName = SemanticAnalyzer.getColumnInternalName(groupingSetsColPosition);
            if (finalGB) {
                colOutputName = (String)gbInfo.outputColNames.get(gbInfo.outputColNames.size() - 1);
            }
            outputColNames.add(colOutputName);
            colInfoLst.add(new ColumnInfo(colOutputName, TypeInfoFactory.stringTypeInfo, null, true));
            colExprMap.put(colOutputName, gbKeys.get(groupingSetsColPosition));
        }
        String lastReduceKeyColName = null;
        if (!((ReduceSinkDesc)rs.getConf()).getOutputKeyColumnNames().isEmpty()) {
            lastReduceKeyColName = ((ReduceSinkDesc)rs.getConf()).getOutputKeyColumnNames().get(((ReduceSinkDesc)rs.getConf()).getOutputKeyColumnNames().size() - 1);
        }
        int numDistinctUDFs = 0;
        int distinctStartPosInReduceKeys = gbKeys.size();
        ArrayList<ExprNodeDesc> reduceValues = ((ReduceSinkDesc)rs.getConf()).getValueCols();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        int udafColStartPosInOriginalGB = gbInfo.grpSets.size() > 0 ? gbInfo.gbKeys.size() * 2 : gbInfo.gbKeys.size();
        int udafColStartPosInRS = ((ReduceSinkDesc)rs.getConf()).getKeyCols().size();
        for (int i = 0; i < gbInfo.udafAttrs.size(); ++i) {
            UDAFAttrs udafAttr = (UDAFAttrs)gbInfo.udafAttrs.get(i);
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            if (udafAttr.isDistinctUDAF) {
                for (int j = 0; j < udafAttr.udafParamsIndxInGBInfoDistExprs.size(); ++j) {
                    ExprNodeDesc constantPropDistinctUDAFParam;
                    ColumnInfo rsDistUDAFParamColInfo = (ColumnInfo)rsColInfoLst.get(distinctStartPosInReduceKeys + j);
                    String rsDistUDAFParamName = rsDistUDAFParamColInfo.getInternalName();
                    if (lastReduceKeyColName != null) {
                        rsDistUDAFParamName = Utilities.ReduceField.KEY.name() + "." + lastReduceKeyColName + ":" + numDistinctUDFs + "." + SemanticAnalyzer.getColumnInternalName(j);
                    }
                    ExprNodeDesc distinctUDAFParam = new ExprNodeColumnDesc(rsDistUDAFParamColInfo.getType(), rsDistUDAFParamName, rsDistUDAFParamColInfo.getTabAlias(), rsDistUDAFParamColInfo.getIsVirtualCol());
                    if (propagateConstInDistinctUDAF && (constantPropDistinctUDAFParam = SemanticAnalyzer.isConstantParameterInAggregationParameters(rsDistUDAFParamColInfo.getInternalName(), reduceValues)) != null) {
                        distinctUDAFParam = constantPropDistinctUDAFParam;
                    }
                    aggParameters.add(distinctUDAFParam);
                }
                ++numDistinctUDFs;
            } else {
                aggParameters.add(new ExprNodeColumnDesc((ColumnInfo)rsColInfoLst.get(udafColStartPosInRS + i)));
            }
            GenericUDAFEvaluator.Mode udafMode = SemanticAnalyzer.groupByDescModeToUDAFMode(gbMode, udafAttr.isDistinctUDAF);
            SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(udafAttr.udafEvaluator, udafMode, aggParameters);
            aggregations.add(new AggregationDesc(udafAttr.udafName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, gbMode != GroupByDesc.Mode.FINAL && udafAttr.isDistinctUDAF, udafMode));
            colOutputName = finalGB ? (String)gbInfo.outputColNames.get(udafColStartPosInOriginalGB + i) : SemanticAnalyzer.getColumnInternalName(gbKeys.size() + aggregations.size() - 1);
            colInfoLst.add(new ColumnInfo(colOutputName, udaf.returnType, "", false));
            outputColNames.add(colOutputName);
        }
        boolean includeGrpSetInGBDesc = gbInfo.grpSets.size() > 0 && !finalGB && gbInfo.gbPhysicalPipelineMode != HIVEGBPHYSICALMODE.MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT;
        Operator<GroupByDesc> rsGBOp = OperatorFactory.getAndMakeChild(new GroupByDesc(gbMode, outputColNames, gbKeys, aggregations, gbInfo.groupByMemoryUsage, gbInfo.memoryThreshold, gbInfo.grpSets, includeGrpSetInGBDesc, groupingSetsColPosition, gbInfo.containsDistinctAggr), new RowSchema(colInfoLst), (Operator)rs, new Operator[0]);
        rsGBOp.setColumnExprMap(colExprMap);
        return new HiveOpConverter.OpAttr("", new HashSet<Integer>(), rsGBOp);
    }

    private static HiveOpConverter.OpAttr genReduceSideGB1NoMapGB(HiveOpConverter.OpAttr inputOpAf, GBInfo gbInfo, GroupByDesc.Mode gbMode) throws SemanticException {
        ArrayList<String> outputColNames = new ArrayList<String>();
        ArrayList<ColumnInfo> colInfoLst = new ArrayList<ColumnInfo>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        String colOutputName = null;
        ReduceSinkOperator rs = (ReduceSinkOperator)inputOpAf.inputs.get(0);
        ArrayList<ColumnInfo> rsColInfoLst = rs.getSchema().getSignature();
        boolean useOriginalGBNames = gbInfo.gbPhysicalPipelineMode == HIVEGBPHYSICALMODE.NO_MAP_SIDE_GB_NO_SKEW;
        ArrayList<ExprNodeDesc> gbKeys = ExprNodeDescUtils.genExprNodeDesc(rs, 0, gbInfo.gbKeys.size() - 1, true, false);
        for (int i = 0; i < gbInfo.gbKeys.size(); ++i) {
            ColumnInfo ci = (ColumnInfo)rsColInfoLst.get(i);
            colOutputName = useOriginalGBNames ? (String)gbInfo.outputColNames.get(i) : SemanticAnalyzer.getColumnInternalName(i);
            outputColNames.add(colOutputName);
            colInfoLst.add(new ColumnInfo(colOutputName, ci.getType(), null, false));
            colExprMap.put(colOutputName, gbKeys.get(i));
        }
        String lastReduceKeyColName = null;
        if (!((ReduceSinkDesc)rs.getConf()).getOutputKeyColumnNames().isEmpty()) {
            lastReduceKeyColName = ((ReduceSinkDesc)rs.getConf()).getOutputKeyColumnNames().get(((ReduceSinkDesc)rs.getConf()).getOutputKeyColumnNames().size() - 1);
        }
        int numDistinctUDFs = 0;
        ArrayList<ExprNodeDesc> reduceValues = ((ReduceSinkDesc)rs.getConf()).getValueCols();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        int udafColStartPosInOriginalGB = gbInfo.gbKeys.size();
        ArrayList distinctPositions = new ArrayList();
        TreeMap indexToParameter = new TreeMap();
        for (int i = 0; i < gbInfo.udafAttrs.size(); ++i) {
            UDAFAttrs udafAttr = (UDAFAttrs)gbInfo.udafAttrs.get(i);
            ArrayList<ExprNodeColumnDesc> aggParameters = new ArrayList<ExprNodeColumnDesc>();
            for (int j = 0; j < udafAttr.udafParams.size(); ++j) {
                int argPos = HiveGBOpConvUtil.getColInfoPos((ExprNodeDesc)udafAttr.udafParams.get(j), gbInfo);
                ColumnInfo rsUDAFParamColInfo = (ColumnInfo)rsColInfoLst.get(argPos);
                String rsUDAFParamName = rsUDAFParamColInfo.getInternalName();
                if (udafAttr.isDistinctUDAF && lastReduceKeyColName != null) {
                    rsUDAFParamName = Utilities.ReduceField.KEY.name() + "." + lastReduceKeyColName + ":" + numDistinctUDFs + "." + SemanticAnalyzer.getColumnInternalName(j);
                }
                ExprNodeDesc udafParam = new ExprNodeColumnDesc(rsUDAFParamColInfo.getType(), rsUDAFParamName, rsUDAFParamColInfo.getTabAlias(), rsUDAFParamColInfo.getIsVirtualCol());
                ExprNodeDesc constantPropDistinctUDAFParam = SemanticAnalyzer.isConstantParameterInAggregationParameters(rsUDAFParamColInfo.getInternalName(), reduceValues);
                if (constantPropDistinctUDAFParam != null) {
                    udafParam = constantPropDistinctUDAFParam;
                }
                aggParameters.add((ExprNodeColumnDesc)udafParam);
            }
            indexToParameter.put(i, aggParameters);
            if (!udafAttr.isDistinctUDAF) continue;
            ++numDistinctUDFs;
        }
        Iterator i = indexToParameter.keySet().iterator();
        while (i.hasNext()) {
            int index = (Integer)i.next();
            UDAFAttrs udafAttr = (UDAFAttrs)gbInfo.udafAttrs.get(index);
            GenericUDAFEvaluator.Mode udafMode = SemanticAnalyzer.groupByDescModeToUDAFMode(gbMode, udafAttr.isDistinctUDAF);
            SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(udafAttr.udafEvaluator, udafMode, (ArrayList)indexToParameter.get(index));
            aggregations.add(new AggregationDesc(udafAttr.udafName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, udafAttr.isDistinctUDAF, udafMode));
            colOutputName = useOriginalGBNames ? (String)gbInfo.outputColNames.get(udafColStartPosInOriginalGB + index) : SemanticAnalyzer.getColumnInternalName(gbKeys.size() + aggregations.size() - 1);
            colInfoLst.add(new ColumnInfo(colOutputName, udaf.returnType, "", false));
            outputColNames.add(colOutputName);
        }
        Operator<GroupByDesc> rsGB1 = OperatorFactory.getAndMakeChild(new GroupByDesc(gbMode, outputColNames, gbKeys, aggregations, false, gbInfo.groupByMemoryUsage, gbInfo.memoryThreshold, null, false, -1, numDistinctUDFs > 0), new RowSchema(colInfoLst), (Operator)rs, new Operator[0]);
        rsGB1.setColumnExprMap(colExprMap);
        return new HiveOpConverter.OpAttr("", new HashSet<Integer>(), rsGB1);
    }

    private static int getColInfoPos(ExprNodeDesc aggExpr, GBInfo gbInfo) {
        int gbKeyIndex = ExprNodeDescUtils.indexOf(aggExpr, gbInfo.gbKeys);
        if (gbKeyIndex < 0) {
            int distinctKeyIndex = ExprNodeDescUtils.indexOf(aggExpr, gbInfo.distExprNodes);
            if (distinctKeyIndex < 0) {
                int deDupValIndex = ExprNodeDescUtils.indexOf(aggExpr, gbInfo.deDupedNonDistIrefs);
                assert (deDupValIndex >= 0);
                return gbInfo.gbKeys.size() + gbInfo.distExprNodes.size() + deDupValIndex;
            }
            return gbInfo.gbKeys.size() + distinctKeyIndex;
        }
        return gbKeyIndex;
    }

    private static HiveOpConverter.OpAttr genMapSideGB(HiveOpConverter.OpAttr inputOpAf, GBInfo gbAttrs) throws SemanticException {
        ArrayList<String> outputColNames = new ArrayList<String>();
        ArrayList<ColumnInfo> colInfoLst = new ArrayList<ColumnInfo>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        HashSet gbKeyColsAsNamesFrmIn = new HashSet();
        String colOutputName = null;
        ArrayList<ExprNodeDesc> gbKeys = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < gbAttrs.gbKeys.size(); ++i) {
            gbKeys.add((ExprNodeDesc)gbAttrs.gbKeys.get(i));
            colOutputName = SemanticAnalyzer.getColumnInternalName(i);
            colInfoLst.add(new ColumnInfo(colOutputName, (TypeInfo)gbAttrs.gbKeyTypes.get(i), "", false));
            outputColNames.add(colOutputName);
            gbKeyColsAsNamesFrmIn.add(gbAttrs.gbKeyColNamesInInput.get(i));
            colExprMap.put(colOutputName, gbKeys.get(i));
        }
        int groupingSetsPosition = -1;
        boolean inclGrpID = HiveGBOpConvUtil.inclGrpSetInMapSide(gbAttrs);
        if (inclGrpID) {
            groupingSetsPosition = gbKeys.size();
            HiveGBOpConvUtil.addGrpSetCol(true, null, false, gbKeys, outputColNames, colInfoLst, colExprMap);
        }
        for (int i = 0; i < gbAttrs.distExprNodes.size(); ++i) {
            if (gbKeyColsAsNamesFrmIn.contains(gbAttrs.distExprNames.get(i))) continue;
            gbKeys.add((ExprNodeDesc)gbAttrs.distExprNodes.get(i));
            colOutputName = SemanticAnalyzer.getColumnInternalName(gbKeys.size() - 1);
            colInfoLst.add(new ColumnInfo(colOutputName, (TypeInfo)gbAttrs.distExprTypes.get(i), "", false));
            outputColNames.add(colOutputName);
            gbKeyColsAsNamesFrmIn.add(gbAttrs.distExprNames.get(i));
            colExprMap.put(colOutputName, gbKeys.get(gbKeys.size() - 1));
        }
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        for (UDAFAttrs udafAttr : gbAttrs.udafAttrs) {
            SemanticAnalyzer.GenericUDAFInfo udafInfo;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.HASH, udafAttr.isDistinctUDAF);
            aggregations.add(new AggregationDesc(udafAttr.udafName.toLowerCase(), udafAttr.udafEvaluator, udafAttr.udafParams, udafAttr.isDistinctUDAF, amode));
            try {
                udafInfo = SemanticAnalyzer.getGenericUDAFInfo(udafAttr.udafEvaluator, amode, udafAttr.udafParams);
            }
            catch (SemanticException e) {
                throw new RuntimeException(e);
            }
            colOutputName = SemanticAnalyzer.getColumnInternalName(gbKeys.size() + aggregations.size() - 1);
            colInfoLst.add(new ColumnInfo(colOutputName, udafInfo.returnType, "", false));
            outputColNames.add(colOutputName);
        }
        Operator<GroupByDesc> gbOp = OperatorFactory.getAndMakeChild(new GroupByDesc(GroupByDesc.Mode.HASH, outputColNames, gbKeys, aggregations, false, gbAttrs.groupByMemoryUsage, gbAttrs.memoryThreshold, gbAttrs.grpSets, inclGrpID, groupingSetsPosition, gbAttrs.containsDistinctAggr), new RowSchema(colInfoLst), (Operator)inputOpAf.inputs.get(0), new Operator[0]);
        gbOp.setColumnExprMap(colExprMap);
        return new HiveOpConverter.OpAttr("", new HashSet<Integer>(), gbOp);
    }

    private static void addGrpSetCol(boolean createConstantExpr, String grpSetIDExprName, boolean addReducePrefixToColInfoName, List<ExprNodeDesc> exprLst, List<String> outputColumnNames, List<ColumnInfo> colInfoLst, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        String outputColName = null;
        ExprNodeDesc grpSetColExpr = null;
        grpSetColExpr = createConstantExpr ? new ExprNodeConstantDesc("0") : new ExprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, grpSetIDExprName, null, false);
        exprLst.add(grpSetColExpr);
        outputColName = SemanticAnalyzer.getColumnInternalName(exprLst.size() - 1);
        outputColumnNames.add(outputColName);
        String internalColName = outputColName;
        if (addReducePrefixToColInfoName) {
            internalColName = Utilities.ReduceField.KEY.toString() + "." + outputColName;
        }
        colInfoLst.add(new ColumnInfo(internalColName, grpSetColExpr.getTypeInfo(), null, true));
        colExprMap.put(internalColName, grpSetColExpr);
    }

    private static ArrayList<ExprNodeDesc> getReduceKeysForRS(Operator inOp, int startPos, int endPos, List<String> outputKeyColumnNames, boolean addOnlyOneKeyColName, ArrayList<ColumnInfo> colInfoLst, Map<String, ExprNodeDesc> colExprMap, boolean addEmptyTabAlias, boolean setColToNonVirtual) throws SemanticException {
        ArrayList<ExprNodeDesc> reduceKeys = null;
        if (endPos < 0) {
            reduceKeys = new ArrayList<ExprNodeDesc>();
        } else {
            reduceKeys = ExprNodeDescUtils.genExprNodeDesc(inOp, startPos, endPos, addEmptyTabAlias, setColToNonVirtual);
            int outColNameIndx = startPos;
            for (int i = 0; i < reduceKeys.size(); ++i) {
                String outputColName = SemanticAnalyzer.getColumnInternalName(outColNameIndx);
                ++outColNameIndx;
                if (!addOnlyOneKeyColName || i == 0) {
                    outputKeyColumnNames.add(outputColName);
                }
                String tabAlias = addEmptyTabAlias ? "" : null;
                ColumnInfo colInfo = new ColumnInfo(Utilities.ReduceField.KEY.toString() + "." + outputColName, reduceKeys.get(i).getTypeInfo(), tabAlias, false);
                colInfoLst.add(colInfo);
                colExprMap.put(colInfo.getInternalName(), reduceKeys.get(i));
            }
        }
        return reduceKeys;
    }

    private static ArrayList<ExprNodeDesc> getValueKeysForRS(Operator inOp, int aggStartPos, List<String> outputKeyColumnNames, ArrayList<ColumnInfo> colInfoLst, Map<String, ExprNodeDesc> colExprMap, boolean addEmptyTabAlias, boolean setColToNonVirtual) throws SemanticException {
        ArrayList<ColumnInfo> mapGBColInfoLst = inOp.getSchema().getSignature();
        ArrayList<ExprNodeDesc> valueKeys = null;
        if (aggStartPos >= mapGBColInfoLst.size()) {
            valueKeys = new ArrayList<ExprNodeDesc>();
        } else {
            valueKeys = ExprNodeDescUtils.genExprNodeDesc(inOp, aggStartPos, mapGBColInfoLst.size() - 1, true, setColToNonVirtual);
            for (int i = 0; i < valueKeys.size(); ++i) {
                String outputColName = SemanticAnalyzer.getColumnInternalName(i);
                outputKeyColumnNames.add(outputColName);
                String tabAlias = addEmptyTabAlias ? "" : null;
                ColumnInfo colInfo = new ColumnInfo(Utilities.ReduceField.VALUE.toString() + "." + outputColName, valueKeys.get(i).getTypeInfo(), tabAlias, false);
                colInfoLst.add(colInfo);
                colExprMap.put(colInfo.getInternalName(), valueKeys.get(i));
            }
        }
        return valueKeys;
    }

    private static ExprNodeDesc propConstDistUDAFParams() {
        return null;
    }

    private static class GBInfo {
        private final List<String> outputColNames = new ArrayList<String>();
        private final List<String> gbKeyColNamesInInput = new ArrayList<String>();
        private final List<TypeInfo> gbKeyTypes = new ArrayList<TypeInfo>();
        private final List<ExprNodeDesc> gbKeys = new ArrayList<ExprNodeDesc>();
        private final List<Integer> grpSets = new ArrayList<Integer>();
        private boolean grpSetRqrAdditionalMRJob;
        private boolean grpIdFunctionNeeded;
        private final List<String> distExprNames = new ArrayList<String>();
        private final List<TypeInfo> distExprTypes = new ArrayList<TypeInfo>();
        private final List<ExprNodeDesc> distExprNodes = new ArrayList<ExprNodeDesc>();
        private final List<List<Integer>> distColIndices = new ArrayList<List<Integer>>();
        private final List<ExprNodeDesc> deDupedNonDistIrefs = new ArrayList<ExprNodeDesc>();
        private final List<UDAFAttrs> udafAttrs = new ArrayList<UDAFAttrs>();
        private boolean containsDistinctAggr = false;
        float groupByMemoryUsage;
        float memoryThreshold;
        private HIVEGBPHYSICALMODE gbPhysicalPipelineMode;

        private GBInfo() {
        }
    }

    private static class UDAFAttrs {
        private boolean isDistinctUDAF;
        private String udafName;
        private GenericUDAFEvaluator udafEvaluator;
        private final ArrayList<ExprNodeDesc> udafParams = new ArrayList();
        private List<Integer> udafParamsIndxInGBInfoDistExprs = new ArrayList<Integer>();
        private List<Integer> argList;

        private UDAFAttrs() {
        }
    }

    private static enum HIVEGBPHYSICALMODE {
        MAP_SIDE_GB_NO_SKEW_NO_ADD_MR_JOB,
        MAP_SIDE_GB_NO_SKEW_ADD_MR_JOB,
        MAP_SIDE_GB_SKEW_GBKEYS_OR_DIST_UDAF_PRESENT,
        MAP_SIDE_GB_SKEW_GBKEYS_AND_DIST_UDAF_NOT_PRESENT,
        NO_MAP_SIDE_GB_NO_SKEW,
        NO_MAP_SIDE_GB_SKEW;

    }
}

