/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.AggregateIndexHandler;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.IndexUtils;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteCanApplyCtx;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteQueryUsingAggregateIndexCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.util.StringUtils;

public class RewriteGBUsingIndex
extends Transform {
    private ParseContext parseContext;
    private Hive hiveDb;
    private HiveConf hiveConf;
    private static final Logger LOG = LoggerFactory.getLogger(RewriteGBUsingIndex.class.getName());
    private final Map<String, RewriteCanApplyCtx> tsOpToProcess = new LinkedHashMap<String, RewriteCanApplyCtx>();
    private static final String IDX_BUCKET_COL = "_bucketname";
    private static final String IDX_OFFSETS_ARRAY_COL = "_offsets";

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.parseContext = pctx;
        this.hiveConf = this.parseContext.getConf();
        try {
            this.hiveDb = Hive.get(this.hiveConf);
        }
        catch (HiveException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        HiveConf.setBoolVar(this.hiveConf, HiveConf.ConfVars.HIVEOPTINDEXFILTER, false);
        if (this.shouldApplyOptimization()) {
            LOG.info("Rewriting Original Query using " + this.getName() + " optimization.");
            this.rewriteOriginalQuery();
        }
        return this.parseContext;
    }

    private String getName() {
        return "RewriteGBUsingIndex";
    }

    boolean shouldApplyOptimization() throws SemanticException {
        Map<Table, List<Index>> tableToIndex = this.getIndexesForRewrite();
        if (tableToIndex.isEmpty()) {
            LOG.debug("No Valid Index Found to apply Rewrite, skipping " + this.getName() + " optimization");
            return false;
        }
        for (Map.Entry<String, TableScanOperator> entry : this.parseContext.getTopOps().entrySet()) {
            String alias = entry.getKey();
            TableScanOperator topOp = entry.getValue();
            Table table = ((TableScanDesc)topOp.getConf()).getTableMetadata();
            List<Index> indexes = tableToIndex.get(table);
            if (indexes.isEmpty()) continue;
            if (table.isPartitioned() && !this.checkIfIndexBuiltOnAllTablePartitions(topOp, indexes)) {
                LOG.debug("Index is not built for all table partitions, skipping " + this.getName() + " optimization");
                continue;
            }
            this.checkIfRewriteCanBeApplied(alias, topOp, table, indexes);
        }
        return !this.tsOpToProcess.isEmpty();
    }

    private boolean checkIfRewriteCanBeApplied(String alias, TableScanOperator topOp, Table baseTable, List<Index> indexes) throws SemanticException {
        RewriteCanApplyCtx canApplyCtx = RewriteCanApplyCtx.getInstance(this.parseContext);
        canApplyCtx.setAlias(alias);
        canApplyCtx.setBaseTableName(baseTable.getTableName());
        canApplyCtx.populateRewriteVars(topOp);
        Map<Index, String> indexTableMap = this.getIndexToKeysMap(indexes);
        for (Map.Entry<Index, String> entry : indexTableMap.entrySet()) {
            Index index = entry.getKey();
            String indexKeyName = entry.getValue();
            if (canApplyCtx.getIndexKey() == null || !canApplyCtx.getIndexKey().equals(indexKeyName) || !this.checkIfAllRewriteCriteriaIsMet(canApplyCtx)) continue;
            canApplyCtx.setAggFunction("_count_of_" + indexKeyName + "");
            canApplyCtx.addTable(canApplyCtx.getBaseTableName(), index.getIndexTableName());
            canApplyCtx.setIndexTableName(index.getIndexTableName());
            this.tsOpToProcess.put(alias, canApplyCtx);
            return true;
        }
        return false;
    }

    private Map<Table, List<Index>> getIndexesForRewrite() throws SemanticException {
        ArrayList<String> supportedIndexes = new ArrayList<String>();
        supportedIndexes.add(AggregateIndexHandler.class.getName());
        Collection<TableScanOperator> topTables = this.parseContext.getTopOps().values();
        HashMap<Table, List<Index>> indexes = new HashMap<Table, List<Index>>();
        for (TableScanOperator op : topTables) {
            TableScanOperator tsOP = op;
            List<Index> tblIndexes = IndexUtils.getIndexes(((TableScanDesc)tsOP.getConf()).getTableMetadata(), supportedIndexes);
            if (tblIndexes.size() <= 0) continue;
            indexes.put(((TableScanDesc)tsOP.getConf()).getTableMetadata(), tblIndexes);
        }
        return indexes;
    }

    private boolean checkIfIndexBuiltOnAllTablePartitions(TableScanOperator tableScan, List<Index> indexes) throws SemanticException {
        Set<Partition> queryPartitions;
        try {
            queryPartitions = IndexUtils.checkPartitionsCoveredByIndex(tableScan, this.parseContext, indexes);
            if (queryPartitions == null) {
                return false;
            }
        }
        catch (HiveException e) {
            LOG.error("Fatal Error: problem accessing metastore", e);
            throw new SemanticException(e);
        }
        return queryPartitions.size() != 0;
    }

    Map<Index, String> getIndexToKeysMap(List<Index> indexTables) throws SemanticException {
        Hive hiveInstance = this.hiveDb;
        LinkedHashMap<Index, String> indexToKeysMap = new LinkedHashMap<Index, String>();
        for (int idxCtr = 0; idxCtr < indexTables.size(); ++idxCtr) {
            Index index = indexTables.get(idxCtr);
            StorageDescriptor sd = index.getSd();
            List<FieldSchema> idxColList = sd.getCols();
            assert (idxColList.size() == 1);
            String indexKeyName = idxColList.get(0).getName();
            ArrayList<String> idxTblColNames = new ArrayList<String>();
            try {
                String[] qualified = Utilities.getDbTableName(index.getDbName(), index.getIndexTableName());
                Table idxTbl = hiveInstance.getTable(qualified[0], qualified[1]);
                for (FieldSchema idxTblCol : idxTbl.getCols()) {
                    idxTblColNames.add(idxTblCol.getName());
                }
            }
            catch (HiveException e) {
                LOG.error("Got exception while locating index table, skipping " + this.getName() + " optimization");
                LOG.error(StringUtils.stringifyException((Throwable)e));
                throw new SemanticException(e.getMessage(), e);
            }
            assert (idxTblColNames.contains(IDX_BUCKET_COL));
            assert (idxTblColNames.contains(IDX_OFFSETS_ARRAY_COL));
            indexToKeysMap.put(index, indexKeyName);
        }
        return indexToKeysMap;
    }

    private void rewriteOriginalQuery() throws SemanticException {
        for (RewriteCanApplyCtx canApplyCtx : this.tsOpToProcess.values()) {
            RewriteQueryUsingAggregateIndexCtx rewriteQueryCtx = RewriteQueryUsingAggregateIndexCtx.getInstance(this.parseContext, this.hiveDb, canApplyCtx);
            rewriteQueryCtx.invokeRewriteQueryProc();
            this.parseContext = rewriteQueryCtx.getParseContext();
        }
        LOG.info("Finished Rewriting query");
    }

    boolean checkIfAllRewriteCriteriaIsMet(RewriteCanApplyCtx canApplyCtx) {
        if (canApplyCtx.isSelClauseColsFetchException()) {
            LOG.debug("Got exception while locating child col refs for select list, skipping " + this.getName() + " optimization.");
            return false;
        }
        if (canApplyCtx.isAggFuncIsNotCount()) {
            LOG.debug("Agg func other than count is not supported by " + this.getName() + " optimization.");
            return false;
        }
        if (canApplyCtx.isAggParameterException()) {
            LOG.debug("Got exception while locating parameter refs for aggregation, skipping " + this.getName() + " optimization.");
            return false;
        }
        return true;
    }
}

