/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.fallback;

import io.prestosql.hive.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.AbstractHiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.DisallowTransformHook;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.SettableConfigUpdater;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.Operation2Privilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLAuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivTypeGrant;

public class FallbackHiveAuthorizer
extends AbstractHiveAuthorizer {
    private static final Log LOG = LogFactory.getLog(FallbackHiveAuthorizer.class);
    private final HiveAuthzSessionContext sessionCtx;
    private final HiveAuthenticationProvider authenticator;
    private String[] admins = null;

    FallbackHiveAuthorizer(HiveConf hiveConf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext ctx) {
        this.authenticator = hiveAuthenticator;
        this.sessionCtx = FallbackHiveAuthorizer.applyTestSettings(ctx, hiveConf);
        String adminString = hiveConf.getVar(HiveConf.ConfVars.USERS_IN_ADMIN_ROLE);
        if (adminString != null) {
            this.admins = hiveConf.getVar(HiveConf.ConfVars.USERS_IN_ADMIN_ROLE).split(",");
        }
    }

    static HiveAuthzSessionContext applyTestSettings(HiveAuthzSessionContext ctx, HiveConf conf) {
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_AUTHORIZATION_SQLSTD_HS2_MODE) && ctx.getClientType() == HiveAuthzSessionContext.CLIENT_TYPE.HIVECLI) {
            HiveAuthzSessionContext.Builder ctxBuilder = new HiveAuthzSessionContext.Builder(ctx);
            ctxBuilder.setClientType(HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2);
            return ctxBuilder.build();
        }
        return ctx;
    }

    @Override
    public HiveAuthorizer.VERSION getVersion() {
        return HiveAuthorizer.VERSION.V1;
    }

    @Override
    public void grantPrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException {
        throw new HiveAuthzPluginException("grantPrivileges not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public void revokePrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException {
        throw new HiveAuthzPluginException("revokePrivileges not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public void createRole(String roleName, HivePrincipal adminGrantor) throws HiveAuthzPluginException {
        throw new HiveAuthzPluginException("createRole not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public void dropRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        throw new HiveAuthzPluginException("dropRole not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public List<HiveRoleGrant> getPrincipalGrantInfoForRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        throw new HiveAuthzPluginException("getPrincipalGrantInfoForRole not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public List<HiveRoleGrant> getRoleGrantInfoForPrincipal(HivePrincipal principal) throws HiveAuthzPluginException, HiveAccessControlException {
        throw new HiveAuthzPluginException("getRoleGrantInfoForPrincipal not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public void grantRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        throw new HiveAuthzPluginException("grantRole not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public void revokeRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        throw new HiveAuthzPluginException("revokeRole not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        String userName = this.authenticator.getUserName();
        ArrayList<String> deniedMessages = new ArrayList<String>();
        this.checkPrivileges(hiveOpType, inputHObjs, userName, Operation2Privilege.IOType.INPUT, deniedMessages);
        this.checkPrivileges(hiveOpType, outputHObjs, userName, Operation2Privilege.IOType.OUTPUT, deniedMessages);
        SQLAuthorizationUtils.assertNoDeniedPermissions(new HivePrincipal(userName, HivePrincipal.HivePrincipalType.USER), hiveOpType, deniedMessages);
    }

    private void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> hiveObjects, String userName, Operation2Privilege.IOType ioType, List<String> deniedMessages) {
        if (hiveObjects == null) {
            return;
        }
        boolean isAdmin = false;
        if (this.admins != null && this.admins.length > 0) {
            isAdmin = Arrays.asList(this.admins).contains(userName);
        }
        if (isAdmin) {
            return;
        }
        if (Operation2Privilege.isAdminPrivOperation(hiveOpType)) {
            deniedMessages.add(SQLPrivTypeGrant.ADMIN_PRIV.toString() + " on " + (Object)((Object)ioType));
            return;
        }
        boolean needAdmin = false;
        for (HivePrivilegeObject hiveObj : hiveObjects) {
            if (hiveObj.getType() != HivePrivilegeObject.HivePrivilegeObjectType.LOCAL_URI) continue;
            needAdmin = true;
            break;
        }
        if (!needAdmin) {
            switch (hiveOpType) {
                case ADD: 
                case DFS: 
                case COMPILE: {
                    needAdmin = true;
                    break;
                }
            }
        }
        if (needAdmin) {
            deniedMessages.add("ADMIN");
        }
    }

    @Override
    public List<HivePrivilegeObject> filterListCmdObjects(List<HivePrivilegeObject> listObjs, HiveAuthzContext context) {
        return listObjs;
    }

    @Override
    public List<String> getAllRoles() throws HiveAuthzPluginException {
        throw new HiveAuthzPluginException("getAllRoles not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public List<HivePrivilegeInfo> showPrivileges(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException {
        throw new HiveAuthzPluginException("showPrivileges not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public void setCurrentRole(String roleName) throws HiveAuthzPluginException {
        throw new HiveAuthzPluginException("setCurrentRole not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public List<String> getCurrentRoleNames() throws HiveAuthzPluginException {
        throw new HiveAuthzPluginException("getCurrentRoleNames not implemented in FallbackHiveAuthorizer");
    }

    @Override
    public void applyAuthorizationConfigPolicy(HiveConf hiveConf) throws HiveAuthzPluginException {
        if (this.sessionCtx.getClientType() == HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2 && hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            String hooks = hiveConf.getVar(HiveConf.ConfVars.PREEXECHOOKS).trim();
            hooks = hooks.isEmpty() ? DisallowTransformHook.class.getName() : hooks + "," + DisallowTransformHook.class.getName();
            LOG.debug("Configuring hooks : " + hooks);
            hiveConf.setVar(HiveConf.ConfVars.PREEXECHOOKS, hooks);
            SettableConfigUpdater.setHiveConfWhiteList(hiveConf);
            String curBlackList = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_BLACKLIST);
            if (curBlackList != null && curBlackList.trim().equals("reflect,reflect2,java_method")) {
                hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_BLACKLIST, "reflect,reflect2,java_method,in_file");
            }
        }
    }

    @Override
    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(HiveAuthzContext context, List<HivePrivilegeObject> privObjs) throws SemanticException {
        return privObjs;
    }

    @Override
    public boolean needTransform() {
        return false;
    }
}

