/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import io.prestosql.hive.$internal.com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.RequiredPrivileges;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivTypeGrant;

public class Operation2Privilege {
    private static Map<HiveOperationType, List<PrivRequirement>> op2Priv;
    private static List<HiveOperationType> adminPrivOps;
    private static SQLPrivTypeGrant[] OWNER_PRIV_AR;
    private static SQLPrivTypeGrant[] SEL_NOGRANT_AR;
    private static SQLPrivTypeGrant[] SEL_GRANT_AR;
    private static SQLPrivTypeGrant[] ADMIN_PRIV_AR;
    private static SQLPrivTypeGrant[] INS_NOGRANT_AR;
    private static SQLPrivTypeGrant[] DEL_NOGRANT_AR;
    private static SQLPrivTypeGrant[] UPD_NOGRANT_AR;
    private static SQLPrivTypeGrant[] OWNER_INS_SEL_DEL_NOGRANT_AR;

    private static SQLPrivTypeGrant[] arr(SQLPrivTypeGrant ... grantList) {
        return grantList;
    }

    private static List<PrivRequirement> arr(PrivRequirement ... privReqList) {
        return Arrays.asList(privReqList);
    }

    public static RequiredPrivileges getRequiredPrivs(HiveOperationType hiveOpType, HivePrivilegeObject hObj, IOType ioType) {
        List<PrivRequirement> opPrivs = op2Priv.get((Object)hiveOpType);
        Preconditions.checkNotNull(opPrivs, "Privileges for " + (Object)((Object)hiveOpType) + " are null");
        RequiredPrivileges reqPrivs = new RequiredPrivileges();
        for (PrivRequirement opPriv : opPrivs) {
            if (opPriv.getIOType() != null && opPriv.getIOType() != ioType || opPriv.getActionType() != null && opPriv.getActionType() != hObj.getActionType() || opPriv.getObjectType() != null && opPriv.getObjectType() != hObj.getType()) continue;
            reqPrivs.addAll(opPriv.getReqPrivs());
        }
        return reqPrivs;
    }

    public static boolean isAdminPrivOperation(HiveOperationType hiveOpType) {
        return adminPrivOps.contains((Object)hiveOpType);
    }

    public static Set<HiveOperationType> getOperationTypes() {
        return op2Priv.keySet();
    }

    static {
        OWNER_PRIV_AR = Operation2Privilege.arr(SQLPrivTypeGrant.OWNER_PRIV);
        SEL_NOGRANT_AR = Operation2Privilege.arr(SQLPrivTypeGrant.SELECT_NOGRANT);
        SEL_GRANT_AR = Operation2Privilege.arr(SQLPrivTypeGrant.SELECT_WGRANT);
        ADMIN_PRIV_AR = Operation2Privilege.arr(SQLPrivTypeGrant.ADMIN_PRIV);
        INS_NOGRANT_AR = Operation2Privilege.arr(SQLPrivTypeGrant.INSERT_NOGRANT);
        DEL_NOGRANT_AR = Operation2Privilege.arr(SQLPrivTypeGrant.DELETE_NOGRANT);
        UPD_NOGRANT_AR = Operation2Privilege.arr(SQLPrivTypeGrant.UPDATE_NOGRANT);
        OWNER_INS_SEL_DEL_NOGRANT_AR = Operation2Privilege.arr(SQLPrivTypeGrant.OWNER_PRIV, SQLPrivTypeGrant.INSERT_NOGRANT, SQLPrivTypeGrant.DELETE_NOGRANT, SQLPrivTypeGrant.SELECT_NOGRANT);
        adminPrivOps = new ArrayList<HiveOperationType>();
        op2Priv = new HashMap<HiveOperationType, List<PrivRequirement>>();
        op2Priv.put(HiveOperationType.EXPLAIN, PrivRequirement.newIOPrivRequirement(SEL_NOGRANT_AR, SEL_NOGRANT_AR));
        op2Priv.put(HiveOperationType.CREATEDATABASE, PrivRequirement.newPrivRequirementList(new PrivRequirement(OWNER_INS_SEL_DEL_NOGRANT_AR, HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI), new PrivRequirement(OWNER_INS_SEL_DEL_NOGRANT_AR, HivePrivilegeObject.HivePrivilegeObjectType.LOCAL_URI)));
        op2Priv.put(HiveOperationType.DROPDATABASE, PrivRequirement.newIOPrivRequirement(null, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.SWITCHDATABASE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.LOCKDB, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.UNLOCKDB, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.DROPTABLE, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, null));
        op2Priv.put(HiveOperationType.DESCTABLE, PrivRequirement.newIOPrivRequirement(SEL_NOGRANT_AR, null));
        op2Priv.put(HiveOperationType.SHOWPARTITIONS, PrivRequirement.newIOPrivRequirement(SEL_NOGRANT_AR, null));
        op2Priv.put(HiveOperationType.DESCFUNCTION, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.MSCK, PrivRequirement.newIOPrivRequirement(ADMIN_PRIV_AR, INS_NOGRANT_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_ADDCOLS, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_REPLACECOLS, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_RENAMECOL, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_RENAMEPART, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_RENAME, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_UPDATETABLESTATS, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_UPDATEPARTSTATS, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_TOUCH, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_ARCHIVE, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_UNARCHIVE, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_PROPERTIES, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_SERIALIZER, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_PARTCOLTYPE, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERPARTITION_SERIALIZER, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_SERDEPROPERTIES, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERPARTITION_SERDEPROPERTIES, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_CLUSTER_SORT, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_BUCKETNUM, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERPARTITION_BUCKETNUM, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_PROTECTMODE, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERPARTITION_PROTECTMODE, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_FILEFORMAT, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERPARTITION_FILEFORMAT, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_LOCATION, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_INS_SEL_DEL_NOGRANT_AR));
        op2Priv.put(HiveOperationType.ALTERPARTITION_LOCATION, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_INS_SEL_DEL_NOGRANT_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_MERGEFILES, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERPARTITION_MERGEFILES, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_SKEWED, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTBLPART_SKEWED_LOCATION, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_INS_SEL_DEL_NOGRANT_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_COMPACT, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.TRUNCATETABLE, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_DROPCONSTRAINT, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERTABLE_ADDCONSTRAINT, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.CREATEINDEX, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_INS_SEL_DEL_NOGRANT_AR));
        op2Priv.put(HiveOperationType.DROPINDEX, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERINDEX_REBUILD, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERINDEX_PROPS, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERVIEW_PROPERTIES, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.DROPVIEW_PROPERTIES, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERVIEW_RENAME, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERVIEW_AS, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.DROPVIEW, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.DROP_MATERIALIZED_VIEW, PrivRequirement.newIOPrivRequirement(OWNER_PRIV_AR, OWNER_PRIV_AR));
        op2Priv.put(HiveOperationType.ANALYZE_TABLE, PrivRequirement.newIOPrivRequirement(Operation2Privilege.arr(SQLPrivTypeGrant.SELECT_NOGRANT, SQLPrivTypeGrant.INSERT_NOGRANT), null));
        op2Priv.put(HiveOperationType.CACHE_METADATA, PrivRequirement.newIOPrivRequirement(Operation2Privilege.arr(SQLPrivTypeGrant.SELECT_NOGRANT, SQLPrivTypeGrant.INSERT_NOGRANT), null));
        op2Priv.put(HiveOperationType.SHOWDATABASES, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOWTABLES, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.ALTERTABLE_DROPPARTS, PrivRequirement.newIOPrivRequirement(DEL_NOGRANT_AR, null));
        op2Priv.put(HiveOperationType.ALTERTABLE_ADDPARTS, PrivRequirement.newIOPrivRequirement(OWNER_INS_SEL_DEL_NOGRANT_AR, INS_NOGRANT_AR));
        op2Priv.put(HiveOperationType.EXPORT, PrivRequirement.newIOPrivRequirement(SEL_GRANT_AR, OWNER_INS_SEL_DEL_NOGRANT_AR));
        op2Priv.put(HiveOperationType.IMPORT, PrivRequirement.newPrivRequirementList(new PrivRequirement(OWNER_INS_SEL_DEL_NOGRANT_AR, IOType.INPUT), new PrivRequirement(Operation2Privilege.arr(SQLPrivTypeGrant.INSERT_NOGRANT, SQLPrivTypeGrant.DELETE_NOGRANT), IOType.OUTPUT, null, HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW), new PrivRequirement(OWNER_PRIV_AR, IOType.OUTPUT, null, HivePrivilegeObject.HivePrivilegeObjectType.DATABASE)));
        adminPrivOps.add(HiveOperationType.CREATEFUNCTION);
        adminPrivOps.add(HiveOperationType.DROPFUNCTION);
        op2Priv.put(HiveOperationType.SHOWCOLUMNS, PrivRequirement.newIOPrivRequirement(SEL_NOGRANT_AR, null));
        op2Priv.put(HiveOperationType.SHOW_TABLESTATUS, PrivRequirement.newIOPrivRequirement(SEL_NOGRANT_AR, null));
        op2Priv.put(HiveOperationType.SHOW_TBLPROPERTIES, PrivRequirement.newIOPrivRequirement(SEL_NOGRANT_AR, null));
        op2Priv.put(HiveOperationType.CREATETABLE_AS_SELECT, PrivRequirement.newPrivRequirementList(new PrivRequirement(SEL_NOGRANT_AR, IOType.INPUT), new PrivRequirement(OWNER_PRIV_AR, HivePrivilegeObject.HivePrivilegeObjectType.DATABASE)));
        op2Priv.put(HiveOperationType.QUERY, Operation2Privilege.arr(new PrivRequirement(SEL_NOGRANT_AR, IOType.INPUT), new PrivRequirement(INS_NOGRANT_AR, IOType.OUTPUT, HivePrivilegeObject.HivePrivObjectActionType.INSERT), new PrivRequirement(Operation2Privilege.arr(SQLPrivTypeGrant.INSERT_NOGRANT, SQLPrivTypeGrant.DELETE_NOGRANT), IOType.OUTPUT, HivePrivilegeObject.HivePrivObjectActionType.INSERT_OVERWRITE), new PrivRequirement(DEL_NOGRANT_AR, IOType.OUTPUT, HivePrivilegeObject.HivePrivObjectActionType.DELETE), new PrivRequirement(UPD_NOGRANT_AR, IOType.OUTPUT, HivePrivilegeObject.HivePrivObjectActionType.UPDATE), new PrivRequirement(INS_NOGRANT_AR, IOType.OUTPUT, HivePrivilegeObject.HivePrivObjectActionType.OTHER)));
        op2Priv.put(HiveOperationType.LOAD, PrivRequirement.newIOPrivRequirement(OWNER_INS_SEL_DEL_NOGRANT_AR, Operation2Privilege.arr(SQLPrivTypeGrant.INSERT_NOGRANT, SQLPrivTypeGrant.DELETE_NOGRANT)));
        op2Priv.put(HiveOperationType.SHOW_CREATETABLE, PrivRequirement.newIOPrivRequirement(SEL_GRANT_AR, null));
        op2Priv.put(HiveOperationType.SHOW_CREATEDATABASE, PrivRequirement.newIOPrivRequirement(SEL_GRANT_AR, null));
        op2Priv.put(HiveOperationType.CREATEVIEW, PrivRequirement.newPrivRequirementList(new PrivRequirement(SEL_GRANT_AR, IOType.INPUT), new PrivRequirement(OWNER_PRIV_AR, HivePrivilegeObject.HivePrivilegeObjectType.DATABASE)));
        op2Priv.put(HiveOperationType.CREATE_MATERIALIZED_VIEW, PrivRequirement.newPrivRequirementList(new PrivRequirement(SEL_GRANT_AR, IOType.INPUT), new PrivRequirement(OWNER_PRIV_AR, HivePrivilegeObject.HivePrivilegeObjectType.DATABASE)));
        op2Priv.put(HiveOperationType.SHOWFUNCTIONS, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOWINDEXES, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOWLOCKS, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.CREATEFUNCTION, PrivRequirement.newIOPrivRequirement(null, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.DROPFUNCTION, PrivRequirement.newIOPrivRequirement(null, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.RELOADFUNCTION, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.CREATEMACRO, PrivRequirement.newIOPrivRequirement(null, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.DROPMACRO, PrivRequirement.newIOPrivRequirement(null, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.SHOW_COMPACTIONS, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOW_TRANSACTIONS, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOWCONF, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOWVIEWS, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.LOCKTABLE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.UNLOCKTABLE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.CREATETABLE, PrivRequirement.newPrivRequirementList(new PrivRequirement(OWNER_INS_SEL_DEL_NOGRANT_AR, IOType.INPUT), new PrivRequirement(OWNER_PRIV_AR, HivePrivilegeObject.HivePrivilegeObjectType.DATABASE)));
        op2Priv.put(HiveOperationType.ALTERDATABASE, PrivRequirement.newIOPrivRequirement(null, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.ALTERDATABASE_OWNER, PrivRequirement.newIOPrivRequirement(null, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.DESCDATABASE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.DFS, PrivRequirement.newIOPrivRequirement(ADMIN_PRIV_AR, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.RESET, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.COMPILE, PrivRequirement.newIOPrivRequirement(ADMIN_PRIV_AR, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.ADD, PrivRequirement.newIOPrivRequirement(ADMIN_PRIV_AR, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.DELETE, PrivRequirement.newIOPrivRequirement(ADMIN_PRIV_AR, ADMIN_PRIV_AR));
        op2Priv.put(HiveOperationType.SET, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.CREATEROLE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.DROPROLE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.GRANT_PRIVILEGE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.REVOKE_PRIVILEGE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOW_GRANT, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.GRANT_ROLE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.REVOKE_ROLE, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOW_ROLES, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOW_ROLE_GRANT, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SHOW_ROLE_PRINCIPALS, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.GET_CATALOGS, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.GET_SCHEMAS, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.GET_TABLES, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.GET_FUNCTIONS, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.GET_TABLETYPES, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.GET_TYPEINFO, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.GET_COLUMNS, PrivRequirement.newIOPrivRequirement(SEL_NOGRANT_AR, null));
        op2Priv.put(HiveOperationType.START_TRANSACTION, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.COMMIT, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.ROLLBACK, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.SET_AUTOCOMMIT, PrivRequirement.newIOPrivRequirement(null, null));
        op2Priv.put(HiveOperationType.ALTERTABLE_EXCHANGEPARTITION, PrivRequirement.newIOPrivRequirement(Operation2Privilege.arr(SQLPrivTypeGrant.SELECT_NOGRANT, SQLPrivTypeGrant.DELETE_NOGRANT), INS_NOGRANT_AR));
        op2Priv.put(HiveOperationType.ABORT_TRANSACTIONS, PrivRequirement.newIOPrivRequirement(null, null));
    }

    private static class PrivRequirement {
        private final SQLPrivTypeGrant[] reqPrivs;
        private final IOType ioType;
        private final HivePrivilegeObject.HivePrivObjectActionType actionType;
        private final HivePrivilegeObject.HivePrivilegeObjectType objectType;

        private PrivRequirement(SQLPrivTypeGrant[] privs, IOType ioType) {
            this(privs, ioType, (HivePrivilegeObject.HivePrivObjectActionType)null);
        }

        private PrivRequirement(SQLPrivTypeGrant[] privs, IOType ioType, HivePrivilegeObject.HivePrivObjectActionType actionType) {
            this(privs, ioType, actionType, (HivePrivilegeObject.HivePrivilegeObjectType)null);
        }

        private PrivRequirement(SQLPrivTypeGrant[] privs, HivePrivilegeObject.HivePrivilegeObjectType objectType) {
            this(privs, null, null, objectType);
        }

        private PrivRequirement(SQLPrivTypeGrant[] privs, IOType ioType, HivePrivilegeObject.HivePrivObjectActionType actionType, HivePrivilegeObject.HivePrivilegeObjectType objectType) {
            this.reqPrivs = privs;
            this.ioType = ioType;
            this.actionType = actionType;
            this.objectType = objectType;
        }

        static List<PrivRequirement> newIOPrivRequirement(SQLPrivTypeGrant[] inGrants, SQLPrivTypeGrant[] outGrants) {
            ArrayList<PrivRequirement> privReqs = new ArrayList<PrivRequirement>();
            privReqs.add(new PrivRequirement(inGrants, IOType.INPUT));
            privReqs.add(new PrivRequirement(outGrants, IOType.OUTPUT));
            return privReqs;
        }

        static List<PrivRequirement> newPrivRequirementList(PrivRequirement ... privs) {
            return new ArrayList<PrivRequirement>(Arrays.asList(privs));
        }

        private SQLPrivTypeGrant[] getReqPrivs() {
            return this.reqPrivs;
        }

        private IOType getIOType() {
            return this.ioType;
        }

        private HivePrivilegeObject.HivePrivObjectActionType getActionType() {
            return this.actionType;
        }

        public HivePrivilegeObject.HivePrivilegeObjectType getObjectType() {
            return this.objectType;
        }
    }

    public static enum IOType {
        INPUT,
        OUTPUT;

    }
}

