/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizationValidator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.Operation2Privilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.RequiredPrivileges;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLAuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivTypeGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAccessControllerWrapper;

public class SQLStdHiveAuthorizationValidator
implements HiveAuthorizationValidator {
    private final HiveMetastoreClientFactory metastoreClientFactory;
    private final HiveConf conf;
    private final HiveAuthenticationProvider authenticator;
    private final SQLStdHiveAccessControllerWrapper privController;
    private final HiveAuthzSessionContext ctx;
    public static final Logger LOG = LoggerFactory.getLogger(SQLStdHiveAuthorizationValidator.class);

    public SQLStdHiveAuthorizationValidator(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider authenticator, SQLStdHiveAccessControllerWrapper privilegeManager, HiveAuthzSessionContext ctx) throws HiveAuthzPluginException {
        this.metastoreClientFactory = metastoreClientFactory;
        this.conf = conf;
        this.authenticator = authenticator;
        this.privController = privilegeManager;
        this.ctx = SQLAuthorizationUtils.applyTestSettings(ctx, conf);
    }

    @Override
    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            String msg = "Checking privileges for operation " + (Object)((Object)hiveOpType) + " by user " + this.authenticator.getUserName() + " on " + " input objects " + inputHObjs + " and output objects " + outputHObjs + ". Context Info: " + context;
            LOG.debug(msg);
        }
        String userName = this.authenticator.getUserName();
        IMetaStoreClient metastoreClient = this.metastoreClientFactory.getHiveMetastoreClient();
        ArrayList<String> deniedMessages = new ArrayList<String>();
        this.checkPrivileges(hiveOpType, inputHObjs, metastoreClient, userName, Operation2Privilege.IOType.INPUT, deniedMessages);
        this.checkPrivileges(hiveOpType, outputHObjs, metastoreClient, userName, Operation2Privilege.IOType.OUTPUT, deniedMessages);
        SQLAuthorizationUtils.assertNoDeniedPermissions(new HivePrincipal(userName, HivePrincipal.HivePrincipalType.USER), hiveOpType, deniedMessages);
    }

    private void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> hiveObjects, IMetaStoreClient metastoreClient, String userName, Operation2Privilege.IOType ioType, List<String> deniedMessages) throws HiveAuthzPluginException, HiveAccessControlException {
        if (hiveObjects == null) {
            return;
        }
        block5: for (HivePrivilegeObject hiveObj : hiveObjects) {
            RequiredPrivileges requiredPrivs = Operation2Privilege.getRequiredPrivs(hiveOpType, hiveObj, ioType);
            if (requiredPrivs.getRequiredPrivilegeSet().isEmpty()) continue;
            RequiredPrivileges availPrivs = new RequiredPrivileges();
            switch (hiveObj.getType()) {
                case LOCAL_URI: 
                case DFS_URI: {
                    availPrivs = SQLAuthorizationUtils.getPrivilegesFromFS(new Path(hiveObj.getObjectName()), this.conf, userName);
                    break;
                }
                case PARTITION: {
                    continue block5;
                }
                case COMMAND_PARAMS: 
                case FUNCTION: {
                    if (!this.privController.isUserAdmin()) break;
                    availPrivs.addPrivilege(SQLPrivTypeGrant.ADMIN_PRIV);
                    break;
                }
                default: {
                    availPrivs = SQLAuthorizationUtils.getPrivilegesFromMetaStore(metastoreClient, userName, hiveObj, this.privController.getCurrentRoleNames(), this.privController.isUserAdmin());
                }
            }
            Collection<SQLPrivTypeGrant> missingPriv = requiredPrivs.findMissingPrivs(availPrivs);
            SQLAuthorizationUtils.addMissingPrivMsg(missingPriv, hiveObj, deniedMessages);
        }
    }

    @Override
    public List<HivePrivilegeObject> filterListCmdObjects(List<HivePrivilegeObject> listObjs, HiveAuthzContext context) {
        if (LOG.isDebugEnabled()) {
            String msg = "Obtained following objects in  filterListCmdObjects " + listObjs + " for user " + this.authenticator.getUserName() + ". Context Info: " + context;
            LOG.debug(msg);
        }
        return listObjs;
    }

    @Override
    public boolean needTransform() {
        return false;
    }

    @Override
    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(HiveAuthzContext context, List<HivePrivilegeObject> privObjs) throws SemanticException {
        return null;
    }
}

