/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats.fs;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Output;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;

public class FSStatsPublisher
implements StatsPublisher {
    private Configuration conf;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass().getName());
    private Map<String, Map<String, String>> statsMap;

    @Override
    public boolean init(StatsCollectionContext context) {
        try {
            for (String tmpDir : context.getStatsTmpDirs()) {
                Path statsDir = new Path(tmpDir);
                this.LOG.debug("Initing FSStatsPublisher with : " + statsDir);
                statsDir.getFileSystem(context.getHiveConf()).mkdirs(statsDir);
                this.LOG.info("created : " + statsDir);
            }
            return true;
        }
        catch (IOException e) {
            this.LOG.error("Failed to create dir", e);
            return false;
        }
    }

    @Override
    public boolean connect(StatsCollectionContext context) {
        this.conf = context.getHiveConf();
        List<String> statsDirs = context.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        Path statsDir = new Path(statsDirs.get(0));
        this.LOG.debug("Connecting to : " + statsDir);
        this.statsMap = new HashMap<String, Map<String, String>>();
        try {
            return statsDir.getFileSystem(this.conf).exists(statsDir);
        }
        catch (IOException e) {
            this.LOG.error("Failed to check if dir exists", e);
            return false;
        }
    }

    @Override
    public boolean publishStat(String partKV, Map<String, String> stats) {
        this.LOG.debug("Putting in map : " + partKV + "\t" + stats);
        HashMap<String, String> cpy = new HashMap<String, String>(stats);
        Map<String, String> statMap = this.statsMap.get(partKV);
        if (null != statMap) {
            for (Map.Entry<String, String> e : statMap.entrySet()) {
                cpy.put(e.getKey(), String.valueOf(Long.parseLong(e.getValue()) + Long.parseLong((String)cpy.get(e.getKey()))));
            }
        }
        this.statsMap.put(partKV, cpy);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeConnection(StatsCollectionContext context) {
        List<String> statsDirs = context.getStatsTmpDirs();
        assert (statsDirs.size() == 1) : "Found multiple stats dirs: " + statsDirs;
        Path statsDir = new Path(statsDirs.get(0));
        try {
            Path statsFile = null;
            statsFile = context.getIndexForTezUnion() != -1 ? new Path(statsDir, "tmpstats-" + this.conf.getInt("mapred.task.partition", 0) + "_" + context.getIndexForTezUnion()) : new Path(statsDir, "tmpstats-" + this.conf.getInt("mapred.task.partition", 0));
            this.LOG.debug("About to create stats file for this task : " + statsFile);
            Output output = new Output((OutputStream)statsFile.getFileSystem(this.conf).create(statsFile, true));
            this.LOG.debug("Created file : " + statsFile);
            this.LOG.debug("Writing stats in it : " + this.statsMap);
            Kryo kryo = SerializationUtilities.borrowKryo();
            try {
                kryo.writeObject(output, this.statsMap);
            }
            finally {
                SerializationUtilities.releaseKryo(kryo);
            }
            output.close();
            return true;
        }
        catch (IOException e) {
            this.LOG.error("Failed to persist stats on filesystem", e);
            return false;
        }
    }
}

