/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.txn.compactor.HouseKeeperServiceBase;

public class AcidCompactionHistoryService
extends HouseKeeperServiceBase {
    private static final Logger LOG = LoggerFactory.getLogger(AcidCompactionHistoryService.class);

    @Override
    protected long getStartDelayMs() {
        return 0L;
    }

    @Override
    protected long getIntervalMs() {
        return this.hiveConf.getTimeVar(HiveConf.ConfVars.COMPACTOR_HISTORY_REAPER_INTERVAL, TimeUnit.MILLISECONDS);
    }

    @Override
    protected Runnable getScheduedAction(HiveConf hiveConf, AtomicInteger isAliveCounter) {
        return new ObsoleteEntryReaper(hiveConf, isAliveCounter);
    }

    @Override
    public String getServiceDescription() {
        return "Removes obsolete entries from Compaction History";
    }

    private static final class ObsoleteEntryReaper
    implements Runnable {
        private final TxnStore txnHandler;
        private final AtomicInteger isAliveCounter;

        private ObsoleteEntryReaper(HiveConf hiveConf, AtomicInteger isAliveCounter) {
            this.txnHandler = TxnUtils.getTxnStore(hiveConf);
            this.isAliveCounter = isAliveCounter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TxnStore.MutexAPI.LockHandle handle = null;
            try {
                handle = this.txnHandler.getMutexAPI().acquireLock(TxnStore.MUTEX_KEY.CompactionHistory.name());
                long startTime = System.currentTimeMillis();
                this.txnHandler.purgeCompactionHistory();
                int count = this.isAliveCounter.incrementAndGet();
                LOG.info("History reaper reaper ran for " + (System.currentTimeMillis() - startTime) / 1000L + "seconds.  isAliveCounter=" + count);
            }
            catch (Throwable t) {
                LOG.error("Serious error in {}", Thread.currentThread().getName(), ": {}" + t.getMessage(), t);
            }
            finally {
                if (handle != null) {
                    handle.releaseLocks();
                }
            }
        }
    }
}

