/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLeadLag;
import org.apache.hadoop.hive.ql.udf.generic.ISupportStreamingModeForWindowing;
import org.apache.hadoop.hive.ql.udf.generic.LeadLagBuffer;

@WindowFunctionDescription(description=@Description(name="lag", value="_FUNC_(expr, amt, default)"), supportsWindow=false, pivotResult=true, impliesOrder=true)
public class GenericUDAFLag
extends GenericUDAFLeadLag {
    static final Logger LOG = LoggerFactory.getLogger(GenericUDAFLag.class.getName());

    @Override
    protected String functionName() {
        return "Lag";
    }

    @Override
    protected GenericUDAFLeadLag.GenericUDAFLeadLagEvaluator createLLEvaluator() {
        return new GenericUDAFLagEvaluator();
    }

    static class GenericUDAFLagEvaluatorStreaming
    extends GenericUDAFLagEvaluator
    implements ISupportStreamingModeForWindowing {
        protected GenericUDAFLagEvaluatorStreaming(GenericUDAFLeadLag.GenericUDAFLeadLagEvaluator src) {
            super(src);
        }

        @Override
        public Object getNextResult(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            LagBuffer lb = (LagBuffer)agg;
            if (!lb.lagValues.isEmpty()) {
                Object res = lb.lagValues.remove(0);
                if (res == null) {
                    return ISupportStreamingModeForWindowing.NULL_RESULT;
                }
                return res;
            }
            if (!lb.values.isEmpty()) {
                Object res = lb.values.remove(0);
                if (res == null) {
                    return ISupportStreamingModeForWindowing.NULL_RESULT;
                }
                return res;
            }
            return null;
        }

        @Override
        public int getRowsRemainingAfterTerminate() throws HiveException {
            return this.getAmt();
        }
    }

    static class LagBuffer
    implements LeadLagBuffer {
        ArrayList<Object> values;
        int lagAmt;
        ArrayList<Object> lagValues;
        int lastRowIdx;

        LagBuffer() {
        }

        @Override
        public void initialize(int lagAmt) {
            this.lagAmt = lagAmt;
            this.lagValues = new ArrayList(lagAmt);
            this.values = new ArrayList();
            this.lastRowIdx = -1;
        }

        @Override
        public void addRow(Object currValue, Object defaultValue) {
            int row = this.lastRowIdx + 1;
            if (row < this.lagAmt) {
                this.lagValues.add(defaultValue);
            }
            this.values.add(currValue);
            ++this.lastRowIdx;
        }

        @Override
        public Object terminate() {
            if (this.values.size() < this.lagAmt) {
                this.values = this.lagValues;
                return this.lagValues;
            }
            int lastIdx = this.values.size() - 1;
            for (int i = 0; i < this.lagAmt; ++i) {
                this.values.remove(lastIdx - i);
            }
            this.values.addAll(0, this.lagValues);
            return this.values;
        }
    }

    public static class GenericUDAFLagEvaluator
    extends GenericUDAFLeadLag.GenericUDAFLeadLagEvaluator {
        public GenericUDAFLagEvaluator() {
        }

        protected GenericUDAFLagEvaluator(GenericUDAFLeadLag.GenericUDAFLeadLagEvaluator src) {
            super(src);
        }

        @Override
        protected LeadLagBuffer getNewLLBuffer() throws HiveException {
            return new LagBuffer();
        }

        @Override
        public GenericUDAFEvaluator getWindowingEvaluator(WindowFrameDef wFrmDef) {
            return new GenericUDAFLagEvaluatorStreaming(this);
        }
    }
}

