/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import io.prestosql.hive.$internal.com.google.common.collect.Interner;
import io.prestosql.hive.$internal.com.google.common.collect.Interners;
import io.prestosql.hive.$internal.org.apache.commons.lang.StringUtils;
import io.prestosql.hive.$internal.org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import io.prestosql.hive.$internal.org.apache.commons.lang3.text.translate.EntityArrays;
import io.prestosql.hive.$internal.org.apache.commons.lang3.text.translate.LookupTranslator;
import io.prestosql.hive.$internal.org.slf4j.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.hive.common.util.ShutdownHookManager;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HiveStringUtils {
    public static final int SHUTDOWN_HOOK_PRIORITY = 0;
    private static final DecimalFormat decimalFormat;
    private static final CharSequenceTranslator ESCAPE_JAVA;
    private static final CharSequenceTranslator ESCAPE_HIVE_COMMAND;
    private static final Interner<String> STRING_INTERNER;
    private static DecimalFormat oneDecimal;
    public static final String[] emptyStringArray;
    public static final char COMMA = ',';
    public static final char EQUALS = '=';
    public static final String COMMA_STR = ",";
    public static final char ESCAPE_CHAR = '\\';

    public static String intern(String str) {
        if (str == null) {
            return null;
        }
        return STRING_INTERNER.intern(str);
    }

    public static List<String> intern(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> newList = new ArrayList<String>(list.size());
        for (String str : list) {
            newList.add(HiveStringUtils.intern(str));
        }
        return newList;
    }

    public static Map<String, String> intern(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        if (map.isEmpty()) {
            return map;
        }
        HashMap<String, String> newMap = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            newMap.put(HiveStringUtils.intern(entry.getKey()), HiveStringUtils.intern(entry.getValue()));
        }
        return newMap;
    }

    public static String stringifyException(Throwable e) {
        StringWriter stm = new StringWriter();
        PrintWriter wrt = new PrintWriter(stm);
        e.printStackTrace(wrt);
        wrt.close();
        return stm.toString();
    }

    public static String simpleHostname(String fullHostname) {
        int offset = fullHostname.indexOf(46);
        if (offset != -1) {
            return fullHostname.substring(0, offset);
        }
        return fullHostname;
    }

    public static String humanReadableInt(long number) {
        long absNumber = Math.abs(number);
        double result = number;
        String suffix = "";
        if (absNumber < 1024L) {
            return String.valueOf(number);
        }
        if (absNumber < 0x100000L) {
            result = (double)number / 1024.0;
            suffix = "k";
        } else if (absNumber < 0x40000000L) {
            result = (double)number / 1048576.0;
            suffix = "m";
        } else {
            result = (double)number / 1.073741824E9;
            suffix = "g";
        }
        return oneDecimal.format(result) + suffix;
    }

    public static String formatPercent(double done, int digits) {
        DecimalFormat percentFormat = new DecimalFormat("0.00%");
        double scale = Math.pow(10.0, digits + 2);
        double rounded = Math.floor(done * scale);
        percentFormat.setDecimalSeparatorAlwaysShown(false);
        percentFormat.setMinimumFractionDigits(digits);
        percentFormat.setMaximumFractionDigits(digits);
        return percentFormat.format(rounded / scale);
    }

    public static String arrayToString(String[] strs) {
        if (strs.length == 0) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(strs[0]);
        for (int idx = 1; idx < strs.length; ++idx) {
            sbuf.append(COMMA_STR);
            sbuf.append(strs[idx]);
        }
        return sbuf.toString();
    }

    public static String byteToHexString(byte[] bytes, int start, int end) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes == null");
        }
        StringBuilder s = new StringBuilder();
        for (int i = start; i < end; ++i) {
            s.append(String.format("%02x", bytes[i]));
        }
        return s.toString();
    }

    public static String byteToHexString(byte[] bytes) {
        return HiveStringUtils.byteToHexString(bytes, 0, bytes.length);
    }

    public static byte[] hexStringToByte(String hex) {
        byte[] bts = new byte[hex.length() / 2];
        for (int i = 0; i < bts.length; ++i) {
            bts[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bts;
    }

    public static String uriToString(URI[] uris) {
        if (uris == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(uris[0].toString());
        for (int i = 1; i < uris.length; ++i) {
            ret.append(COMMA_STR);
            ret.append(uris[i].toString());
        }
        return ret.toString();
    }

    public static URI[] stringToURI(String[] str) {
        if (str == null) {
            return null;
        }
        URI[] uris = new URI[str.length];
        for (int i = 0; i < str.length; ++i) {
            try {
                uris[i] = new URI(str[i]);
                continue;
            }
            catch (URISyntaxException ur) {
                throw new IllegalArgumentException("Failed to create uri for " + str[i], ur);
            }
        }
        return uris;
    }

    public static Path[] stringToPath(String[] str) {
        if (str == null) {
            return null;
        }
        Path[] p = new Path[str.length];
        for (int i = 0; i < str.length; ++i) {
            p[i] = new Path(str[i]);
        }
        return p;
    }

    public static String formatTimeDiff(long finishTime, long startTime) {
        long timeDiff = finishTime - startTime;
        return HiveStringUtils.formatTime(timeDiff);
    }

    public static String formatTime(long timeDiff) {
        StringBuilder buf = new StringBuilder();
        long hours = timeDiff / 3600000L;
        long rem = timeDiff % 3600000L;
        long minutes = rem / 60000L;
        long seconds = (rem %= 60000L) / 1000L;
        if (hours != 0L) {
            buf.append(hours);
            buf.append("hrs, ");
        }
        if (minutes != 0L) {
            buf.append(minutes);
            buf.append("mins, ");
        }
        buf.append(seconds);
        buf.append("sec");
        return buf.toString();
    }

    public static String getFormattedTimeWithDiff(DateFormat dateFormat, long finishTime, long startTime) {
        StringBuilder buf = new StringBuilder();
        if (0L != finishTime) {
            buf.append(dateFormat.format(new Date(finishTime)));
            if (0L != startTime) {
                buf.append(" (" + HiveStringUtils.formatTimeDiff(finishTime, startTime) + ")");
            }
        }
        return buf.toString();
    }

    public static String[] getStrings(String str) {
        Collection<String> values = HiveStringUtils.getStringCollection(str);
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public static Collection<String> getStringCollection(String str) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, COMMA_STR);
        values = new ArrayList();
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values;
    }

    public static Collection<String> getTrimmedStringCollection(String str) {
        return new ArrayList<String>(Arrays.asList(HiveStringUtils.getTrimmedStrings(str)));
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || "".equals(str.trim())) {
            return emptyStringArray;
        }
        return str.trim().split("\\s*,\\s*");
    }

    public static String[] split(String str) {
        return HiveStringUtils.split(str, '\\', ',');
    }

    public static String[] split(String str, char escapeChar, char separator) {
        if (str == null) {
            return null;
        }
        ArrayList<String> strList = new ArrayList<String>();
        StringBuilder split = new StringBuilder();
        int index = 0;
        while ((index = HiveStringUtils.findNext(str, separator, escapeChar, index, split)) >= 0) {
            ++index;
            strList.add(split.toString());
            split.setLength(0);
        }
        strList.add(split.toString());
        int last = strList.size();
        while (--last >= 0 && "".equals(strList.get(last))) {
            strList.remove(last);
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static String[] split(String str, char separator) {
        if ("".equals(str)) {
            return new String[]{""};
        }
        ArrayList<String> strList = new ArrayList<String>();
        int startIndex = 0;
        int nextIndex = 0;
        while ((nextIndex = str.indexOf(separator, startIndex)) != -1) {
            strList.add(str.substring(startIndex, nextIndex));
            startIndex = nextIndex + 1;
        }
        strList.add(str.substring(startIndex));
        int last = strList.size();
        while (--last >= 0 && "".equals(strList.get(last))) {
            strList.remove(last);
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static String[] splitAndUnEscape(String str) {
        return HiveStringUtils.splitAndUnEscape(str, '\\', ',');
    }

    public static String[] splitAndUnEscape(String str, char escapeChar, char separator) {
        String[] result = HiveStringUtils.split(str, escapeChar, separator);
        if (result != null) {
            for (int idx = 0; idx < result.length; ++idx) {
                result[idx] = HiveStringUtils.unEscapeString(result[idx], escapeChar, separator);
            }
        }
        return result;
    }

    public static String insertValue(String key, String newValue, String strKvPairs) {
        String[] keyValuePairs = HiveStringUtils.split(strKvPairs);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyValuePairs.length; ++i) {
            String[] pair = HiveStringUtils.split(keyValuePairs[i], '\\', '=');
            if (pair.length != 2) {
                throw new RuntimeException("Error parsing the keyvalue pair " + keyValuePairs[i]);
            }
            sb.append(pair[0]);
            sb.append('=');
            if (pair[0].equals(key)) {
                sb.append(newValue);
            } else {
                sb.append(pair[1]);
            }
            if (i >= keyValuePairs.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static int findNext(String str, char separator, char escapeChar, int start, StringBuilder split) {
        int numPreEscapes = 0;
        for (int i = start; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (numPreEscapes == 0 && curChar == separator) {
                return i;
            }
            split.append(curChar);
            numPreEscapes = curChar == escapeChar ? ++numPreEscapes % 2 : 0;
        }
        return -1;
    }

    public static String escapeString(String str) {
        return HiveStringUtils.escapeString(str, '\\', ',');
    }

    public static String escapeString(String str, char escapeChar, char charToEscape) {
        return HiveStringUtils.escapeString(str, escapeChar, new char[]{charToEscape});
    }

    private static boolean hasChar(char[] chars, char character) {
        for (char target : chars) {
            if (character != target) continue;
            return true;
        }
        return false;
    }

    public static String escapeString(String str, char escapeChar, char[] charsToEscape) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (curChar == escapeChar || HiveStringUtils.hasChar(charsToEscape, curChar)) {
                result.append(escapeChar);
            }
            result.append(curChar);
        }
        return result.toString();
    }

    public static String escapeJava(String str) {
        return ESCAPE_JAVA.translate(str);
    }

    public static String escapeHiveCommand(String str) {
        return ESCAPE_HIVE_COMMAND.translate(str);
    }

    public static String unEscapeString(String str) {
        return HiveStringUtils.unEscapeString(str, '\\', ',');
    }

    public static String unEscapeString(String str, char escapeChar, char charToEscape) {
        return HiveStringUtils.unEscapeString(str, escapeChar, new char[]{charToEscape});
    }

    public static String unEscapeString(String str, char escapeChar, char[] charsToEscape) {
        if (str == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(str.length());
        boolean hasPreEscape = false;
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            if (hasPreEscape) {
                if (curChar != escapeChar && !HiveStringUtils.hasChar(charsToEscape, curChar)) {
                    throw new IllegalArgumentException("Illegal escaped string " + str + " unescaped " + escapeChar + " at " + (i - 1));
                }
                result.append(curChar);
                hasPreEscape = false;
                continue;
            }
            if (HiveStringUtils.hasChar(charsToEscape, curChar)) {
                throw new IllegalArgumentException("Illegal escaped string " + str + " unescaped " + curChar + " at " + i);
            }
            if (curChar == escapeChar) {
                hasPreEscape = true;
                continue;
            }
            result.append(curChar);
        }
        if (hasPreEscape) {
            throw new IllegalArgumentException("Illegal escaped string " + str + ", not expecting " + escapeChar + " in the end.");
        }
        return result.toString();
    }

    private static String toStartupShutdownString(String prefix, String[] msg) {
        StringBuilder b = new StringBuilder(prefix);
        b.append("\n/************************************************************");
        for (String s : msg) {
            b.append("\n" + prefix + s);
        }
        b.append("\n************************************************************/");
        return b.toString();
    }

    public static void startupShutdownMessage(Class<?> clazz, String[] args, final Logger LOG) {
        final String hostname = HiveStringUtils.getHostname();
        final String classname = clazz.getSimpleName();
        LOG.info(HiveStringUtils.toStartupShutdownString("STARTUP_MSG: ", new String[]{"Starting " + classname, "  host = " + hostname, "  args = " + Arrays.asList(args), "  version = " + HiveVersionInfo.getVersion(), "  classpath = " + System.getProperty("java.class.path"), "  build = " + HiveVersionInfo.getUrl() + " -r " + HiveVersionInfo.getRevision() + "; compiled by '" + HiveVersionInfo.getUser() + "' on " + HiveVersionInfo.getDate()}));
        ShutdownHookManager.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                LOG.info(HiveStringUtils.toStartupShutdownString("SHUTDOWN_MSG: ", new String[]{"Shutting down " + classname + " at " + hostname}));
            }
        }, 0);
    }

    public static String getHostname() {
        try {
            return "" + InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            return "" + uhe;
        }
    }

    public static String escapeHTML(String string) {
        char[] chars;
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean lastCharacterWasSpace = false;
        block6: for (char c : chars = string.toCharArray()) {
            if (c == ' ') {
                if (lastCharacterWasSpace) {
                    lastCharacterWasSpace = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastCharacterWasSpace = true;
                sb.append(" ");
                continue;
            }
            lastCharacterWasSpace = false;
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String byteDesc(long len) {
        double val = 0.0;
        String ending = "";
        if (len < 0x100000L) {
            val = 1.0 * (double)len / 1024.0;
            ending = " KB";
        } else if (len < 0x40000000L) {
            val = 1.0 * (double)len / 1048576.0;
            ending = " MB";
        } else if (len < 0x10000000000L) {
            val = 1.0 * (double)len / 1.073741824E9;
            ending = " GB";
        } else if (len < 0x4000000000000L) {
            val = 1.0 * (double)len / 1.099511627776E12;
            ending = " TB";
        } else {
            val = 1.0 * (double)len / 1.125899906842624E15;
            ending = " PB";
        }
        return HiveStringUtils.limitDecimalTo2(val) + ending;
    }

    public static synchronized String limitDecimalTo2(double d) {
        return decimalFormat.format(d);
    }

    public static String join(CharSequence separator, Iterable<?> strings) {
        Iterator<?> i = strings.iterator();
        if (!i.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(i.next().toString());
        while (i.hasNext()) {
            sb.append(separator);
            sb.append(i.next().toString());
        }
        return sb.toString();
    }

    public static String joinIgnoringEmpty(String[] strings, char separator) {
        ArrayList<String> list = new ArrayList<String>();
        for (String str : strings) {
            if (!StringUtils.isNotBlank(str)) continue;
            list.add(str);
        }
        return StringUtils.join(list, separator);
    }

    public static String camelize(String s) {
        String[] words;
        StringBuilder sb = new StringBuilder();
        for (String word : words = HiveStringUtils.split(s.toLowerCase(Locale.US), '\\', '_')) {
            sb.append(StringUtils.capitalize(word));
        }
        return sb.toString();
    }

    public static boolean isUtfStartByte(byte b) {
        return (b & 0xC0) != 128;
    }

    public static int getTextUtfLength(Text t) {
        byte[] data = t.getBytes();
        int len = 0;
        for (int i = 0; i < t.getLength(); ++i) {
            if (!HiveStringUtils.isUtfStartByte(data[i])) continue;
            ++len;
        }
        return len;
    }

    public static String normalizeIdentifier(String identifier) {
        return identifier.trim().toLowerCase();
    }

    public static Map getPropertiesExplain(Properties properties) {
        String value;
        if (properties != null && (value = properties.getProperty("columns.comments")) != null) {
            HashMap<Object, Object> clone = new HashMap<Object, Object>(properties);
            clone.put("columns.comments", HiveStringUtils.quoteComments(value));
            return clone;
        }
        return properties;
    }

    public static String quoteComments(String value) {
        char[] chars = value.toCharArray();
        if (!HiveStringUtils.commentProvided(chars)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int prev = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\u0000') continue;
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append('\'').append(chars, prev, i - prev).append('\'');
            prev = i + 1;
        }
        builder.append(",'").append(chars, prev, chars.length - prev).append('\'');
        return builder.toString();
    }

    public static boolean commentProvided(char[] chars) {
        for (char achar : chars) {
            if (achar == '\u0000') continue;
            return true;
        }
        return false;
    }

    public static String getPartitionValWithInvalidCharacter(List<String> partVals, Pattern partitionValidationPattern) {
        if (partitionValidationPattern == null) {
            return null;
        }
        for (String partVal : partVals) {
            if (partitionValidationPattern.matcher(partVal).matches()) continue;
            return partVal;
        }
        return null;
    }

    static {
        ESCAPE_JAVA = new LookupTranslator({"\"", "\\\""}, {"\\", "\\\\"}).with(new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()));
        ESCAPE_HIVE_COMMAND = new LookupTranslator({"'", "\\'"}, {";", "\\;"}, {"\\", "\\\\"}).with(new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()));
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
        decimalFormat = (DecimalFormat)numberFormat;
        decimalFormat.applyPattern("#.##");
        STRING_INTERNER = Interners.newWeakInterner();
        oneDecimal = new DecimalFormat("0.0");
        emptyStringArray = new String[0];
    }

    public static enum TraditionalBinaryPrefix {
        KILO(1024L),
        MEGA(TraditionalBinaryPrefix.KILO.value << 10),
        GIGA(TraditionalBinaryPrefix.MEGA.value << 10),
        TERA(TraditionalBinaryPrefix.GIGA.value << 10),
        PETA(TraditionalBinaryPrefix.TERA.value << 10),
        EXA(TraditionalBinaryPrefix.PETA.value << 10);

        public final long value;
        public final char symbol;

        private TraditionalBinaryPrefix(long value) {
            this.value = value;
            this.symbol = this.toString().charAt(0);
        }

        public static TraditionalBinaryPrefix valueOf(char symbol) {
            symbol = Character.toUpperCase(symbol);
            for (TraditionalBinaryPrefix prefix : TraditionalBinaryPrefix.values()) {
                if (symbol != prefix.symbol) continue;
                return prefix;
            }
            throw new IllegalArgumentException("Unknown symbol '" + symbol + "'");
        }

        public static long string2long(String s) {
            long prefix;
            int lastpos;
            char lastchar = (s = s.trim()).charAt(lastpos = s.length() - 1);
            if (Character.isDigit(lastchar)) {
                return Long.parseLong(s);
            }
            try {
                prefix = TraditionalBinaryPrefix.valueOf((char)lastchar).value;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid size prefix '" + lastchar + "' in '" + s + "'. Allowed prefixes are k, m, g, t, p, e(case insensitive)");
            }
            long num = Long.parseLong(s.substring(0, lastpos));
            if (num > Long.MAX_VALUE / prefix || num < Long.MIN_VALUE / prefix) {
                throw new IllegalArgumentException(s + " does not fit in a Long");
            }
            return num * prefix;
        }
    }
}

