/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.FileOutputFormatContainer;
import org.apache.hive.hcatalog.mapreduce.HCatFileUtil;
import org.apache.hive.hcatalog.mapreduce.HCatTableInfo;
import org.apache.hive.hcatalog.mapreduce.InputJobInfo;
import org.apache.hive.hcatalog.mapreduce.OutputFormatContainer;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.hive.hcatalog.mapreduce.SpecialCases;

public class FosterStorageHandler
extends DefaultStorageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FosterStorageHandler.class);
    public Configuration conf;
    protected static final String TEMP_DIR_NAME = "_TEMP";
    private Class<? extends InputFormat> ifClass;
    private Class<? extends OutputFormat> ofClass;
    private Class<? extends AbstractSerDe> serDeClass;

    public FosterStorageHandler(String ifName, String ofName, String serdeName) throws ClassNotFoundException {
        this(JavaUtils.loadClass(ifName), JavaUtils.loadClass(ofName), JavaUtils.loadClass(serdeName));
    }

    public FosterStorageHandler(Class<? extends InputFormat> ifClass, Class<? extends OutputFormat> ofClass, Class<? extends AbstractSerDe> serDeClass) {
        this.ifClass = ifClass;
        this.ofClass = ofClass;
        this.serDeClass = serDeClass;
    }

    @Override
    public Class<? extends InputFormat> getInputFormatClass() {
        return this.ifClass;
    }

    @Override
    public Class<? extends OutputFormat> getOutputFormatClass() {
        return this.ofClass;
    }

    @Override
    public Class<? extends AbstractSerDe> getSerDeClass() {
        return this.serDeClass;
    }

    @Override
    public HiveMetaHook getMetaHook() {
        return null;
    }

    @Override
    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
    }

    @Override
    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try {
            Map<String, String> tableProperties = tableDesc.getJobProperties();
            String jobInfoProperty = tableProperties.get("mapreduce.lib.hcat.job.info");
            if (jobInfoProperty != null) {
                InputJobInfo inputJobInfo = (InputJobInfo)HCatUtil.deserialize(jobInfoProperty);
                HCatTableInfo tableInfo = inputJobInfo.getTableInfo();
                HCatSchema dataColumns = tableInfo.getDataColumns();
                List<HCatFieldSchema> dataFields = dataColumns.getFields();
                StringBuilder columnNamesSb = new StringBuilder();
                StringBuilder typeNamesSb = new StringBuilder();
                for (HCatFieldSchema dataField : dataFields) {
                    if (columnNamesSb.length() > 0) {
                        columnNamesSb.append(",");
                        typeNamesSb.append(":");
                    }
                    columnNamesSb.append(dataField.getName());
                    typeNamesSb.append(dataField.getTypeString());
                }
                jobProperties.put("schema.evolution.columns", columnNamesSb.toString());
                jobProperties.put("schema.evolution.columns.types", typeNamesSb.toString());
                boolean isAcidTable = AcidUtils.isTablePropertyTransactional(tableProperties);
                AcidUtils.setTransactionalTableScan(jobProperties, isAcidTable);
                AcidUtils.AcidOperationalProperties acidOperationalProperties = AcidUtils.getAcidOperationalProperties(tableProperties);
                AcidUtils.setAcidOperationalProperties(jobProperties, acidOperationalProperties);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to set output path", e);
        }
    }

    @Override
    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        try {
            String outputLocation;
            OutputJobInfo jobInfo = (OutputJobInfo)HCatUtil.deserialize(tableDesc.getJobProperties().get("mapreduce.lib.hcatoutput.info"));
            String parentPath = jobInfo.getTableInfo().getTableLocation();
            String dynHash = tableDesc.getJobProperties().get("mapreduce.lib.hcatoutput.dynamic.jobid");
            String idHash = tableDesc.getJobProperties().get("mapreduce.lib.hcatoutput.id");
            if (dynHash != null) {
                if (Boolean.parseBoolean((String)tableDesc.getProperties().get("EXTERNAL")) && jobInfo.getCustomDynamicRoot() != null && jobInfo.getCustomDynamicRoot().length() > 0) {
                    parentPath = new Path(parentPath, jobInfo.getCustomDynamicRoot()).toString();
                }
                parentPath = new Path(parentPath, "_DYN" + dynHash).toString();
            } else {
                parentPath = new Path(parentPath, "_SCRATCH" + idHash).toString();
            }
            if (dynHash != null && Boolean.parseBoolean((String)tableDesc.getProperties().get("EXTERNAL")) && jobInfo.getCustomDynamicPath() != null && jobInfo.getCustomDynamicPath().length() > 0) {
                outputLocation = HCatFileUtil.resolveCustomPath(jobInfo, null, true);
            } else if (dynHash == null && Boolean.parseBoolean((String)tableDesc.getProperties().get("EXTERNAL")) && jobInfo.getLocation() != null && jobInfo.getLocation().length() > 0) {
                outputLocation = jobInfo.getLocation();
            } else if (dynHash == null && jobInfo.getPartitionValues().size() == 0) {
                outputLocation = "";
            } else {
                ArrayList<String> cols = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                for (String name : jobInfo.getTableInfo().getPartitionColumns().getFieldNames()) {
                    String value = jobInfo.getPartitionValues().get(name);
                    cols.add(name);
                    values.add(value);
                }
                outputLocation = FileUtils.makePartName(cols, values);
            }
            if (outputLocation != null && !outputLocation.isEmpty()) {
                jobInfo.setLocation(new Path(parentPath, outputLocation).toString());
            } else {
                jobInfo.setLocation(new Path(parentPath).toString());
            }
            if (jobInfo.getPartitionValues().size() == jobInfo.getTableInfo().getPartitionColumns().size()) {
                jobProperties.put("mapred.output.dir", jobInfo.getLocation());
            }
            SpecialCases.addSpecialCasesParametersToOutputJobProperties(jobProperties, jobInfo, this.ofClass);
            jobProperties.put("mapreduce.lib.hcatoutput.info", HCatUtil.serialize(jobInfo));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to set output path", e);
        }
    }

    @Override
    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
    }

    OutputFormatContainer getOutputFormatContainer(OutputFormat outputFormat) {
        return new FileOutputFormatContainer(outputFormat);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return new DefaultHiveAuthorizationProvider();
    }
}

