// Copyright (c) 2003-2014, Jodd Team (io.prestosql.hive.$internal.jodd.org). All Rights Reserved.

package io.prestosql.hive.$internal.jodd;

import io.prestosql.hive.$internal.jodd.io.FileUtilParams;
import io.prestosql.hive.$internal.jodd.util.StringPool;
import io.prestosql.hive.$internal.jodd.util.cl.ClassLoaderStrategy;
import io.prestosql.hive.$internal.jodd.util.cl.DefaultClassLoaderStrategy;

/**
 * Jodd CORE module.
 * Contains some global defaults.
 */
public class JoddCore {

	static {
		Jodd.module();
	}

	/**
	 * Default temp file prefix.
	 */
	public static String tempFilePrefix = "io.prestosql.hive.$internal.jodd-";

	/**
	 * Default file encoding (UTF8).
	 */
	public static String encoding = StringPool.UTF_8;

	/**
	 * Default IO buffer size (16 KB).
	 */
	public static int ioBufferSize = 16384;

	/**
	 * Default parameters used in {@link io.prestosql.hive.$internal.jodd.io.FileUtil} operations.
	 */
	public static FileUtilParams fileUtilParams = new FileUtilParams();

	/**
	 * Default class loader strategy.
	 */
	public static ClassLoaderStrategy classLoaderStrategy = new DefaultClassLoaderStrategy();

}