// Copyright (c) 2003-2014, Jodd Team (io.prestosql.hive.$internal.jodd.org). All Rights Reserved.

package io.prestosql.hive.$internal.jodd.io.findfile;

import io.prestosql.hive.$internal.jodd.util.ClassLoaderUtil;

import java.net.URL;
import java.io.File;

/**
 * A class scanner, user-friendly version of {@link ClassFinder} a class scanner.
 * Since <code>ClassFinder</code> is an abstract class, it can not be used directly,
 * <code>ClassScanner</code> can.
 */
public abstract class ClassScanner extends ClassFinder {

	/**
	 * Scans provided classpath.
	 */
	public void scan(URL... urls) {
		scanUrls(urls);
	}

	/**
	 * Scans {@link io.prestosql.hive.$internal.jodd.util.ClassLoaderUtil#getDefaultClasspath() default class path}.
	 */
	public void scanDefaultClasspath() {
		scan(ClassLoaderUtil.getDefaultClasspath());
	}

	/**
	 * Scans provided paths.
	 */
	public void scan(File... paths) {
		scanPaths(paths);
	}

	/**
	 * Scans provided paths.
	 */
	public void scan(String... paths) {
		scanPaths(paths);
	}

}
