// Copyright (c) 2003-2014, Jodd Team (io.prestosql.hive.$internal.jodd.org). All Rights Reserved.

package io.prestosql.hive.$internal.jodd.io.findfile;

import io.prestosql.hive.$internal.jodd.util.Wildcard;

import java.io.File;

/**
 * {@link FindFile} that matches file names using <code>*</code>, <code>?</code>
 * and <code>**</code> wildcards.
 *
 * @see io.prestosql.hive.$internal.jodd.io.findfile.RegExpFindFile
 */
public class WildcardFindFile extends FindFile<WildcardFindFile> {

	@Override
	protected boolean match(String path, String pattern) {
		return Wildcard.matchPath(path, pattern);
	}

}