// Copyright (c) 2003-2014, Jodd Team (io.prestosql.hive.$internal.jodd.org). All Rights Reserved.

package io.prestosql.hive.$internal.jodd.typeconverter.impl;

import io.prestosql.hive.$internal.jodd.mutable.MutableByte;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverter;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverterManagerBean;

/**
 * Converts given object to {@link MutableByte}.
 */
public class MutableByteConverter implements TypeConverter<MutableByte> {

	protected final TypeConverter<Byte> typeConverter;

	@SuppressWarnings("unchecked")
	public MutableByteConverter(TypeConverterManagerBean typeConverterManagerBean) {
		typeConverter = typeConverterManagerBean.lookup(Byte.class);
	}

	public MutableByte convert(Object value) {
		if (value == null) {
			return null;
		}

		if (value.getClass() == MutableByte.class) {
			return (MutableByte) value;
		}

		return new MutableByte(typeConverter.convert(value));
	}

}