// Copyright (c) 2003-2014, Jodd Team (io.prestosql.hive.$internal.jodd.org). All Rights Reserved.

package io.prestosql.hive.$internal.jodd.typeconverter.impl;

import io.prestosql.hive.$internal.jodd.mutable.MutableDouble;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverter;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverterManagerBean;

/**
 * Converts given object to {@link MutableDouble}.
 */
public class MutableDoubleConverter implements TypeConverter<MutableDouble> {

	protected final TypeConverter<Double> typeConverter;

	@SuppressWarnings("unchecked")
	public MutableDoubleConverter(TypeConverterManagerBean typeConverterManagerBean) {
		typeConverter = typeConverterManagerBean.lookup(Double.class);
	}

	public MutableDouble convert(Object value) {
		if (value == null) {
			return null;
		}

		if (value.getClass() == MutableDouble.class) {
			return (MutableDouble) value;
		}

		return new MutableDouble(typeConverter.convert(value));
	}

}