// Copyright (c) 2003-2014, Jodd Team (io.prestosql.hive.$internal.jodd.org). All Rights Reserved.

package io.prestosql.hive.$internal.jodd.typeconverter.impl;

import io.prestosql.hive.$internal.jodd.mutable.MutableFloat;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverter;
import io.prestosql.hive.$internal.jodd.typeconverter.TypeConverterManagerBean;

/**
 * Converts given object to {@link MutableFloat}.
 */
public class MutableFloatConverter implements TypeConverter<MutableFloat> {

	protected final TypeConverter<Float> typeConverter;

	@SuppressWarnings("unchecked")
	public MutableFloatConverter(TypeConverterManagerBean typeConverterManagerBean) {
		typeConverter = typeConverterManagerBean.lookup(Float.class);
	}

	public MutableFloat convert(Object value) {
		if (value == null) {
			return null;
		}
		
		if (value.getClass() == MutableFloat.class) {
			return (MutableFloat) value;
		}

		return new MutableFloat(typeConverter.convert(value));
	}

}